// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appstream.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a stack.
 */
class Stack private constructor(builder: Builder) {
    /**
     * The list of virtual private cloud (VPC) interface endpoint objects. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.
     */
    val accessEndpoints: List<AccessEndpoint>? = builder.accessEndpoints
    /**
     * The persistent application settings for users of the stack.
     */
    val applicationSettings: aws.sdk.kotlin.services.appstream.model.ApplicationSettingsResponse? = builder.applicationSettings
    /**
     * The ARN of the stack.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The time the stack was created.
     */
    val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * The description to display.
     */
    val description: kotlin.String? = builder.description
    /**
     * The stack name to display.
     */
    val displayName: kotlin.String? = builder.displayName
    /**
     * The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions.
     */
    val embedHostDomains: List<String>? = builder.embedHostDomains
    /**
     * The URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed.
     */
    val feedbackUrl: kotlin.String? = builder.feedbackUrl
    /**
     * The name of the stack.
     */
    val name: kotlin.String? = builder.name
    /**
     * The URL that users are redirected to after their streaming session ends.
     */
    val redirectUrl: kotlin.String? = builder.redirectUrl
    /**
     * The errors for the stack.
     */
    val stackErrors: List<StackError>? = builder.stackErrors
    /**
     * The storage connectors to enable.
     */
    val storageConnectors: List<StorageConnector>? = builder.storageConnectors
    /**
     * The actions that are enabled or disabled for users during their streaming sessions. By default these actions are enabled.
     */
    val userSettings: List<UserSetting>? = builder.userSettings

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appstream.model.Stack = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Stack(")
        append("accessEndpoints=$accessEndpoints,")
        append("applicationSettings=$applicationSettings,")
        append("arn=$arn,")
        append("createdTime=$createdTime,")
        append("description=$description,")
        append("displayName=$displayName,")
        append("embedHostDomains=$embedHostDomains,")
        append("feedbackUrl=$feedbackUrl,")
        append("name=$name,")
        append("redirectUrl=$redirectUrl,")
        append("stackErrors=$stackErrors,")
        append("storageConnectors=$storageConnectors,")
        append("userSettings=$userSettings)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessEndpoints?.hashCode() ?: 0
        result = 31 * result + (applicationSettings?.hashCode() ?: 0)
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (embedHostDomains?.hashCode() ?: 0)
        result = 31 * result + (feedbackUrl?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (redirectUrl?.hashCode() ?: 0)
        result = 31 * result + (stackErrors?.hashCode() ?: 0)
        result = 31 * result + (storageConnectors?.hashCode() ?: 0)
        result = 31 * result + (userSettings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Stack

        if (accessEndpoints != other.accessEndpoints) return false
        if (applicationSettings != other.applicationSettings) return false
        if (arn != other.arn) return false
        if (createdTime != other.createdTime) return false
        if (description != other.description) return false
        if (displayName != other.displayName) return false
        if (embedHostDomains != other.embedHostDomains) return false
        if (feedbackUrl != other.feedbackUrl) return false
        if (name != other.name) return false
        if (redirectUrl != other.redirectUrl) return false
        if (stackErrors != other.stackErrors) return false
        if (storageConnectors != other.storageConnectors) return false
        if (userSettings != other.userSettings) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appstream.model.Stack = Builder(this).apply(block).build()

    class Builder {
        /**
         * The list of virtual private cloud (VPC) interface endpoint objects. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.
         */
        var accessEndpoints: List<AccessEndpoint>? = null
        /**
         * The persistent application settings for users of the stack.
         */
        var applicationSettings: aws.sdk.kotlin.services.appstream.model.ApplicationSettingsResponse? = null
        /**
         * The ARN of the stack.
         */
        var arn: kotlin.String? = null
        /**
         * The time the stack was created.
         */
        var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description to display.
         */
        var description: kotlin.String? = null
        /**
         * The stack name to display.
         */
        var displayName: kotlin.String? = null
        /**
         * The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions.
         */
        var embedHostDomains: List<String>? = null
        /**
         * The URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed.
         */
        var feedbackUrl: kotlin.String? = null
        /**
         * The name of the stack.
         */
        var name: kotlin.String? = null
        /**
         * The URL that users are redirected to after their streaming session ends.
         */
        var redirectUrl: kotlin.String? = null
        /**
         * The errors for the stack.
         */
        var stackErrors: List<StackError>? = null
        /**
         * The storage connectors to enable.
         */
        var storageConnectors: List<StorageConnector>? = null
        /**
         * The actions that are enabled or disabled for users during their streaming sessions. By default these actions are enabled.
         */
        var userSettings: List<UserSetting>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appstream.model.Stack) : this() {
            this.accessEndpoints = x.accessEndpoints
            this.applicationSettings = x.applicationSettings
            this.arn = x.arn
            this.createdTime = x.createdTime
            this.description = x.description
            this.displayName = x.displayName
            this.embedHostDomains = x.embedHostDomains
            this.feedbackUrl = x.feedbackUrl
            this.name = x.name
            this.redirectUrl = x.redirectUrl
            this.stackErrors = x.stackErrors
            this.storageConnectors = x.storageConnectors
            this.userSettings = x.userSettings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appstream.model.Stack = Stack(this)

        /**
         * construct an [aws.sdk.kotlin.services.appstream.model.ApplicationSettingsResponse] inside the given [block]
         */
        fun applicationSettings(block: aws.sdk.kotlin.services.appstream.model.ApplicationSettingsResponse.Builder.() -> kotlin.Unit) {
            this.applicationSettings = aws.sdk.kotlin.services.appstream.model.ApplicationSettingsResponse.invoke(block)
        }
    }
}
