// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appstream.model



class UpdateStackRequest private constructor(builder: Builder) {
    /**
     * The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.
     */
    val accessEndpoints: List<AccessEndpoint>? = builder.accessEndpoints
    /**
     * The persistent application settings for users of a stack. When these settings are enabled, changes that users make to applications and Windows settings are automatically saved after each session and applied to the next session.
     */
    val applicationSettings: aws.sdk.kotlin.services.appstream.model.ApplicationSettings? = builder.applicationSettings
    /**
     * The stack attributes to delete.
     */
    val attributesToDelete: List<StackAttribute>? = builder.attributesToDelete
    /**
     * Deletes the storage connectors currently enabled for the stack.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    val deleteStorageConnectors: kotlin.Boolean = builder.deleteStorageConnectors
    /**
     * The description to display.
     */
    val description: kotlin.String? = builder.description
    /**
     * The stack name to display.
     */
    val displayName: kotlin.String? = builder.displayName
    /**
     * The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions.
     */
    val embedHostDomains: List<String>? = builder.embedHostDomains
    /**
     * The URL that users are redirected to after they choose the Send Feedback link. If no URL is specified, no Send Feedback link is displayed.
     */
    val feedbackUrl: kotlin.String? = builder.feedbackUrl
    /**
     * The name of the stack.
     */
    val name: kotlin.String? = builder.name
    /**
     * The URL that users are redirected to after their streaming session ends.
     */
    val redirectUrl: kotlin.String? = builder.redirectUrl
    /**
     * The storage connectors to enable.
     */
    val storageConnectors: List<StorageConnector>? = builder.storageConnectors
    /**
     * The actions that are enabled or disabled for users during their streaming sessions. By default, these actions are enabled.
     */
    val userSettings: List<UserSetting>? = builder.userSettings

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appstream.model.UpdateStackRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateStackRequest(")
        append("accessEndpoints=$accessEndpoints,")
        append("applicationSettings=$applicationSettings,")
        append("attributesToDelete=$attributesToDelete,")
        append("deleteStorageConnectors=$deleteStorageConnectors,")
        append("description=$description,")
        append("displayName=$displayName,")
        append("embedHostDomains=$embedHostDomains,")
        append("feedbackUrl=$feedbackUrl,")
        append("name=$name,")
        append("redirectUrl=$redirectUrl,")
        append("storageConnectors=$storageConnectors,")
        append("userSettings=$userSettings)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessEndpoints?.hashCode() ?: 0
        result = 31 * result + (applicationSettings?.hashCode() ?: 0)
        result = 31 * result + (attributesToDelete?.hashCode() ?: 0)
        result = 31 * result + (deleteStorageConnectors.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (embedHostDomains?.hashCode() ?: 0)
        result = 31 * result + (feedbackUrl?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (redirectUrl?.hashCode() ?: 0)
        result = 31 * result + (storageConnectors?.hashCode() ?: 0)
        result = 31 * result + (userSettings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateStackRequest

        if (accessEndpoints != other.accessEndpoints) return false
        if (applicationSettings != other.applicationSettings) return false
        if (attributesToDelete != other.attributesToDelete) return false
        if (deleteStorageConnectors != other.deleteStorageConnectors) return false
        if (description != other.description) return false
        if (displayName != other.displayName) return false
        if (embedHostDomains != other.embedHostDomains) return false
        if (feedbackUrl != other.feedbackUrl) return false
        if (name != other.name) return false
        if (redirectUrl != other.redirectUrl) return false
        if (storageConnectors != other.storageConnectors) return false
        if (userSettings != other.userSettings) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appstream.model.UpdateStackRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The list of interface VPC endpoint (interface endpoint) objects. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.
         */
        var accessEndpoints: List<AccessEndpoint>? = null
        /**
         * The persistent application settings for users of a stack. When these settings are enabled, changes that users make to applications and Windows settings are automatically saved after each session and applied to the next session.
         */
        var applicationSettings: aws.sdk.kotlin.services.appstream.model.ApplicationSettings? = null
        /**
         * The stack attributes to delete.
         */
        var attributesToDelete: List<StackAttribute>? = null
        /**
         * Deletes the storage connectors currently enabled for the stack.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        var deleteStorageConnectors: kotlin.Boolean = false
        /**
         * The description to display.
         */
        var description: kotlin.String? = null
        /**
         * The stack name to display.
         */
        var displayName: kotlin.String? = null
        /**
         * The domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions.
         */
        var embedHostDomains: List<String>? = null
        /**
         * The URL that users are redirected to after they choose the Send Feedback link. If no URL is specified, no Send Feedback link is displayed.
         */
        var feedbackUrl: kotlin.String? = null
        /**
         * The name of the stack.
         */
        var name: kotlin.String? = null
        /**
         * The URL that users are redirected to after their streaming session ends.
         */
        var redirectUrl: kotlin.String? = null
        /**
         * The storage connectors to enable.
         */
        var storageConnectors: List<StorageConnector>? = null
        /**
         * The actions that are enabled or disabled for users during their streaming sessions. By default, these actions are enabled.
         */
        var userSettings: List<UserSetting>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appstream.model.UpdateStackRequest) : this() {
            this.accessEndpoints = x.accessEndpoints
            this.applicationSettings = x.applicationSettings
            this.attributesToDelete = x.attributesToDelete
            this.deleteStorageConnectors = x.deleteStorageConnectors
            this.description = x.description
            this.displayName = x.displayName
            this.embedHostDomains = x.embedHostDomains
            this.feedbackUrl = x.feedbackUrl
            this.name = x.name
            this.redirectUrl = x.redirectUrl
            this.storageConnectors = x.storageConnectors
            this.userSettings = x.userSettings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appstream.model.UpdateStackRequest = UpdateStackRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.appstream.model.ApplicationSettings] inside the given [block]
         */
        fun applicationSettings(block: aws.sdk.kotlin.services.appstream.model.ApplicationSettings.Builder.() -> kotlin.Unit) {
            this.applicationSettings = aws.sdk.kotlin.services.appstream.model.ApplicationSettings.invoke(block)
        }
    }
}
