// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appstream.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes information about the usage report subscription.
 */
class UsageReportSubscription private constructor(builder: Builder) {
    /**
     * The time when the last usage report was generated.
     */
    val lastGeneratedReportDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastGeneratedReportDate
    /**
     * The Amazon S3 bucket where generated reports are stored.
     *
     * If you enabled on-instance session scripts and Amazon S3 logging for your session script configuration, AppStream 2.0 created an S3 bucket to store the script output. The bucket is unique to your account and Region. When you enable usage reporting in this case, AppStream 2.0 uses the same bucket to store your usage reports. If you haven't already enabled on-instance session scripts, when you enable usage reports, AppStream 2.0 creates a new S3 bucket.
     */
    val s3BucketName: kotlin.String? = builder.s3BucketName
    /**
     * The schedule for generating usage reports.
     */
    val schedule: aws.sdk.kotlin.services.appstream.model.UsageReportSchedule? = builder.schedule
    /**
     * The errors that were returned if usage reports couldn't be generated.
     */
    val subscriptionErrors: List<LastReportGenerationExecutionError>? = builder.subscriptionErrors

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appstream.model.UsageReportSubscription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UsageReportSubscription(")
        append("lastGeneratedReportDate=$lastGeneratedReportDate,")
        append("s3BucketName=$s3BucketName,")
        append("schedule=$schedule,")
        append("subscriptionErrors=$subscriptionErrors)")
    }

    override fun hashCode(): kotlin.Int {
        var result = lastGeneratedReportDate?.hashCode() ?: 0
        result = 31 * result + (s3BucketName?.hashCode() ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        result = 31 * result + (subscriptionErrors?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UsageReportSubscription

        if (lastGeneratedReportDate != other.lastGeneratedReportDate) return false
        if (s3BucketName != other.s3BucketName) return false
        if (schedule != other.schedule) return false
        if (subscriptionErrors != other.subscriptionErrors) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appstream.model.UsageReportSubscription = Builder(this).apply(block).build()

    class Builder {
        /**
         * The time when the last usage report was generated.
         */
        var lastGeneratedReportDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon S3 bucket where generated reports are stored.
         *
         * If you enabled on-instance session scripts and Amazon S3 logging for your session script configuration, AppStream 2.0 created an S3 bucket to store the script output. The bucket is unique to your account and Region. When you enable usage reporting in this case, AppStream 2.0 uses the same bucket to store your usage reports. If you haven't already enabled on-instance session scripts, when you enable usage reports, AppStream 2.0 creates a new S3 bucket.
         */
        var s3BucketName: kotlin.String? = null
        /**
         * The schedule for generating usage reports.
         */
        var schedule: aws.sdk.kotlin.services.appstream.model.UsageReportSchedule? = null
        /**
         * The errors that were returned if usage reports couldn't be generated.
         */
        var subscriptionErrors: List<LastReportGenerationExecutionError>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appstream.model.UsageReportSubscription) : this() {
            this.lastGeneratedReportDate = x.lastGeneratedReportDate
            this.s3BucketName = x.s3BucketName
            this.schedule = x.schedule
            this.subscriptionErrors = x.subscriptionErrors
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appstream.model.UsageReportSubscription = UsageReportSubscription(this)
    }
}
