// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appstream.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.appstream.model.AppStreamException
import aws.sdk.kotlin.services.appstream.model.CreateStreamingUrlResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class CreateStreamingURLOperationDeserializer: HttpDeserialize<CreateStreamingUrlResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateStreamingUrlResponse {
        if (!response.status.isSuccess()) {
            throwCreateStreamingUrlError(context, response)
        }
        val builder = CreateStreamingUrlResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateStreamingURLOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateStreamingUrlError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw AppStreamException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterCombinationException" -> InvalidParameterCombinationExceptionDeserializer().deserialize(context, wrappedResponse)
        "OperationNotPermittedException" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotAvailableException" -> ResourceNotAvailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> AppStreamException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateStreamingURLOperationBody(builder: CreateStreamingUrlResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val EXPIRES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("Expires"))
    val STREAMINGURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StreamingURL"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EXPIRES_DESCRIPTOR)
        field(STREAMINGURL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                EXPIRES_DESCRIPTOR.index -> builder.expires = deserializeString().let { Instant.fromEpochSeconds(it) }
                STREAMINGURL_DESCRIPTOR.index -> builder.streamingUrl = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
