// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appstream.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.appstream.model.AppStreamException
import aws.sdk.kotlin.services.appstream.model.CreateUsageReportSubscriptionResponse
import aws.sdk.kotlin.services.appstream.model.UsageReportSchedule
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateUsageReportSubscriptionOperationDeserializer: HttpDeserialize<CreateUsageReportSubscriptionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateUsageReportSubscriptionResponse {
        if (!response.status.isSuccess()) {
            throwCreateUsageReportSubscriptionError(context, response)
        }
        val builder = CreateUsageReportSubscriptionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateUsageReportSubscriptionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateUsageReportSubscriptionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw AppStreamException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidAccountStatusException" -> InvalidAccountStatusExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRoleException" -> InvalidRoleExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> AppStreamException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateUsageReportSubscriptionOperationBody(builder: CreateUsageReportSubscriptionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val S3BUCKETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("S3BucketName"))
    val SCHEDULE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Schedule"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(S3BUCKETNAME_DESCRIPTOR)
        field(SCHEDULE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                S3BUCKETNAME_DESCRIPTOR.index -> builder.s3BucketName = deserializeString()
                SCHEDULE_DESCRIPTOR.index -> builder.schedule = deserializeString().let { UsageReportSchedule.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
