// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appstream.waiters

import aws.sdk.kotlin.services.appstream.AppStreamClient
import aws.sdk.kotlin.services.appstream.model.DescribeFleetsRequest
import aws.sdk.kotlin.services.appstream.model.DescribeFleetsResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.util.flattenIfPossible
import kotlin.time.Duration.Companion.milliseconds


suspend fun AppStreamClient.waitUntilFleetStarted(request: DescribeFleetsRequest): Outcome<DescribeFleetsResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 30_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeFleetsRequest, DescribeFleetsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val fleets = it?.fleets
            val fleetsOrEmpty = fleets?.flattenIfPossible() ?: listOf()
            val projection = fleetsOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            (projection?.size ?: 0) > 1 && projection?.all { it?.toString() == "ACTIVE" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val fleets = it?.fleets
            val fleetsOrEmpty = fleets?.flattenIfPossible() ?: listOf()
            val projection = fleetsOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection?.any { it?.toString() == "PENDING_DEACTIVATE" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val fleets = it?.fleets
            val fleetsOrEmpty = fleets?.flattenIfPossible() ?: listOf()
            val projection = fleetsOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection?.any { it?.toString() == "INACTIVE" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeFleets(request) }
}

suspend fun AppStreamClient.waitUntilFleetStarted(block: DescribeFleetsRequest.Builder.() -> Unit): Outcome<DescribeFleetsResponse> =
    waitUntilFleetStarted(DescribeFleetsRequest.Builder().apply(block).build())

suspend fun AppStreamClient.waitUntilFleetStopped(request: DescribeFleetsRequest): Outcome<DescribeFleetsResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 30_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeFleetsRequest, DescribeFleetsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val fleets = it?.fleets
            val fleetsOrEmpty = fleets?.flattenIfPossible() ?: listOf()
            val projection = fleetsOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            (projection?.size ?: 0) > 1 && projection?.all { it?.toString() == "INACTIVE" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val fleets = it?.fleets
            val fleetsOrEmpty = fleets?.flattenIfPossible() ?: listOf()
            val projection = fleetsOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection?.any { it?.toString() == "PENDING_ACTIVATE" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val fleets = it?.fleets
            val fleetsOrEmpty = fleets?.flattenIfPossible() ?: listOf()
            val projection = fleetsOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection?.any { it?.toString() == "ACTIVE" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeFleets(request) }
}

suspend fun AppStreamClient.waitUntilFleetStopped(block: DescribeFleetsRequest.Builder.() -> Unit): Outcome<DescribeFleetsResponse> =
    waitUntilFleetStopped(DescribeFleetsRequest.Builder().apply(block).build())
