// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model



/**
 * The `ApiCache` object.
 */
public class ApiCache private constructor(builder: Builder) {
    /**
     * Caching behavior.
     * + **FULL_REQUEST_CACHING**: All requests are fully cached.
     * + **PER_RESOLVER_CACHING**: Individual resolvers that you specify are cached.
     */
    public val apiCachingBehavior: aws.sdk.kotlin.services.appsync.model.ApiCachingBehavior? = builder.apiCachingBehavior
    /**
     * At-rest encryption flag for cache. You cannot update this setting after creation.
     */
    public val atRestEncryptionEnabled: kotlin.Boolean = builder.atRestEncryptionEnabled
    /**
     * The cache instance status.
     * + **AVAILABLE**: The instance is available for use.
     * + **CREATING**: The instance is currently creating.
     * + **DELETING**: The instance is currently deleting.
     * + **MODIFYING**: The instance is currently modifying.
     * + **FAILED**: The instance has failed creation.
     */
    public val status: aws.sdk.kotlin.services.appsync.model.ApiCacheStatus? = builder.status
    /**
     * Transit encryption flag when connecting to cache. You cannot update this setting after creation.
     */
    public val transitEncryptionEnabled: kotlin.Boolean = builder.transitEncryptionEnabled
    /**
     * TTL in seconds for cache entries.
     *
     * Valid values are 1–3,600 seconds.
     */
    public val ttl: kotlin.Long = builder.ttl
    /**
     * The cache instance type. Valid values are
     * + `SMALL`
     * + `MEDIUM`
     * + `LARGE`
     * + `XLARGE`
     * + `LARGE_2X`
     * + `LARGE_4X`
     * + `LARGE_8X` (not available in all regions)
     * + `LARGE_12X`
     *
     * Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.
     *
     * The following legacy instance types are available, but their use is discouraged:
     * + **T2_SMALL**: A t2.small instance type.
     * + **T2_MEDIUM**: A t2.medium instance type.
     * + **R4_LARGE**: A r4.large instance type.
     * + **R4_XLARGE**: A r4.xlarge instance type.
     * + **R4_2XLARGE**: A r4.2xlarge instance type.
     * + **R4_4XLARGE**: A r4.4xlarge instance type.
     * + **R4_8XLARGE**: A r4.8xlarge instance type.
     */
    public val type: aws.sdk.kotlin.services.appsync.model.ApiCacheType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appsync.model.ApiCache = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApiCache(")
        append("apiCachingBehavior=$apiCachingBehavior,")
        append("atRestEncryptionEnabled=$atRestEncryptionEnabled,")
        append("status=$status,")
        append("transitEncryptionEnabled=$transitEncryptionEnabled,")
        append("ttl=$ttl,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiCachingBehavior?.hashCode() ?: 0
        result = 31 * result + (atRestEncryptionEnabled.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (transitEncryptionEnabled.hashCode())
        result = 31 * result + (ttl.hashCode())
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ApiCache

        if (apiCachingBehavior != other.apiCachingBehavior) return false
        if (atRestEncryptionEnabled != other.atRestEncryptionEnabled) return false
        if (status != other.status) return false
        if (transitEncryptionEnabled != other.transitEncryptionEnabled) return false
        if (ttl != other.ttl) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appsync.model.ApiCache = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Caching behavior.
         * + **FULL_REQUEST_CACHING**: All requests are fully cached.
         * + **PER_RESOLVER_CACHING**: Individual resolvers that you specify are cached.
         */
        public var apiCachingBehavior: aws.sdk.kotlin.services.appsync.model.ApiCachingBehavior? = null
        /**
         * At-rest encryption flag for cache. You cannot update this setting after creation.
         */
        public var atRestEncryptionEnabled: kotlin.Boolean = false
        /**
         * The cache instance status.
         * + **AVAILABLE**: The instance is available for use.
         * + **CREATING**: The instance is currently creating.
         * + **DELETING**: The instance is currently deleting.
         * + **MODIFYING**: The instance is currently modifying.
         * + **FAILED**: The instance has failed creation.
         */
        public var status: aws.sdk.kotlin.services.appsync.model.ApiCacheStatus? = null
        /**
         * Transit encryption flag when connecting to cache. You cannot update this setting after creation.
         */
        public var transitEncryptionEnabled: kotlin.Boolean = false
        /**
         * TTL in seconds for cache entries.
         *
         * Valid values are 1–3,600 seconds.
         */
        public var ttl: kotlin.Long = 0L
        /**
         * The cache instance type. Valid values are
         * + `SMALL`
         * + `MEDIUM`
         * + `LARGE`
         * + `XLARGE`
         * + `LARGE_2X`
         * + `LARGE_4X`
         * + `LARGE_8X` (not available in all regions)
         * + `LARGE_12X`
         *
         * Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.
         *
         * The following legacy instance types are available, but their use is discouraged:
         * + **T2_SMALL**: A t2.small instance type.
         * + **T2_MEDIUM**: A t2.medium instance type.
         * + **R4_LARGE**: A r4.large instance type.
         * + **R4_XLARGE**: A r4.xlarge instance type.
         * + **R4_2XLARGE**: A r4.2xlarge instance type.
         * + **R4_4XLARGE**: A r4.4xlarge instance type.
         * + **R4_8XLARGE**: A r4.8xlarge instance type.
         */
        public var type: aws.sdk.kotlin.services.appsync.model.ApiCacheType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appsync.model.ApiCache) : this() {
            this.apiCachingBehavior = x.apiCachingBehavior
            this.atRestEncryptionEnabled = x.atRestEncryptionEnabled
            this.status = x.status
            this.transitEncryptionEnabled = x.transitEncryptionEnabled
            this.ttl = x.ttl
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appsync.model.ApiCache = ApiCache(this)
    }
}
