// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model



/**
 * Describes an API key.
 *
 * Customers invoke AppSync GraphQL API operations with API keys as an identity mechanism. There are two key versions:
 *
 * **da1**: We introduced this version at launch in November 2017. These keys always expire after 7 days. Amazon DynamoDB TTL manages key expiration. These keys ceased to be valid after February 21, 2018, and they should no longer be used.
 * + `ListApiKeys` returns the expiration time in milliseconds.
 * + `CreateApiKey` returns the expiration time in milliseconds.
 * + `UpdateApiKey` is not available for this key version.
 * + `DeleteApiKey` deletes the item from the table.
 * + Expiration is stored in DynamoDB as milliseconds. This results in a bug where keys are not automatically deleted because DynamoDB expects the TTL to be stored in seconds. As a one-time action, we deleted these keys from the table on February 21, 2018.
 *
 * **da2**: We introduced this version in February 2018 when AppSync added support to extend key expiration.
 * + `ListApiKeys` returns the expiration time and deletion time in seconds.
 * + `CreateApiKey` returns the expiration time and deletion time in seconds and accepts a user-provided expiration time in seconds.
 * + `UpdateApiKey` returns the expiration time and and deletion time in seconds and accepts a user-provided expiration time in seconds. Expired API keys are kept for 60 days after the expiration time. You can update the key expiration time as long as the key isn't deleted.
 * + `DeleteApiKey` deletes the item from the table.
 * + Expiration is stored in DynamoDB as seconds. After the expiration time, using the key to authenticate will fail. However, you can reinstate the key before deletion.
 * + Deletion is stored in DynamoDB as seconds. The key is deleted after deletion time.
 */
public class ApiKey private constructor(builder: Builder) {
    /**
     * The time after which the API key is deleted. The date is represented as seconds since the epoch, rounded down to the nearest hour.
     */
    public val deletes: kotlin.Long = builder.deletes
    /**
     * A description of the purpose of the API key.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The time after which the API key expires. The date is represented as seconds since the epoch, rounded down to the nearest hour.
     */
    public val expires: kotlin.Long = builder.expires
    /**
     * The API key ID.
     */
    public val id: kotlin.String? = builder.id

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appsync.model.ApiKey = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApiKey(")
        append("deletes=$deletes,")
        append("description=$description,")
        append("expires=$expires,")
        append("id=$id)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deletes.hashCode()
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (expires.hashCode())
        result = 31 * result + (id?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ApiKey

        if (deletes != other.deletes) return false
        if (description != other.description) return false
        if (expires != other.expires) return false
        if (id != other.id) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appsync.model.ApiKey = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time after which the API key is deleted. The date is represented as seconds since the epoch, rounded down to the nearest hour.
         */
        public var deletes: kotlin.Long = 0L
        /**
         * A description of the purpose of the API key.
         */
        public var description: kotlin.String? = null
        /**
         * The time after which the API key expires. The date is represented as seconds since the epoch, rounded down to the nearest hour.
         */
        public var expires: kotlin.Long = 0L
        /**
         * The API key ID.
         */
        public var id: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appsync.model.ApiKey) : this() {
            this.deletes = x.deletes
            this.description = x.description
            this.expires = x.expires
            this.id = x.id
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appsync.model.ApiKey = ApiKey(this)
    }
}
