// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model



/**
 * A function is a reusable entity. You can use multiple functions to compose the resolver logic.
 */
public class FunctionConfiguration private constructor(builder: Builder) {
    /**
     * The name of the `DataSource`.
     */
    public val dataSourceName: kotlin.String? = builder.dataSourceName
    /**
     * The `Function` description.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The Amazon Resource Name (ARN) of the `Function` object.
     */
    public val functionArn: kotlin.String? = builder.functionArn
    /**
     * A unique ID representing the `Function` object.
     */
    public val functionId: kotlin.String? = builder.functionId
    /**
     * The version of the request mapping template. Currently, only the 2018-05-29 version of the template is supported.
     */
    public val functionVersion: kotlin.String? = builder.functionVersion
    /**
     * The maximum batching size for a resolver.
     */
    public val maxBatchSize: kotlin.Int = builder.maxBatchSize
    /**
     * The name of the `Function` object.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The `Function` request mapping template. Functions support only the 2018-05-29 version of the request mapping template.
     */
    public val requestMappingTemplate: kotlin.String? = builder.requestMappingTemplate
    /**
     * The `Function` response mapping template.
     */
    public val responseMappingTemplate: kotlin.String? = builder.responseMappingTemplate
    /**
     * Describes a Sync configuration for a resolver.
     *
     * Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.
     */
    public val syncConfig: aws.sdk.kotlin.services.appsync.model.SyncConfig? = builder.syncConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appsync.model.FunctionConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FunctionConfiguration(")
        append("dataSourceName=$dataSourceName,")
        append("description=$description,")
        append("functionArn=$functionArn,")
        append("functionId=$functionId,")
        append("functionVersion=$functionVersion,")
        append("maxBatchSize=$maxBatchSize,")
        append("name=$name,")
        append("requestMappingTemplate=$requestMappingTemplate,")
        append("responseMappingTemplate=$responseMappingTemplate,")
        append("syncConfig=$syncConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSourceName?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (functionArn?.hashCode() ?: 0)
        result = 31 * result + (functionId?.hashCode() ?: 0)
        result = 31 * result + (functionVersion?.hashCode() ?: 0)
        result = 31 * result + (maxBatchSize)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (requestMappingTemplate?.hashCode() ?: 0)
        result = 31 * result + (responseMappingTemplate?.hashCode() ?: 0)
        result = 31 * result + (syncConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FunctionConfiguration

        if (dataSourceName != other.dataSourceName) return false
        if (description != other.description) return false
        if (functionArn != other.functionArn) return false
        if (functionId != other.functionId) return false
        if (functionVersion != other.functionVersion) return false
        if (maxBatchSize != other.maxBatchSize) return false
        if (name != other.name) return false
        if (requestMappingTemplate != other.requestMappingTemplate) return false
        if (responseMappingTemplate != other.responseMappingTemplate) return false
        if (syncConfig != other.syncConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appsync.model.FunctionConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the `DataSource`.
         */
        public var dataSourceName: kotlin.String? = null
        /**
         * The `Function` description.
         */
        public var description: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the `Function` object.
         */
        public var functionArn: kotlin.String? = null
        /**
         * A unique ID representing the `Function` object.
         */
        public var functionId: kotlin.String? = null
        /**
         * The version of the request mapping template. Currently, only the 2018-05-29 version of the template is supported.
         */
        public var functionVersion: kotlin.String? = null
        /**
         * The maximum batching size for a resolver.
         */
        public var maxBatchSize: kotlin.Int = 0
        /**
         * The name of the `Function` object.
         */
        public var name: kotlin.String? = null
        /**
         * The `Function` request mapping template. Functions support only the 2018-05-29 version of the request mapping template.
         */
        public var requestMappingTemplate: kotlin.String? = null
        /**
         * The `Function` response mapping template.
         */
        public var responseMappingTemplate: kotlin.String? = null
        /**
         * Describes a Sync configuration for a resolver.
         *
         * Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.
         */
        public var syncConfig: aws.sdk.kotlin.services.appsync.model.SyncConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appsync.model.FunctionConfiguration) : this() {
            this.dataSourceName = x.dataSourceName
            this.description = x.description
            this.functionArn = x.functionArn
            this.functionId = x.functionId
            this.functionVersion = x.functionVersion
            this.maxBatchSize = x.maxBatchSize
            this.name = x.name
            this.requestMappingTemplate = x.requestMappingTemplate
            this.responseMappingTemplate = x.responseMappingTemplate
            this.syncConfig = x.syncConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appsync.model.FunctionConfiguration = FunctionConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.SyncConfig] inside the given [block]
         */
        public fun syncConfig(block: aws.sdk.kotlin.services.appsync.model.SyncConfig.Builder.() -> kotlin.Unit) {
            this.syncConfig = aws.sdk.kotlin.services.appsync.model.SyncConfig.invoke(block)
        }
    }
}
