// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model



/**
 * The Amazon CloudWatch Logs configuration.
 */
public class LogConfig private constructor(builder: Builder) {
    /**
     * The service role that AppSync assumes to publish to CloudWatch logs in your account.
     */
    public val cloudWatchLogsRoleArn: kotlin.String? = builder.cloudWatchLogsRoleArn
    /**
     * Set to TRUE to exclude sections that contain information such as headers, context, and evaluated mapping templates, regardless of logging level.
     */
    public val excludeVerboseContent: kotlin.Boolean = builder.excludeVerboseContent
    /**
     * The field logging level. Values can be NONE, ERROR, or ALL.
     * + **NONE**: No field-level logs are captured.
     * + **ERROR**: Logs the following information only for the fields that are in error:
     *    + The error section in the server response.
     *    + Field-level errors.
     *    + The generated request/response functions that got resolved for error fields.
     * + **ALL**: The following information is logged for all fields in the query:
     *    + Field-level tracing information.
     *    + The generated request/response functions that got resolved for each field.
     */
    public val fieldLogLevel: aws.sdk.kotlin.services.appsync.model.FieldLogLevel? = builder.fieldLogLevel

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appsync.model.LogConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LogConfig(")
        append("cloudWatchLogsRoleArn=$cloudWatchLogsRoleArn,")
        append("excludeVerboseContent=$excludeVerboseContent,")
        append("fieldLogLevel=$fieldLogLevel)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchLogsRoleArn?.hashCode() ?: 0
        result = 31 * result + (excludeVerboseContent.hashCode())
        result = 31 * result + (fieldLogLevel?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LogConfig

        if (cloudWatchLogsRoleArn != other.cloudWatchLogsRoleArn) return false
        if (excludeVerboseContent != other.excludeVerboseContent) return false
        if (fieldLogLevel != other.fieldLogLevel) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appsync.model.LogConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The service role that AppSync assumes to publish to CloudWatch logs in your account.
         */
        public var cloudWatchLogsRoleArn: kotlin.String? = null
        /**
         * Set to TRUE to exclude sections that contain information such as headers, context, and evaluated mapping templates, regardless of logging level.
         */
        public var excludeVerboseContent: kotlin.Boolean = false
        /**
         * The field logging level. Values can be NONE, ERROR, or ALL.
         * + **NONE**: No field-level logs are captured.
         * + **ERROR**: Logs the following information only for the fields that are in error:
         *    + The error section in the server response.
         *    + Field-level errors.
         *    + The generated request/response functions that got resolved for error fields.
         * + **ALL**: The following information is logged for all fields in the query:
         *    + Field-level tracing information.
         *    + The generated request/response functions that got resolved for each field.
         */
        public var fieldLogLevel: aws.sdk.kotlin.services.appsync.model.FieldLogLevel? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appsync.model.LogConfig) : this() {
            this.cloudWatchLogsRoleArn = x.cloudWatchLogsRoleArn
            this.excludeVerboseContent = x.excludeVerboseContent
            this.fieldLogLevel = x.fieldLogLevel
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appsync.model.LogConfig = LogConfig(this)
    }
}
