// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.appsync.model.AppSyncException
import aws.sdk.kotlin.services.appsync.model.ErrorDetail
import aws.sdk.kotlin.services.appsync.model.EvaluateMappingTemplateResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class EvaluateMappingTemplateOperationDeserializer: HttpDeserialize<EvaluateMappingTemplateResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): EvaluateMappingTemplateResponse {
        if (!response.status.isSuccess()) {
            throwEvaluateMappingTemplateError(context, response)
        }
        val builder = EvaluateMappingTemplateResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeEvaluateMappingTemplateOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwEvaluateMappingTemplateError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw AppSyncException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> AppSyncException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeEvaluateMappingTemplateOperationBody(builder: EvaluateMappingTemplateResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ERROR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("error"))
    val EVALUATIONRESULT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("evaluationResult"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ERROR_DESCRIPTOR)
        field(EVALUATIONRESULT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ERROR_DESCRIPTOR.index -> builder.error = deserializeErrorDetailDocument(deserializer)
                EVALUATIONRESULT_DESCRIPTOR.index -> builder.evaluationResult = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
