// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync

import aws.sdk.kotlin.runtime.auth.AuthConfig
import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.endpoint.EndpointResolver
import aws.sdk.kotlin.runtime.region.RegionConfig
import aws.sdk.kotlin.services.appsync.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * AppSync  provides API actions for creating and interacting with data sources using
 * GraphQL from your application.
 */
interface AppSyncClient : SdkClient {

    override val serviceName: String
        get() = "AppSync"
    /**
     * AppSyncClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.DslBuilder.() -> Unit = {}): AppSyncClient {
            val config = Config.BuilderImpl().apply(block).build()
            return DefaultAppSyncClient(config)
        }
    }

    class Config private constructor(builder: BuilderImpl): AuthConfig, HttpClientConfig, RegionConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider? = builder.credentialsProvider
        val endpointResolver: EndpointResolver? = builder.endpointResolver
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val region: String? = builder.region
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        override val signingRegion: String? = builder.signingRegion

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun signingRegion(signingRegion: String): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: EndpointResolver?

            /**
             * Override the default HTTP client configuration (e.g. configure proxy behavior, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

            /**
             * AWS region to be used for signing the request. This is not necessarily the same as `region`
             * in the case of global services like IAM
             */
            var signingRegion: String?

            fun build(): Config
        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: EndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default
            override var signingRegion: String? = null

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
            override fun signingRegion(signingRegion: String): FluentBuilder = apply { this.signingRegion = signingRegion }
        }
    }

    /**
     * Creates a cache for the GraphQL API.
     */
    suspend fun createApiCache(input: CreateApiCacheRequest): CreateApiCacheResponse

    /**
     * Creates a cache for the GraphQL API.
     */
    suspend fun createApiCache(block: CreateApiCacheRequest.DslBuilder.() -> Unit) = createApiCache(CreateApiCacheRequest.builder().apply(block).build())

    /**
     * Creates a unique key that you can distribute to clients who are executing your
     * API.
     */
    suspend fun createApiKey(input: CreateApiKeyRequest): CreateApiKeyResponse

    /**
     * Creates a unique key that you can distribute to clients who are executing your
     * API.
     */
    suspend fun createApiKey(block: CreateApiKeyRequest.DslBuilder.() -> Unit) = createApiKey(CreateApiKeyRequest.builder().apply(block).build())

    /**
     * Creates a DataSource object.
     */
    suspend fun createDataSource(input: CreateDataSourceRequest): CreateDataSourceResponse

    /**
     * Creates a DataSource object.
     */
    suspend fun createDataSource(block: CreateDataSourceRequest.DslBuilder.() -> Unit) = createDataSource(CreateDataSourceRequest.builder().apply(block).build())

    /**
     * Creates a Function object.
     * A function is a reusable entity. Multiple functions can be used to compose the resolver
     * logic.
     */
    suspend fun createFunction(input: CreateFunctionRequest): CreateFunctionResponse

    /**
     * Creates a Function object.
     * A function is a reusable entity. Multiple functions can be used to compose the resolver
     * logic.
     */
    suspend fun createFunction(block: CreateFunctionRequest.DslBuilder.() -> Unit) = createFunction(CreateFunctionRequest.builder().apply(block).build())

    /**
     * Creates a GraphqlApi object.
     */
    suspend fun createGraphqlApi(input: CreateGraphqlApiRequest): CreateGraphqlApiResponse

    /**
     * Creates a GraphqlApi object.
     */
    suspend fun createGraphqlApi(block: CreateGraphqlApiRequest.DslBuilder.() -> Unit) = createGraphqlApi(CreateGraphqlApiRequest.builder().apply(block).build())

    /**
     * Creates a Resolver object.
     * A resolver converts incoming requests into a format that a data source can understand
     * and converts the data source's responses into GraphQL.
     */
    suspend fun createResolver(input: CreateResolverRequest): CreateResolverResponse

    /**
     * Creates a Resolver object.
     * A resolver converts incoming requests into a format that a data source can understand
     * and converts the data source's responses into GraphQL.
     */
    suspend fun createResolver(block: CreateResolverRequest.DslBuilder.() -> Unit) = createResolver(CreateResolverRequest.builder().apply(block).build())

    /**
     * Creates a Type object.
     */
    suspend fun createType(input: CreateTypeRequest): CreateTypeResponse

    /**
     * Creates a Type object.
     */
    suspend fun createType(block: CreateTypeRequest.DslBuilder.() -> Unit) = createType(CreateTypeRequest.builder().apply(block).build())

    /**
     * Deletes an ApiCache object.
     */
    suspend fun deleteApiCache(input: DeleteApiCacheRequest): DeleteApiCacheResponse

    /**
     * Deletes an ApiCache object.
     */
    suspend fun deleteApiCache(block: DeleteApiCacheRequest.DslBuilder.() -> Unit) = deleteApiCache(DeleteApiCacheRequest.builder().apply(block).build())

    /**
     * Deletes an API key.
     */
    suspend fun deleteApiKey(input: DeleteApiKeyRequest): DeleteApiKeyResponse

    /**
     * Deletes an API key.
     */
    suspend fun deleteApiKey(block: DeleteApiKeyRequest.DslBuilder.() -> Unit) = deleteApiKey(DeleteApiKeyRequest.builder().apply(block).build())

    /**
     * Deletes a DataSource object.
     */
    suspend fun deleteDataSource(input: DeleteDataSourceRequest): DeleteDataSourceResponse

    /**
     * Deletes a DataSource object.
     */
    suspend fun deleteDataSource(block: DeleteDataSourceRequest.DslBuilder.() -> Unit) = deleteDataSource(DeleteDataSourceRequest.builder().apply(block).build())

    /**
     * Deletes a Function.
     */
    suspend fun deleteFunction(input: DeleteFunctionRequest): DeleteFunctionResponse

    /**
     * Deletes a Function.
     */
    suspend fun deleteFunction(block: DeleteFunctionRequest.DslBuilder.() -> Unit) = deleteFunction(DeleteFunctionRequest.builder().apply(block).build())

    /**
     * Deletes a GraphqlApi object.
     */
    suspend fun deleteGraphqlApi(input: DeleteGraphqlApiRequest): DeleteGraphqlApiResponse

    /**
     * Deletes a GraphqlApi object.
     */
    suspend fun deleteGraphqlApi(block: DeleteGraphqlApiRequest.DslBuilder.() -> Unit) = deleteGraphqlApi(DeleteGraphqlApiRequest.builder().apply(block).build())

    /**
     * Deletes a Resolver object.
     */
    suspend fun deleteResolver(input: DeleteResolverRequest): DeleteResolverResponse

    /**
     * Deletes a Resolver object.
     */
    suspend fun deleteResolver(block: DeleteResolverRequest.DslBuilder.() -> Unit) = deleteResolver(DeleteResolverRequest.builder().apply(block).build())

    /**
     * Deletes a Type object.
     */
    suspend fun deleteType(input: DeleteTypeRequest): DeleteTypeResponse

    /**
     * Deletes a Type object.
     */
    suspend fun deleteType(block: DeleteTypeRequest.DslBuilder.() -> Unit) = deleteType(DeleteTypeRequest.builder().apply(block).build())

    /**
     * Flushes an ApiCache object.
     */
    suspend fun flushApiCache(input: FlushApiCacheRequest): FlushApiCacheResponse

    /**
     * Flushes an ApiCache object.
     */
    suspend fun flushApiCache(block: FlushApiCacheRequest.DslBuilder.() -> Unit) = flushApiCache(FlushApiCacheRequest.builder().apply(block).build())

    /**
     * Retrieves an ApiCache object.
     */
    suspend fun getApiCache(input: GetApiCacheRequest): GetApiCacheResponse

    /**
     * Retrieves an ApiCache object.
     */
    suspend fun getApiCache(block: GetApiCacheRequest.DslBuilder.() -> Unit) = getApiCache(GetApiCacheRequest.builder().apply(block).build())

    /**
     * Retrieves a DataSource object.
     */
    suspend fun getDataSource(input: GetDataSourceRequest): GetDataSourceResponse

    /**
     * Retrieves a DataSource object.
     */
    suspend fun getDataSource(block: GetDataSourceRequest.DslBuilder.() -> Unit) = getDataSource(GetDataSourceRequest.builder().apply(block).build())

    /**
     * Get a Function.
     */
    suspend fun getFunction(input: GetFunctionRequest): GetFunctionResponse

    /**
     * Get a Function.
     */
    suspend fun getFunction(block: GetFunctionRequest.DslBuilder.() -> Unit) = getFunction(GetFunctionRequest.builder().apply(block).build())

    /**
     * Retrieves a GraphqlApi object.
     */
    suspend fun getGraphqlApi(input: GetGraphqlApiRequest): GetGraphqlApiResponse

    /**
     * Retrieves a GraphqlApi object.
     */
    suspend fun getGraphqlApi(block: GetGraphqlApiRequest.DslBuilder.() -> Unit) = getGraphqlApi(GetGraphqlApiRequest.builder().apply(block).build())

    /**
     * Retrieves the introspection schema for a GraphQL API.
     */
    suspend fun getIntrospectionSchema(input: GetIntrospectionSchemaRequest): GetIntrospectionSchemaResponse

    /**
     * Retrieves the introspection schema for a GraphQL API.
     */
    suspend fun getIntrospectionSchema(block: GetIntrospectionSchemaRequest.DslBuilder.() -> Unit) = getIntrospectionSchema(GetIntrospectionSchemaRequest.builder().apply(block).build())

    /**
     * Retrieves a Resolver object.
     */
    suspend fun getResolver(input: GetResolverRequest): GetResolverResponse

    /**
     * Retrieves a Resolver object.
     */
    suspend fun getResolver(block: GetResolverRequest.DslBuilder.() -> Unit) = getResolver(GetResolverRequest.builder().apply(block).build())

    /**
     * Retrieves the current status of a schema creation operation.
     */
    suspend fun getSchemaCreationStatus(input: GetSchemaCreationStatusRequest): GetSchemaCreationStatusResponse

    /**
     * Retrieves the current status of a schema creation operation.
     */
    suspend fun getSchemaCreationStatus(block: GetSchemaCreationStatusRequest.DslBuilder.() -> Unit) = getSchemaCreationStatus(GetSchemaCreationStatusRequest.builder().apply(block).build())

    /**
     * Retrieves a Type object.
     */
    suspend fun getType(input: GetTypeRequest): GetTypeResponse

    /**
     * Retrieves a Type object.
     */
    suspend fun getType(block: GetTypeRequest.DslBuilder.() -> Unit) = getType(GetTypeRequest.builder().apply(block).build())

    /**
     * Lists the API keys for a given API.
     * API keys are deleted automatically 60 days after they expire. However, they may
     * still be included in the response until they have actually been deleted. You can safely
     * call DeleteApiKey to manually delete a key before it's automatically
     * deleted.
     */
    suspend fun listApiKeys(input: ListApiKeysRequest): ListApiKeysResponse

    /**
     * Lists the API keys for a given API.
     * API keys are deleted automatically 60 days after they expire. However, they may
     * still be included in the response until they have actually been deleted. You can safely
     * call DeleteApiKey to manually delete a key before it's automatically
     * deleted.
     */
    suspend fun listApiKeys(block: ListApiKeysRequest.DslBuilder.() -> Unit) = listApiKeys(ListApiKeysRequest.builder().apply(block).build())

    /**
     * Lists the data sources for a given API.
     */
    suspend fun listDataSources(input: ListDataSourcesRequest): ListDataSourcesResponse

    /**
     * Lists the data sources for a given API.
     */
    suspend fun listDataSources(block: ListDataSourcesRequest.DslBuilder.() -> Unit) = listDataSources(ListDataSourcesRequest.builder().apply(block).build())

    /**
     * List multiple functions.
     */
    suspend fun listFunctions(input: ListFunctionsRequest): ListFunctionsResponse

    /**
     * List multiple functions.
     */
    suspend fun listFunctions(block: ListFunctionsRequest.DslBuilder.() -> Unit) = listFunctions(ListFunctionsRequest.builder().apply(block).build())

    /**
     * Lists your GraphQL APIs.
     */
    suspend fun listGraphqlApis(input: ListGraphqlApisRequest): ListGraphqlApisResponse

    /**
     * Lists your GraphQL APIs.
     */
    suspend fun listGraphqlApis(block: ListGraphqlApisRequest.DslBuilder.() -> Unit) = listGraphqlApis(ListGraphqlApisRequest.builder().apply(block).build())

    /**
     * Lists the resolvers for a given API and type.
     */
    suspend fun listResolvers(input: ListResolversRequest): ListResolversResponse

    /**
     * Lists the resolvers for a given API and type.
     */
    suspend fun listResolvers(block: ListResolversRequest.DslBuilder.() -> Unit) = listResolvers(ListResolversRequest.builder().apply(block).build())

    /**
     * List the resolvers that are associated with a specific function.
     */
    suspend fun listResolversByFunction(input: ListResolversByFunctionRequest): ListResolversByFunctionResponse

    /**
     * List the resolvers that are associated with a specific function.
     */
    suspend fun listResolversByFunction(block: ListResolversByFunctionRequest.DslBuilder.() -> Unit) = listResolversByFunction(ListResolversByFunctionRequest.builder().apply(block).build())

    /**
     * Lists the tags for a resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the tags for a resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.DslBuilder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.builder().apply(block).build())

    /**
     * Lists the types for a given API.
     */
    suspend fun listTypes(input: ListTypesRequest): ListTypesResponse

    /**
     * Lists the types for a given API.
     */
    suspend fun listTypes(block: ListTypesRequest.DslBuilder.() -> Unit) = listTypes(ListTypesRequest.builder().apply(block).build())

    /**
     * Adds a new schema to your GraphQL API.
     * This operation is asynchronous. Use  to
     * determine when it has completed.
     */
    suspend fun startSchemaCreation(input: StartSchemaCreationRequest): StartSchemaCreationResponse

    /**
     * Adds a new schema to your GraphQL API.
     * This operation is asynchronous. Use  to
     * determine when it has completed.
     */
    suspend fun startSchemaCreation(block: StartSchemaCreationRequest.DslBuilder.() -> Unit) = startSchemaCreation(StartSchemaCreationRequest.builder().apply(block).build())

    /**
     * Tags a resource with user-supplied tags.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Tags a resource with user-supplied tags.
     */
    suspend fun tagResource(block: TagResourceRequest.DslBuilder.() -> Unit) = tagResource(TagResourceRequest.builder().apply(block).build())

    /**
     * Untags a resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Untags a resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.DslBuilder.() -> Unit) = untagResource(UntagResourceRequest.builder().apply(block).build())

    /**
     * Updates the cache for the GraphQL API.
     */
    suspend fun updateApiCache(input: UpdateApiCacheRequest): UpdateApiCacheResponse

    /**
     * Updates the cache for the GraphQL API.
     */
    suspend fun updateApiCache(block: UpdateApiCacheRequest.DslBuilder.() -> Unit) = updateApiCache(UpdateApiCacheRequest.builder().apply(block).build())

    /**
     * Updates an API key. The key can be updated while it is not deleted.
     */
    suspend fun updateApiKey(input: UpdateApiKeyRequest): UpdateApiKeyResponse

    /**
     * Updates an API key. The key can be updated while it is not deleted.
     */
    suspend fun updateApiKey(block: UpdateApiKeyRequest.DslBuilder.() -> Unit) = updateApiKey(UpdateApiKeyRequest.builder().apply(block).build())

    /**
     * Updates a DataSource object.
     */
    suspend fun updateDataSource(input: UpdateDataSourceRequest): UpdateDataSourceResponse

    /**
     * Updates a DataSource object.
     */
    suspend fun updateDataSource(block: UpdateDataSourceRequest.DslBuilder.() -> Unit) = updateDataSource(UpdateDataSourceRequest.builder().apply(block).build())

    /**
     * Updates a Function object.
     */
    suspend fun updateFunction(input: UpdateFunctionRequest): UpdateFunctionResponse

    /**
     * Updates a Function object.
     */
    suspend fun updateFunction(block: UpdateFunctionRequest.DslBuilder.() -> Unit) = updateFunction(UpdateFunctionRequest.builder().apply(block).build())

    /**
     * Updates a GraphqlApi object.
     */
    suspend fun updateGraphqlApi(input: UpdateGraphqlApiRequest): UpdateGraphqlApiResponse

    /**
     * Updates a GraphqlApi object.
     */
    suspend fun updateGraphqlApi(block: UpdateGraphqlApiRequest.DslBuilder.() -> Unit) = updateGraphqlApi(UpdateGraphqlApiRequest.builder().apply(block).build())

    /**
     * Updates a Resolver object.
     */
    suspend fun updateResolver(input: UpdateResolverRequest): UpdateResolverResponse

    /**
     * Updates a Resolver object.
     */
    suspend fun updateResolver(block: UpdateResolverRequest.DslBuilder.() -> Unit) = updateResolver(UpdateResolverRequest.builder().apply(block).build())

    /**
     * Updates a Type object.
     */
    suspend fun updateType(input: UpdateTypeRequest): UpdateTypeResponse

    /**
     * Updates a Type object.
     */
    suspend fun updateType(block: UpdateTypeRequest.DslBuilder.() -> Unit) = updateType(UpdateTypeRequest.builder().apply(block).build())
}
