// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model



/**
 * Describes an additional authentication provider.
 */
class AdditionalAuthenticationProvider private constructor(builder: BuilderImpl) {
    /**
     * The authentication type: API key, Identity and Access Management, OIDC, or Amazon Cognito user pools.
     */
    val authenticationType: AuthenticationType? = builder.authenticationType
    /**
     * Configuration for AWS Lambda function authorization.
     */
    val lambdaAuthorizerConfig: LambdaAuthorizerConfig? = builder.lambdaAuthorizerConfig
    /**
     * The OpenID Connect configuration.
     */
    val openIdConnectConfig: OpenIdConnectConfig? = builder.openIdConnectConfig
    /**
     * The Amazon Cognito user pool configuration.
     */
    val userPoolConfig: CognitoUserPoolConfig? = builder.userPoolConfig

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AdditionalAuthenticationProvider = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AdditionalAuthenticationProvider(")
        append("authenticationType=$authenticationType,")
        append("lambdaAuthorizerConfig=$lambdaAuthorizerConfig,")
        append("openIdConnectConfig=$openIdConnectConfig,")
        append("userPoolConfig=$userPoolConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = authenticationType?.hashCode() ?: 0
        result = 31 * result + (lambdaAuthorizerConfig?.hashCode() ?: 0)
        result = 31 * result + (openIdConnectConfig?.hashCode() ?: 0)
        result = 31 * result + (userPoolConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AdditionalAuthenticationProvider

        if (authenticationType != other.authenticationType) return false
        if (lambdaAuthorizerConfig != other.lambdaAuthorizerConfig) return false
        if (openIdConnectConfig != other.openIdConnectConfig) return false
        if (userPoolConfig != other.userPoolConfig) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AdditionalAuthenticationProvider = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AdditionalAuthenticationProvider
        /**
         * The authentication type: API key, Identity and Access Management, OIDC, or Amazon Cognito user pools.
         */
        fun authenticationType(authenticationType: AuthenticationType): FluentBuilder
        /**
         * Configuration for AWS Lambda function authorization.
         */
        fun lambdaAuthorizerConfig(lambdaAuthorizerConfig: LambdaAuthorizerConfig): FluentBuilder
        /**
         * The OpenID Connect configuration.
         */
        fun openIdConnectConfig(openIdConnectConfig: OpenIdConnectConfig): FluentBuilder
        /**
         * The Amazon Cognito user pool configuration.
         */
        fun userPoolConfig(userPoolConfig: CognitoUserPoolConfig): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The authentication type: API key, Identity and Access Management, OIDC, or Amazon Cognito user pools.
         */
        var authenticationType: AuthenticationType?
        /**
         * Configuration for AWS Lambda function authorization.
         */
        var lambdaAuthorizerConfig: LambdaAuthorizerConfig?
        /**
         * The OpenID Connect configuration.
         */
        var openIdConnectConfig: OpenIdConnectConfig?
        /**
         * The Amazon Cognito user pool configuration.
         */
        var userPoolConfig: CognitoUserPoolConfig?

        fun build(): AdditionalAuthenticationProvider
        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig] inside the given [block]
         */
        fun lambdaAuthorizerConfig(block: LambdaAuthorizerConfig.DslBuilder.() -> kotlin.Unit) {
            this.lambdaAuthorizerConfig = LambdaAuthorizerConfig.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.OpenIdConnectConfig] inside the given [block]
         */
        fun openIdConnectConfig(block: OpenIdConnectConfig.DslBuilder.() -> kotlin.Unit) {
            this.openIdConnectConfig = OpenIdConnectConfig.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.CognitoUserPoolConfig] inside the given [block]
         */
        fun userPoolConfig(block: CognitoUserPoolConfig.DslBuilder.() -> kotlin.Unit) {
            this.userPoolConfig = CognitoUserPoolConfig.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var authenticationType: AuthenticationType? = null
        override var lambdaAuthorizerConfig: LambdaAuthorizerConfig? = null
        override var openIdConnectConfig: OpenIdConnectConfig? = null
        override var userPoolConfig: CognitoUserPoolConfig? = null

        constructor(x: AdditionalAuthenticationProvider) : this() {
            this.authenticationType = x.authenticationType
            this.lambdaAuthorizerConfig = x.lambdaAuthorizerConfig
            this.openIdConnectConfig = x.openIdConnectConfig
            this.userPoolConfig = x.userPoolConfig
        }

        override fun build(): AdditionalAuthenticationProvider = AdditionalAuthenticationProvider(this)
        override fun authenticationType(authenticationType: AuthenticationType): FluentBuilder = apply { this.authenticationType = authenticationType }
        override fun lambdaAuthorizerConfig(lambdaAuthorizerConfig: LambdaAuthorizerConfig): FluentBuilder = apply { this.lambdaAuthorizerConfig = lambdaAuthorizerConfig }
        override fun openIdConnectConfig(openIdConnectConfig: OpenIdConnectConfig): FluentBuilder = apply { this.openIdConnectConfig = openIdConnectConfig }
        override fun userPoolConfig(userPoolConfig: CognitoUserPoolConfig): FluentBuilder = apply { this.userPoolConfig = userPoolConfig }
    }
}
