// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model



/**
 * The ApiCache object.
 */
class ApiCache private constructor(builder: BuilderImpl) {
    /**
     * Caching behavior.
     * FULL_REQUEST_CACHING: All requests are fully
     * cached.
     * PER_RESOLVER_CACHING: Individual resolvers
     * that you specify are cached.
     */
    val apiCachingBehavior: ApiCachingBehavior? = builder.apiCachingBehavior
    /**
     * At rest encryption flag for cache. This setting cannot be updated after creation.
     */
    val atRestEncryptionEnabled: Boolean = builder.atRestEncryptionEnabled
    /**
     * The cache instance status.
     * AVAILABLE: The instance is available for
     * use.
     * CREATING: The instance is currently
     * creating.
     * DELETING: The instance is currently
     * deleting.
     * MODIFYING: The instance is currently
     * modifying.
     * FAILED: The instance has failed
     * creation.
     */
    val status: ApiCacheStatus? = builder.status
    /**
     * Transit encryption flag when connecting to cache. This setting cannot be updated after
     * creation.
     */
    val transitEncryptionEnabled: Boolean = builder.transitEncryptionEnabled
    /**
     * TTL in seconds for cache entries.
     * Valid values are between 1 and 3600 seconds.
     */
    val ttl: Long = builder.ttl
    /**
     * The cache instance type. Valid values are
     * SMALL
     * MEDIUM
     * LARGE
     * XLARGE
     * LARGE_2X
     * LARGE_4X
     * LARGE_8X (not available in all regions)
     * LARGE_12X
     * Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.
     * The following legacy instance types are available, but their use is discouraged:
     * T2_SMALL: A t2.small instance type.
     * T2_MEDIUM: A t2.medium instance type.
     * R4_LARGE: A r4.large instance type.
     * R4_XLARGE: A r4.xlarge instance type.
     * R4_2XLARGE: A r4.2xlarge instance type.
     * R4_4XLARGE: A r4.4xlarge instance type.
     * R4_8XLARGE: A r4.8xlarge instance type.
     */
    val type: ApiCacheType? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ApiCache = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ApiCache(")
        append("apiCachingBehavior=$apiCachingBehavior,")
        append("atRestEncryptionEnabled=$atRestEncryptionEnabled,")
        append("status=$status,")
        append("transitEncryptionEnabled=$transitEncryptionEnabled,")
        append("ttl=$ttl,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiCachingBehavior?.hashCode() ?: 0
        result = 31 * result + (atRestEncryptionEnabled.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (transitEncryptionEnabled.hashCode())
        result = 31 * result + (ttl.hashCode())
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ApiCache

        if (apiCachingBehavior != other.apiCachingBehavior) return false
        if (atRestEncryptionEnabled != other.atRestEncryptionEnabled) return false
        if (status != other.status) return false
        if (transitEncryptionEnabled != other.transitEncryptionEnabled) return false
        if (ttl != other.ttl) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ApiCache = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ApiCache
        /**
         * Caching behavior.
         * FULL_REQUEST_CACHING: All requests are fully
         * cached.
         * PER_RESOLVER_CACHING: Individual resolvers
         * that you specify are cached.
         */
        fun apiCachingBehavior(apiCachingBehavior: ApiCachingBehavior): FluentBuilder
        /**
         * At rest encryption flag for cache. This setting cannot be updated after creation.
         */
        fun atRestEncryptionEnabled(atRestEncryptionEnabled: Boolean): FluentBuilder
        /**
         * The cache instance status.
         * AVAILABLE: The instance is available for
         * use.
         * CREATING: The instance is currently
         * creating.
         * DELETING: The instance is currently
         * deleting.
         * MODIFYING: The instance is currently
         * modifying.
         * FAILED: The instance has failed
         * creation.
         */
        fun status(status: ApiCacheStatus): FluentBuilder
        /**
         * Transit encryption flag when connecting to cache. This setting cannot be updated after
         * creation.
         */
        fun transitEncryptionEnabled(transitEncryptionEnabled: Boolean): FluentBuilder
        /**
         * TTL in seconds for cache entries.
         * Valid values are between 1 and 3600 seconds.
         */
        fun ttl(ttl: Long): FluentBuilder
        /**
         * The cache instance type. Valid values are
         * SMALL
         * MEDIUM
         * LARGE
         * XLARGE
         * LARGE_2X
         * LARGE_4X
         * LARGE_8X (not available in all regions)
         * LARGE_12X
         * Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.
         * The following legacy instance types are available, but their use is discouraged:
         * T2_SMALL: A t2.small instance type.
         * T2_MEDIUM: A t2.medium instance type.
         * R4_LARGE: A r4.large instance type.
         * R4_XLARGE: A r4.xlarge instance type.
         * R4_2XLARGE: A r4.2xlarge instance type.
         * R4_4XLARGE: A r4.4xlarge instance type.
         * R4_8XLARGE: A r4.8xlarge instance type.
         */
        fun type(type: ApiCacheType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Caching behavior.
         * FULL_REQUEST_CACHING: All requests are fully
         * cached.
         * PER_RESOLVER_CACHING: Individual resolvers
         * that you specify are cached.
         */
        var apiCachingBehavior: ApiCachingBehavior?
        /**
         * At rest encryption flag for cache. This setting cannot be updated after creation.
         */
        var atRestEncryptionEnabled: Boolean
        /**
         * The cache instance status.
         * AVAILABLE: The instance is available for
         * use.
         * CREATING: The instance is currently
         * creating.
         * DELETING: The instance is currently
         * deleting.
         * MODIFYING: The instance is currently
         * modifying.
         * FAILED: The instance has failed
         * creation.
         */
        var status: ApiCacheStatus?
        /**
         * Transit encryption flag when connecting to cache. This setting cannot be updated after
         * creation.
         */
        var transitEncryptionEnabled: Boolean
        /**
         * TTL in seconds for cache entries.
         * Valid values are between 1 and 3600 seconds.
         */
        var ttl: Long
        /**
         * The cache instance type. Valid values are
         * SMALL
         * MEDIUM
         * LARGE
         * XLARGE
         * LARGE_2X
         * LARGE_4X
         * LARGE_8X (not available in all regions)
         * LARGE_12X
         * Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.
         * The following legacy instance types are available, but their use is discouraged:
         * T2_SMALL: A t2.small instance type.
         * T2_MEDIUM: A t2.medium instance type.
         * R4_LARGE: A r4.large instance type.
         * R4_XLARGE: A r4.xlarge instance type.
         * R4_2XLARGE: A r4.2xlarge instance type.
         * R4_4XLARGE: A r4.4xlarge instance type.
         * R4_8XLARGE: A r4.8xlarge instance type.
         */
        var type: ApiCacheType?

        fun build(): ApiCache
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var apiCachingBehavior: ApiCachingBehavior? = null
        override var atRestEncryptionEnabled: Boolean = false
        override var status: ApiCacheStatus? = null
        override var transitEncryptionEnabled: Boolean = false
        override var ttl: Long = 0L
        override var type: ApiCacheType? = null

        constructor(x: ApiCache) : this() {
            this.apiCachingBehavior = x.apiCachingBehavior
            this.atRestEncryptionEnabled = x.atRestEncryptionEnabled
            this.status = x.status
            this.transitEncryptionEnabled = x.transitEncryptionEnabled
            this.ttl = x.ttl
            this.type = x.type
        }

        override fun build(): ApiCache = ApiCache(this)
        override fun apiCachingBehavior(apiCachingBehavior: ApiCachingBehavior): FluentBuilder = apply { this.apiCachingBehavior = apiCachingBehavior }
        override fun atRestEncryptionEnabled(atRestEncryptionEnabled: Boolean): FluentBuilder = apply { this.atRestEncryptionEnabled = atRestEncryptionEnabled }
        override fun status(status: ApiCacheStatus): FluentBuilder = apply { this.status = status }
        override fun transitEncryptionEnabled(transitEncryptionEnabled: Boolean): FluentBuilder = apply { this.transitEncryptionEnabled = transitEncryptionEnabled }
        override fun ttl(ttl: Long): FluentBuilder = apply { this.ttl = ttl }
        override fun type(type: ApiCacheType): FluentBuilder = apply { this.type = type }
    }
}
