// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model



/**
 * Describes an API key.
 * Customers invoke AppSync GraphQL API operations with API keys as an identity
 * mechanism. There are two key versions:
 * da1: This version was introduced at launch in November
 * 2017. These keys always expire after 7 days. Key expiration is managed by Amazon DynamoDB
 * TTL. The keys ceased to be valid after February 21, 2018 and should not be used after that
 * date.
 * ListApiKeys returns the expiration time in milliseconds.
 * CreateApiKey returns the expiration time in
 * milliseconds.
 * UpdateApiKey is not available for this key version.
 * DeleteApiKey deletes the item from the table.
 * Expiration is stored in Amazon DynamoDB as milliseconds. This results in a bug
 * where keys are not automatically deleted because DynamoDB expects the TTL to be
 * stored in seconds. As a one-time action, we will delete these keys from the table
 * after February 21, 2018.
 * da2: This version was introduced in February 2018 when
 * AppSync added support to extend key expiration.
 * ListApiKeys returns the expiration time and deletion time
 * in seconds.
 * CreateApiKey returns the expiration time and deletion time
 * in seconds and accepts a user-provided expiration time in seconds.
 * UpdateApiKey returns the expiration time and and deletion time
 * in seconds and accepts a user-provided expiration time in seconds. Expired API keys
 * are kept for 60 days after the expiration time. Key expiration time can be updated
 * while the key is not deleted.
 * DeleteApiKey deletes the item from the table.
 * Expiration is stored in Amazon DynamoDB as seconds. After the expiration
 * time, using the key to authenticate will fail. But the key can be reinstated before
 * deletion.
 * Deletion is stored in Amazon DynamoDB as seconds. The key will be deleted
 * after deletion time.
 */
class ApiKey private constructor(builder: BuilderImpl) {
    /**
     * The time after which the API key is deleted. The date is represented as seconds since the
     * epoch, rounded down to the nearest hour.
     */
    val deletes: Long = builder.deletes
    /**
     * A description of the purpose of the API key.
     */
    val description: String? = builder.description
    /**
     * The time after which the API key expires. The date is represented as seconds since the
     * epoch, rounded down to the nearest hour.
     */
    val expires: Long = builder.expires
    /**
     * The API key ID.
     */
    val id: String? = builder.id

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ApiKey = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ApiKey(")
        append("deletes=$deletes,")
        append("description=$description,")
        append("expires=$expires,")
        append("id=$id)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deletes.hashCode()
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (expires.hashCode())
        result = 31 * result + (id?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ApiKey

        if (deletes != other.deletes) return false
        if (description != other.description) return false
        if (expires != other.expires) return false
        if (id != other.id) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ApiKey = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ApiKey
        /**
         * The time after which the API key is deleted. The date is represented as seconds since the
         * epoch, rounded down to the nearest hour.
         */
        fun deletes(deletes: Long): FluentBuilder
        /**
         * A description of the purpose of the API key.
         */
        fun description(description: String): FluentBuilder
        /**
         * The time after which the API key expires. The date is represented as seconds since the
         * epoch, rounded down to the nearest hour.
         */
        fun expires(expires: Long): FluentBuilder
        /**
         * The API key ID.
         */
        fun id(id: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The time after which the API key is deleted. The date is represented as seconds since the
         * epoch, rounded down to the nearest hour.
         */
        var deletes: Long
        /**
         * A description of the purpose of the API key.
         */
        var description: String?
        /**
         * The time after which the API key expires. The date is represented as seconds since the
         * epoch, rounded down to the nearest hour.
         */
        var expires: Long
        /**
         * The API key ID.
         */
        var id: String?

        fun build(): ApiKey
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var deletes: Long = 0L
        override var description: String? = null
        override var expires: Long = 0L
        override var id: String? = null

        constructor(x: ApiKey) : this() {
            this.deletes = x.deletes
            this.description = x.description
            this.expires = x.expires
            this.id = x.id
        }

        override fun build(): ApiKey = ApiKey(this)
        override fun deletes(deletes: Long): FluentBuilder = apply { this.deletes = deletes }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun expires(expires: Long): FluentBuilder = apply { this.expires = expires }
        override fun id(id: String): FluentBuilder = apply { this.id = id }
    }
}
