// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model



/**
 * Describes an Amazon Cognito user pool configuration.
 */
class CognitoUserPoolConfig private constructor(builder: BuilderImpl) {
    /**
     * A regular expression for validating the incoming Amazon Cognito user pool app client
     * ID.
     */
    val appIdClientRegex: String? = builder.appIdClientRegex
    /**
     * The Amazon Web Services Region in which the user pool was created.
     */
    val awsRegion: String? = builder.awsRegion
    /**
     * The user pool ID.
     */
    val userPoolId: String? = builder.userPoolId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CognitoUserPoolConfig = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CognitoUserPoolConfig(")
        append("appIdClientRegex=$appIdClientRegex,")
        append("awsRegion=$awsRegion,")
        append("userPoolId=$userPoolId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = appIdClientRegex?.hashCode() ?: 0
        result = 31 * result + (awsRegion?.hashCode() ?: 0)
        result = 31 * result + (userPoolId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CognitoUserPoolConfig

        if (appIdClientRegex != other.appIdClientRegex) return false
        if (awsRegion != other.awsRegion) return false
        if (userPoolId != other.userPoolId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CognitoUserPoolConfig = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CognitoUserPoolConfig
        /**
         * A regular expression for validating the incoming Amazon Cognito user pool app client
         * ID.
         */
        fun appIdClientRegex(appIdClientRegex: String): FluentBuilder
        /**
         * The Amazon Web Services Region in which the user pool was created.
         */
        fun awsRegion(awsRegion: String): FluentBuilder
        /**
         * The user pool ID.
         */
        fun userPoolId(userPoolId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A regular expression for validating the incoming Amazon Cognito user pool app client
         * ID.
         */
        var appIdClientRegex: String?
        /**
         * The Amazon Web Services Region in which the user pool was created.
         */
        var awsRegion: String?
        /**
         * The user pool ID.
         */
        var userPoolId: String?

        fun build(): CognitoUserPoolConfig
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var appIdClientRegex: String? = null
        override var awsRegion: String? = null
        override var userPoolId: String? = null

        constructor(x: CognitoUserPoolConfig) : this() {
            this.appIdClientRegex = x.appIdClientRegex
            this.awsRegion = x.awsRegion
            this.userPoolId = x.userPoolId
        }

        override fun build(): CognitoUserPoolConfig = CognitoUserPoolConfig(this)
        override fun appIdClientRegex(appIdClientRegex: String): FluentBuilder = apply { this.appIdClientRegex = appIdClientRegex }
        override fun awsRegion(awsRegion: String): FluentBuilder = apply { this.awsRegion = awsRegion }
        override fun userPoolId(userPoolId: String): FluentBuilder = apply { this.userPoolId = userPoolId }
    }
}
