// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model



/**
 * Represents the input of a CreateApiCache operation.
 */
class CreateApiCacheRequest private constructor(builder: BuilderImpl) {
    /**
     * Caching behavior.
     * FULL_REQUEST_CACHING: All requests are fully
     * cached.
     * PER_RESOLVER_CACHING: Individual resolvers
     * that you specify are cached.
     */
    val apiCachingBehavior: ApiCachingBehavior? = builder.apiCachingBehavior
    /**
     * The GraphQL API Id.
     */
    val apiId: String? = builder.apiId
    /**
     * At rest encryption flag for cache. This setting cannot be updated after creation.
     */
    val atRestEncryptionEnabled: Boolean = builder.atRestEncryptionEnabled
    /**
     * Transit encryption flag when connecting to cache. This setting cannot be updated after
     * creation.
     */
    val transitEncryptionEnabled: Boolean = builder.transitEncryptionEnabled
    /**
     * TTL in seconds for cache entries.
     * Valid values are between 1 and 3600 seconds.
     */
    val ttl: Long = builder.ttl
    /**
     * The cache instance type. Valid values are
     * SMALL
     * MEDIUM
     * LARGE
     * XLARGE
     * LARGE_2X
     * LARGE_4X
     * LARGE_8X (not available in all regions)
     * LARGE_12X
     * Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.
     * The following legacy instance types are available, but their use is discouraged:
     * T2_SMALL: A t2.small instance type.
     * T2_MEDIUM: A t2.medium instance type.
     * R4_LARGE: A r4.large instance type.
     * R4_XLARGE: A r4.xlarge instance type.
     * R4_2XLARGE: A r4.2xlarge instance type.
     * R4_4XLARGE: A r4.4xlarge instance type.
     * R4_8XLARGE: A r4.8xlarge instance type.
     */
    val type: ApiCacheType? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateApiCacheRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateApiCacheRequest(")
        append("apiCachingBehavior=$apiCachingBehavior,")
        append("apiId=$apiId,")
        append("atRestEncryptionEnabled=$atRestEncryptionEnabled,")
        append("transitEncryptionEnabled=$transitEncryptionEnabled,")
        append("ttl=$ttl,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiCachingBehavior?.hashCode() ?: 0
        result = 31 * result + (apiId?.hashCode() ?: 0)
        result = 31 * result + (atRestEncryptionEnabled.hashCode())
        result = 31 * result + (transitEncryptionEnabled.hashCode())
        result = 31 * result + (ttl.hashCode())
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateApiCacheRequest

        if (apiCachingBehavior != other.apiCachingBehavior) return false
        if (apiId != other.apiId) return false
        if (atRestEncryptionEnabled != other.atRestEncryptionEnabled) return false
        if (transitEncryptionEnabled != other.transitEncryptionEnabled) return false
        if (ttl != other.ttl) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateApiCacheRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateApiCacheRequest
        /**
         * Caching behavior.
         * FULL_REQUEST_CACHING: All requests are fully
         * cached.
         * PER_RESOLVER_CACHING: Individual resolvers
         * that you specify are cached.
         */
        fun apiCachingBehavior(apiCachingBehavior: ApiCachingBehavior): FluentBuilder
        /**
         * The GraphQL API Id.
         */
        fun apiId(apiId: String): FluentBuilder
        /**
         * At rest encryption flag for cache. This setting cannot be updated after creation.
         */
        fun atRestEncryptionEnabled(atRestEncryptionEnabled: Boolean): FluentBuilder
        /**
         * Transit encryption flag when connecting to cache. This setting cannot be updated after
         * creation.
         */
        fun transitEncryptionEnabled(transitEncryptionEnabled: Boolean): FluentBuilder
        /**
         * TTL in seconds for cache entries.
         * Valid values are between 1 and 3600 seconds.
         */
        fun ttl(ttl: Long): FluentBuilder
        /**
         * The cache instance type. Valid values are
         * SMALL
         * MEDIUM
         * LARGE
         * XLARGE
         * LARGE_2X
         * LARGE_4X
         * LARGE_8X (not available in all regions)
         * LARGE_12X
         * Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.
         * The following legacy instance types are available, but their use is discouraged:
         * T2_SMALL: A t2.small instance type.
         * T2_MEDIUM: A t2.medium instance type.
         * R4_LARGE: A r4.large instance type.
         * R4_XLARGE: A r4.xlarge instance type.
         * R4_2XLARGE: A r4.2xlarge instance type.
         * R4_4XLARGE: A r4.4xlarge instance type.
         * R4_8XLARGE: A r4.8xlarge instance type.
         */
        fun type(type: ApiCacheType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Caching behavior.
         * FULL_REQUEST_CACHING: All requests are fully
         * cached.
         * PER_RESOLVER_CACHING: Individual resolvers
         * that you specify are cached.
         */
        var apiCachingBehavior: ApiCachingBehavior?
        /**
         * The GraphQL API Id.
         */
        var apiId: String?
        /**
         * At rest encryption flag for cache. This setting cannot be updated after creation.
         */
        var atRestEncryptionEnabled: Boolean
        /**
         * Transit encryption flag when connecting to cache. This setting cannot be updated after
         * creation.
         */
        var transitEncryptionEnabled: Boolean
        /**
         * TTL in seconds for cache entries.
         * Valid values are between 1 and 3600 seconds.
         */
        var ttl: Long
        /**
         * The cache instance type. Valid values are
         * SMALL
         * MEDIUM
         * LARGE
         * XLARGE
         * LARGE_2X
         * LARGE_4X
         * LARGE_8X (not available in all regions)
         * LARGE_12X
         * Historically, instance types were identified by an EC2-style value. As of July 2020, this is deprecated, and the generic identifiers above should be used.
         * The following legacy instance types are available, but their use is discouraged:
         * T2_SMALL: A t2.small instance type.
         * T2_MEDIUM: A t2.medium instance type.
         * R4_LARGE: A r4.large instance type.
         * R4_XLARGE: A r4.xlarge instance type.
         * R4_2XLARGE: A r4.2xlarge instance type.
         * R4_4XLARGE: A r4.4xlarge instance type.
         * R4_8XLARGE: A r4.8xlarge instance type.
         */
        var type: ApiCacheType?

        fun build(): CreateApiCacheRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var apiCachingBehavior: ApiCachingBehavior? = null
        override var apiId: String? = null
        override var atRestEncryptionEnabled: Boolean = false
        override var transitEncryptionEnabled: Boolean = false
        override var ttl: Long = 0L
        override var type: ApiCacheType? = null

        constructor(x: CreateApiCacheRequest) : this() {
            this.apiCachingBehavior = x.apiCachingBehavior
            this.apiId = x.apiId
            this.atRestEncryptionEnabled = x.atRestEncryptionEnabled
            this.transitEncryptionEnabled = x.transitEncryptionEnabled
            this.ttl = x.ttl
            this.type = x.type
        }

        override fun build(): CreateApiCacheRequest = CreateApiCacheRequest(this)
        override fun apiCachingBehavior(apiCachingBehavior: ApiCachingBehavior): FluentBuilder = apply { this.apiCachingBehavior = apiCachingBehavior }
        override fun apiId(apiId: String): FluentBuilder = apply { this.apiId = apiId }
        override fun atRestEncryptionEnabled(atRestEncryptionEnabled: Boolean): FluentBuilder = apply { this.atRestEncryptionEnabled = atRestEncryptionEnabled }
        override fun transitEncryptionEnabled(transitEncryptionEnabled: Boolean): FluentBuilder = apply { this.transitEncryptionEnabled = transitEncryptionEnabled }
        override fun ttl(ttl: Long): FluentBuilder = apply { this.ttl = ttl }
        override fun type(type: ApiCacheType): FluentBuilder = apply { this.type = type }
    }
}
