// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model



class CreateGraphqlApiRequest private constructor(builder: BuilderImpl) {
    /**
     * A list of additional authentication providers for the GraphqlApi
     * API.
     */
    val additionalAuthenticationProviders: List<AdditionalAuthenticationProvider>? = builder.additionalAuthenticationProviders
    /**
     * The authentication type: API key, Identity and Access Management, OIDC, or Amazon Cognito user pools.
     */
    val authenticationType: AuthenticationType? = builder.authenticationType
    /**
     * Configuration for AWS Lambda function authorization.
     */
    val lambdaAuthorizerConfig: LambdaAuthorizerConfig? = builder.lambdaAuthorizerConfig
    /**
     * The Amazon CloudWatch Logs configuration.
     */
    val logConfig: LogConfig? = builder.logConfig
    /**
     * A user-supplied name for the GraphqlApi.
     */
    val name: String? = builder.name
    /**
     * The OpenID Connect configuration.
     */
    val openIdConnectConfig: OpenIdConnectConfig? = builder.openIdConnectConfig
    /**
     * A TagMap object.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The Amazon Cognito user pool configuration.
     */
    val userPoolConfig: UserPoolConfig? = builder.userPoolConfig
    /**
     * A flag indicating whether to enable X-Ray tracing for the
     * GraphqlApi.
     */
    val xrayEnabled: Boolean = builder.xrayEnabled

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateGraphqlApiRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateGraphqlApiRequest(")
        append("additionalAuthenticationProviders=$additionalAuthenticationProviders,")
        append("authenticationType=$authenticationType,")
        append("lambdaAuthorizerConfig=$lambdaAuthorizerConfig,")
        append("logConfig=$logConfig,")
        append("name=$name,")
        append("openIdConnectConfig=$openIdConnectConfig,")
        append("tags=$tags,")
        append("userPoolConfig=$userPoolConfig,")
        append("xrayEnabled=$xrayEnabled)")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalAuthenticationProviders?.hashCode() ?: 0
        result = 31 * result + (authenticationType?.hashCode() ?: 0)
        result = 31 * result + (lambdaAuthorizerConfig?.hashCode() ?: 0)
        result = 31 * result + (logConfig?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (openIdConnectConfig?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (userPoolConfig?.hashCode() ?: 0)
        result = 31 * result + (xrayEnabled.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateGraphqlApiRequest

        if (additionalAuthenticationProviders != other.additionalAuthenticationProviders) return false
        if (authenticationType != other.authenticationType) return false
        if (lambdaAuthorizerConfig != other.lambdaAuthorizerConfig) return false
        if (logConfig != other.logConfig) return false
        if (name != other.name) return false
        if (openIdConnectConfig != other.openIdConnectConfig) return false
        if (tags != other.tags) return false
        if (userPoolConfig != other.userPoolConfig) return false
        if (xrayEnabled != other.xrayEnabled) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateGraphqlApiRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateGraphqlApiRequest
        /**
         * A list of additional authentication providers for the GraphqlApi
         * API.
         */
        fun additionalAuthenticationProviders(additionalAuthenticationProviders: List<AdditionalAuthenticationProvider>): FluentBuilder
        /**
         * The authentication type: API key, Identity and Access Management, OIDC, or Amazon Cognito user pools.
         */
        fun authenticationType(authenticationType: AuthenticationType): FluentBuilder
        /**
         * Configuration for AWS Lambda function authorization.
         */
        fun lambdaAuthorizerConfig(lambdaAuthorizerConfig: LambdaAuthorizerConfig): FluentBuilder
        /**
         * The Amazon CloudWatch Logs configuration.
         */
        fun logConfig(logConfig: LogConfig): FluentBuilder
        /**
         * A user-supplied name for the GraphqlApi.
         */
        fun name(name: String): FluentBuilder
        /**
         * The OpenID Connect configuration.
         */
        fun openIdConnectConfig(openIdConnectConfig: OpenIdConnectConfig): FluentBuilder
        /**
         * A TagMap object.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
        /**
         * The Amazon Cognito user pool configuration.
         */
        fun userPoolConfig(userPoolConfig: UserPoolConfig): FluentBuilder
        /**
         * A flag indicating whether to enable X-Ray tracing for the
         * GraphqlApi.
         */
        fun xrayEnabled(xrayEnabled: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A list of additional authentication providers for the GraphqlApi
         * API.
         */
        var additionalAuthenticationProviders: List<AdditionalAuthenticationProvider>?
        /**
         * The authentication type: API key, Identity and Access Management, OIDC, or Amazon Cognito user pools.
         */
        var authenticationType: AuthenticationType?
        /**
         * Configuration for AWS Lambda function authorization.
         */
        var lambdaAuthorizerConfig: LambdaAuthorizerConfig?
        /**
         * The Amazon CloudWatch Logs configuration.
         */
        var logConfig: LogConfig?
        /**
         * A user-supplied name for the GraphqlApi.
         */
        var name: String?
        /**
         * The OpenID Connect configuration.
         */
        var openIdConnectConfig: OpenIdConnectConfig?
        /**
         * A TagMap object.
         */
        var tags: Map<String, String>?
        /**
         * The Amazon Cognito user pool configuration.
         */
        var userPoolConfig: UserPoolConfig?
        /**
         * A flag indicating whether to enable X-Ray tracing for the
         * GraphqlApi.
         */
        var xrayEnabled: Boolean

        fun build(): CreateGraphqlApiRequest
        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig] inside the given [block]
         */
        fun lambdaAuthorizerConfig(block: LambdaAuthorizerConfig.DslBuilder.() -> kotlin.Unit) {
            this.lambdaAuthorizerConfig = LambdaAuthorizerConfig.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.LogConfig] inside the given [block]
         */
        fun logConfig(block: LogConfig.DslBuilder.() -> kotlin.Unit) {
            this.logConfig = LogConfig.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.OpenIdConnectConfig] inside the given [block]
         */
        fun openIdConnectConfig(block: OpenIdConnectConfig.DslBuilder.() -> kotlin.Unit) {
            this.openIdConnectConfig = OpenIdConnectConfig.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.UserPoolConfig] inside the given [block]
         */
        fun userPoolConfig(block: UserPoolConfig.DslBuilder.() -> kotlin.Unit) {
            this.userPoolConfig = UserPoolConfig.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var additionalAuthenticationProviders: List<AdditionalAuthenticationProvider>? = null
        override var authenticationType: AuthenticationType? = null
        override var lambdaAuthorizerConfig: LambdaAuthorizerConfig? = null
        override var logConfig: LogConfig? = null
        override var name: String? = null
        override var openIdConnectConfig: OpenIdConnectConfig? = null
        override var tags: Map<String, String>? = null
        override var userPoolConfig: UserPoolConfig? = null
        override var xrayEnabled: Boolean = false

        constructor(x: CreateGraphqlApiRequest) : this() {
            this.additionalAuthenticationProviders = x.additionalAuthenticationProviders
            this.authenticationType = x.authenticationType
            this.lambdaAuthorizerConfig = x.lambdaAuthorizerConfig
            this.logConfig = x.logConfig
            this.name = x.name
            this.openIdConnectConfig = x.openIdConnectConfig
            this.tags = x.tags
            this.userPoolConfig = x.userPoolConfig
            this.xrayEnabled = x.xrayEnabled
        }

        override fun build(): CreateGraphqlApiRequest = CreateGraphqlApiRequest(this)
        override fun additionalAuthenticationProviders(additionalAuthenticationProviders: List<AdditionalAuthenticationProvider>): FluentBuilder = apply { this.additionalAuthenticationProviders = additionalAuthenticationProviders }
        override fun authenticationType(authenticationType: AuthenticationType): FluentBuilder = apply { this.authenticationType = authenticationType }
        override fun lambdaAuthorizerConfig(lambdaAuthorizerConfig: LambdaAuthorizerConfig): FluentBuilder = apply { this.lambdaAuthorizerConfig = lambdaAuthorizerConfig }
        override fun logConfig(logConfig: LogConfig): FluentBuilder = apply { this.logConfig = logConfig }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun openIdConnectConfig(openIdConnectConfig: OpenIdConnectConfig): FluentBuilder = apply { this.openIdConnectConfig = openIdConnectConfig }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
        override fun userPoolConfig(userPoolConfig: UserPoolConfig): FluentBuilder = apply { this.userPoolConfig = userPoolConfig }
        override fun xrayEnabled(xrayEnabled: Boolean): FluentBuilder = apply { this.xrayEnabled = xrayEnabled }
    }
}
