// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model



class CreateResolverRequest private constructor(builder: BuilderImpl) {
    /**
     * The ID for the GraphQL API for which the resolver is being created.
     */
    val apiId: String? = builder.apiId
    /**
     * The caching configuration for the resolver.
     */
    val cachingConfig: CachingConfig? = builder.cachingConfig
    /**
     * The name of the data source for which the resolver is being created.
     */
    val dataSourceName: String? = builder.dataSourceName
    /**
     * The name of the field to attach the resolver to.
     */
    val fieldName: String? = builder.fieldName
    /**
     * The resolver type.
     * UNIT: A UNIT resolver type. A UNIT resolver is
     * the default resolver type. A UNIT resolver enables you to execute a GraphQL query
     * against a single data source.
     * PIPELINE: A PIPELINE resolver type. A PIPELINE
     * resolver enables you to execute a series of Function in a serial manner.
     * You can use a pipeline resolver to execute a GraphQL query against multiple data
     * sources.
     */
    val kind: ResolverKind? = builder.kind
    /**
     * The PipelineConfig.
     */
    val pipelineConfig: PipelineConfig? = builder.pipelineConfig
    /**
     * The mapping template to be used for requests.
     * A resolver uses a request mapping template to convert a GraphQL expression into a format
     * that a data source can understand. Mapping templates are written in Apache Velocity
     * Template Language (VTL).
     * VTL request mapping templates are optional when using a Lambda data source. For all
     * other data sources, VTL request and response mapping templates are required.
     */
    val requestMappingTemplate: String? = builder.requestMappingTemplate
    /**
     * The mapping template to be used for responses from the data source.
     */
    val responseMappingTemplate: String? = builder.responseMappingTemplate
    /**
     * The SyncConfig for a resolver attached to a versioned datasource.
     */
    val syncConfig: SyncConfig? = builder.syncConfig
    /**
     * The name of the Type.
     */
    val typeName: String? = builder.typeName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateResolverRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateResolverRequest(")
        append("apiId=$apiId,")
        append("cachingConfig=$cachingConfig,")
        append("dataSourceName=$dataSourceName,")
        append("fieldName=$fieldName,")
        append("kind=$kind,")
        append("pipelineConfig=$pipelineConfig,")
        append("requestMappingTemplate=$requestMappingTemplate,")
        append("responseMappingTemplate=$responseMappingTemplate,")
        append("syncConfig=$syncConfig,")
        append("typeName=$typeName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiId?.hashCode() ?: 0
        result = 31 * result + (cachingConfig?.hashCode() ?: 0)
        result = 31 * result + (dataSourceName?.hashCode() ?: 0)
        result = 31 * result + (fieldName?.hashCode() ?: 0)
        result = 31 * result + (kind?.hashCode() ?: 0)
        result = 31 * result + (pipelineConfig?.hashCode() ?: 0)
        result = 31 * result + (requestMappingTemplate?.hashCode() ?: 0)
        result = 31 * result + (responseMappingTemplate?.hashCode() ?: 0)
        result = 31 * result + (syncConfig?.hashCode() ?: 0)
        result = 31 * result + (typeName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateResolverRequest

        if (apiId != other.apiId) return false
        if (cachingConfig != other.cachingConfig) return false
        if (dataSourceName != other.dataSourceName) return false
        if (fieldName != other.fieldName) return false
        if (kind != other.kind) return false
        if (pipelineConfig != other.pipelineConfig) return false
        if (requestMappingTemplate != other.requestMappingTemplate) return false
        if (responseMappingTemplate != other.responseMappingTemplate) return false
        if (syncConfig != other.syncConfig) return false
        if (typeName != other.typeName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateResolverRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateResolverRequest
        /**
         * The ID for the GraphQL API for which the resolver is being created.
         */
        fun apiId(apiId: String): FluentBuilder
        /**
         * The caching configuration for the resolver.
         */
        fun cachingConfig(cachingConfig: CachingConfig): FluentBuilder
        /**
         * The name of the data source for which the resolver is being created.
         */
        fun dataSourceName(dataSourceName: String): FluentBuilder
        /**
         * The name of the field to attach the resolver to.
         */
        fun fieldName(fieldName: String): FluentBuilder
        /**
         * The resolver type.
         * UNIT: A UNIT resolver type. A UNIT resolver is
         * the default resolver type. A UNIT resolver enables you to execute a GraphQL query
         * against a single data source.
         * PIPELINE: A PIPELINE resolver type. A PIPELINE
         * resolver enables you to execute a series of Function in a serial manner.
         * You can use a pipeline resolver to execute a GraphQL query against multiple data
         * sources.
         */
        fun kind(kind: ResolverKind): FluentBuilder
        /**
         * The PipelineConfig.
         */
        fun pipelineConfig(pipelineConfig: PipelineConfig): FluentBuilder
        /**
         * The mapping template to be used for requests.
         * A resolver uses a request mapping template to convert a GraphQL expression into a format
         * that a data source can understand. Mapping templates are written in Apache Velocity
         * Template Language (VTL).
         * VTL request mapping templates are optional when using a Lambda data source. For all
         * other data sources, VTL request and response mapping templates are required.
         */
        fun requestMappingTemplate(requestMappingTemplate: String): FluentBuilder
        /**
         * The mapping template to be used for responses from the data source.
         */
        fun responseMappingTemplate(responseMappingTemplate: String): FluentBuilder
        /**
         * The SyncConfig for a resolver attached to a versioned datasource.
         */
        fun syncConfig(syncConfig: SyncConfig): FluentBuilder
        /**
         * The name of the Type.
         */
        fun typeName(typeName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID for the GraphQL API for which the resolver is being created.
         */
        var apiId: String?
        /**
         * The caching configuration for the resolver.
         */
        var cachingConfig: CachingConfig?
        /**
         * The name of the data source for which the resolver is being created.
         */
        var dataSourceName: String?
        /**
         * The name of the field to attach the resolver to.
         */
        var fieldName: String?
        /**
         * The resolver type.
         * UNIT: A UNIT resolver type. A UNIT resolver is
         * the default resolver type. A UNIT resolver enables you to execute a GraphQL query
         * against a single data source.
         * PIPELINE: A PIPELINE resolver type. A PIPELINE
         * resolver enables you to execute a series of Function in a serial manner.
         * You can use a pipeline resolver to execute a GraphQL query against multiple data
         * sources.
         */
        var kind: ResolverKind?
        /**
         * The PipelineConfig.
         */
        var pipelineConfig: PipelineConfig?
        /**
         * The mapping template to be used for requests.
         * A resolver uses a request mapping template to convert a GraphQL expression into a format
         * that a data source can understand. Mapping templates are written in Apache Velocity
         * Template Language (VTL).
         * VTL request mapping templates are optional when using a Lambda data source. For all
         * other data sources, VTL request and response mapping templates are required.
         */
        var requestMappingTemplate: String?
        /**
         * The mapping template to be used for responses from the data source.
         */
        var responseMappingTemplate: String?
        /**
         * The SyncConfig for a resolver attached to a versioned datasource.
         */
        var syncConfig: SyncConfig?
        /**
         * The name of the Type.
         */
        var typeName: String?

        fun build(): CreateResolverRequest
        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.CachingConfig] inside the given [block]
         */
        fun cachingConfig(block: CachingConfig.DslBuilder.() -> kotlin.Unit) {
            this.cachingConfig = CachingConfig.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.PipelineConfig] inside the given [block]
         */
        fun pipelineConfig(block: PipelineConfig.DslBuilder.() -> kotlin.Unit) {
            this.pipelineConfig = PipelineConfig.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.SyncConfig] inside the given [block]
         */
        fun syncConfig(block: SyncConfig.DslBuilder.() -> kotlin.Unit) {
            this.syncConfig = SyncConfig.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var apiId: String? = null
        override var cachingConfig: CachingConfig? = null
        override var dataSourceName: String? = null
        override var fieldName: String? = null
        override var kind: ResolverKind? = null
        override var pipelineConfig: PipelineConfig? = null
        override var requestMappingTemplate: String? = null
        override var responseMappingTemplate: String? = null
        override var syncConfig: SyncConfig? = null
        override var typeName: String? = null

        constructor(x: CreateResolverRequest) : this() {
            this.apiId = x.apiId
            this.cachingConfig = x.cachingConfig
            this.dataSourceName = x.dataSourceName
            this.fieldName = x.fieldName
            this.kind = x.kind
            this.pipelineConfig = x.pipelineConfig
            this.requestMappingTemplate = x.requestMappingTemplate
            this.responseMappingTemplate = x.responseMappingTemplate
            this.syncConfig = x.syncConfig
            this.typeName = x.typeName
        }

        override fun build(): CreateResolverRequest = CreateResolverRequest(this)
        override fun apiId(apiId: String): FluentBuilder = apply { this.apiId = apiId }
        override fun cachingConfig(cachingConfig: CachingConfig): FluentBuilder = apply { this.cachingConfig = cachingConfig }
        override fun dataSourceName(dataSourceName: String): FluentBuilder = apply { this.dataSourceName = dataSourceName }
        override fun fieldName(fieldName: String): FluentBuilder = apply { this.fieldName = fieldName }
        override fun kind(kind: ResolverKind): FluentBuilder = apply { this.kind = kind }
        override fun pipelineConfig(pipelineConfig: PipelineConfig): FluentBuilder = apply { this.pipelineConfig = pipelineConfig }
        override fun requestMappingTemplate(requestMappingTemplate: String): FluentBuilder = apply { this.requestMappingTemplate = requestMappingTemplate }
        override fun responseMappingTemplate(responseMappingTemplate: String): FluentBuilder = apply { this.responseMappingTemplate = responseMappingTemplate }
        override fun syncConfig(syncConfig: SyncConfig): FluentBuilder = apply { this.syncConfig = syncConfig }
        override fun typeName(typeName: String): FluentBuilder = apply { this.typeName = typeName }
    }
}
