// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model



/**
 * Describes a data source.
 */
class DataSource private constructor(builder: BuilderImpl) {
    /**
     * The data source ARN.
     */
    val dataSourceArn: String? = builder.dataSourceArn
    /**
     * The description of the data source.
     */
    val description: String? = builder.description
    /**
     * Amazon DynamoDB settings.
     */
    val dynamodbConfig: DynamodbDataSourceConfig? = builder.dynamodbConfig
    /**
     * Amazon Elasticsearch Service settings.
     */
    val elasticsearchConfig: ElasticsearchDataSourceConfig? = builder.elasticsearchConfig
    /**
     * HTTP endpoint settings.
     */
    val httpConfig: HttpDataSourceConfig? = builder.httpConfig
    /**
     * Amazon Web Services Lambda settings.
     */
    val lambdaConfig: LambdaDataSourceConfig? = builder.lambdaConfig
    /**
     * The name of the data source.
     */
    val name: String? = builder.name
    /**
     * Relational database settings.
     */
    val relationalDatabaseConfig: RelationalDatabaseDataSourceConfig? = builder.relationalDatabaseConfig
    /**
     * The Identity and Access Management service role ARN for the data source. The system assumes this role when
     * accessing the data source.
     */
    val serviceRoleArn: String? = builder.serviceRoleArn
    /**
     * The type of the data source.
     * AMAZON_DYNAMODB: The data source is an Amazon
     * DynamoDB table.
     * AMAZON_ELASTICSEARCH: The data source is an
     * Amazon Elasticsearch Service domain.
     * AWS_LAMBDA: The data source is an Amazon Web Services Lambda
     * function.
     * NONE: There is no data source. This type is
     * used when you wish to invoke a GraphQL operation without connecting to a data source,
     * such as performing data transformation with resolvers or triggering a subscription to
     * be invoked from a mutation.
     * HTTP: The data source is an HTTP
     * endpoint.
     * RELATIONAL_DATABASE: The data source is a
     * relational database.
     */
    val type: DataSourceType? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DataSource = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DataSource(")
        append("dataSourceArn=$dataSourceArn,")
        append("description=$description,")
        append("dynamodbConfig=$dynamodbConfig,")
        append("elasticsearchConfig=$elasticsearchConfig,")
        append("httpConfig=$httpConfig,")
        append("lambdaConfig=$lambdaConfig,")
        append("name=$name,")
        append("relationalDatabaseConfig=$relationalDatabaseConfig,")
        append("serviceRoleArn=$serviceRoleArn,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSourceArn?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (dynamodbConfig?.hashCode() ?: 0)
        result = 31 * result + (elasticsearchConfig?.hashCode() ?: 0)
        result = 31 * result + (httpConfig?.hashCode() ?: 0)
        result = 31 * result + (lambdaConfig?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (relationalDatabaseConfig?.hashCode() ?: 0)
        result = 31 * result + (serviceRoleArn?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DataSource

        if (dataSourceArn != other.dataSourceArn) return false
        if (description != other.description) return false
        if (dynamodbConfig != other.dynamodbConfig) return false
        if (elasticsearchConfig != other.elasticsearchConfig) return false
        if (httpConfig != other.httpConfig) return false
        if (lambdaConfig != other.lambdaConfig) return false
        if (name != other.name) return false
        if (relationalDatabaseConfig != other.relationalDatabaseConfig) return false
        if (serviceRoleArn != other.serviceRoleArn) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DataSource = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DataSource
        /**
         * The data source ARN.
         */
        fun dataSourceArn(dataSourceArn: String): FluentBuilder
        /**
         * The description of the data source.
         */
        fun description(description: String): FluentBuilder
        /**
         * Amazon DynamoDB settings.
         */
        fun dynamodbConfig(dynamodbConfig: DynamodbDataSourceConfig): FluentBuilder
        /**
         * Amazon Elasticsearch Service settings.
         */
        fun elasticsearchConfig(elasticsearchConfig: ElasticsearchDataSourceConfig): FluentBuilder
        /**
         * HTTP endpoint settings.
         */
        fun httpConfig(httpConfig: HttpDataSourceConfig): FluentBuilder
        /**
         * Amazon Web Services Lambda settings.
         */
        fun lambdaConfig(lambdaConfig: LambdaDataSourceConfig): FluentBuilder
        /**
         * The name of the data source.
         */
        fun name(name: String): FluentBuilder
        /**
         * Relational database settings.
         */
        fun relationalDatabaseConfig(relationalDatabaseConfig: RelationalDatabaseDataSourceConfig): FluentBuilder
        /**
         * The Identity and Access Management service role ARN for the data source. The system assumes this role when
         * accessing the data source.
         */
        fun serviceRoleArn(serviceRoleArn: String): FluentBuilder
        /**
         * The type of the data source.
         * AMAZON_DYNAMODB: The data source is an Amazon
         * DynamoDB table.
         * AMAZON_ELASTICSEARCH: The data source is an
         * Amazon Elasticsearch Service domain.
         * AWS_LAMBDA: The data source is an Amazon Web Services Lambda
         * function.
         * NONE: There is no data source. This type is
         * used when you wish to invoke a GraphQL operation without connecting to a data source,
         * such as performing data transformation with resolvers or triggering a subscription to
         * be invoked from a mutation.
         * HTTP: The data source is an HTTP
         * endpoint.
         * RELATIONAL_DATABASE: The data source is a
         * relational database.
         */
        fun type(type: DataSourceType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The data source ARN.
         */
        var dataSourceArn: String?
        /**
         * The description of the data source.
         */
        var description: String?
        /**
         * Amazon DynamoDB settings.
         */
        var dynamodbConfig: DynamodbDataSourceConfig?
        /**
         * Amazon Elasticsearch Service settings.
         */
        var elasticsearchConfig: ElasticsearchDataSourceConfig?
        /**
         * HTTP endpoint settings.
         */
        var httpConfig: HttpDataSourceConfig?
        /**
         * Amazon Web Services Lambda settings.
         */
        var lambdaConfig: LambdaDataSourceConfig?
        /**
         * The name of the data source.
         */
        var name: String?
        /**
         * Relational database settings.
         */
        var relationalDatabaseConfig: RelationalDatabaseDataSourceConfig?
        /**
         * The Identity and Access Management service role ARN for the data source. The system assumes this role when
         * accessing the data source.
         */
        var serviceRoleArn: String?
        /**
         * The type of the data source.
         * AMAZON_DYNAMODB: The data source is an Amazon
         * DynamoDB table.
         * AMAZON_ELASTICSEARCH: The data source is an
         * Amazon Elasticsearch Service domain.
         * AWS_LAMBDA: The data source is an Amazon Web Services Lambda
         * function.
         * NONE: There is no data source. This type is
         * used when you wish to invoke a GraphQL operation without connecting to a data source,
         * such as performing data transformation with resolvers or triggering a subscription to
         * be invoked from a mutation.
         * HTTP: The data source is an HTTP
         * endpoint.
         * RELATIONAL_DATABASE: The data source is a
         * relational database.
         */
        var type: DataSourceType?

        fun build(): DataSource
        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.DynamodbDataSourceConfig] inside the given [block]
         */
        fun dynamodbConfig(block: DynamodbDataSourceConfig.DslBuilder.() -> kotlin.Unit) {
            this.dynamodbConfig = DynamodbDataSourceConfig.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.ElasticsearchDataSourceConfig] inside the given [block]
         */
        fun elasticsearchConfig(block: ElasticsearchDataSourceConfig.DslBuilder.() -> kotlin.Unit) {
            this.elasticsearchConfig = ElasticsearchDataSourceConfig.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.HttpDataSourceConfig] inside the given [block]
         */
        fun httpConfig(block: HttpDataSourceConfig.DslBuilder.() -> kotlin.Unit) {
            this.httpConfig = HttpDataSourceConfig.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.LambdaDataSourceConfig] inside the given [block]
         */
        fun lambdaConfig(block: LambdaDataSourceConfig.DslBuilder.() -> kotlin.Unit) {
            this.lambdaConfig = LambdaDataSourceConfig.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.RelationalDatabaseDataSourceConfig] inside the given [block]
         */
        fun relationalDatabaseConfig(block: RelationalDatabaseDataSourceConfig.DslBuilder.() -> kotlin.Unit) {
            this.relationalDatabaseConfig = RelationalDatabaseDataSourceConfig.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dataSourceArn: String? = null
        override var description: String? = null
        override var dynamodbConfig: DynamodbDataSourceConfig? = null
        override var elasticsearchConfig: ElasticsearchDataSourceConfig? = null
        override var httpConfig: HttpDataSourceConfig? = null
        override var lambdaConfig: LambdaDataSourceConfig? = null
        override var name: String? = null
        override var relationalDatabaseConfig: RelationalDatabaseDataSourceConfig? = null
        override var serviceRoleArn: String? = null
        override var type: DataSourceType? = null

        constructor(x: DataSource) : this() {
            this.dataSourceArn = x.dataSourceArn
            this.description = x.description
            this.dynamodbConfig = x.dynamodbConfig
            this.elasticsearchConfig = x.elasticsearchConfig
            this.httpConfig = x.httpConfig
            this.lambdaConfig = x.lambdaConfig
            this.name = x.name
            this.relationalDatabaseConfig = x.relationalDatabaseConfig
            this.serviceRoleArn = x.serviceRoleArn
            this.type = x.type
        }

        override fun build(): DataSource = DataSource(this)
        override fun dataSourceArn(dataSourceArn: String): FluentBuilder = apply { this.dataSourceArn = dataSourceArn }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun dynamodbConfig(dynamodbConfig: DynamodbDataSourceConfig): FluentBuilder = apply { this.dynamodbConfig = dynamodbConfig }
        override fun elasticsearchConfig(elasticsearchConfig: ElasticsearchDataSourceConfig): FluentBuilder = apply { this.elasticsearchConfig = elasticsearchConfig }
        override fun httpConfig(httpConfig: HttpDataSourceConfig): FluentBuilder = apply { this.httpConfig = httpConfig }
        override fun lambdaConfig(lambdaConfig: LambdaDataSourceConfig): FluentBuilder = apply { this.lambdaConfig = lambdaConfig }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun relationalDatabaseConfig(relationalDatabaseConfig: RelationalDatabaseDataSourceConfig): FluentBuilder = apply { this.relationalDatabaseConfig = relationalDatabaseConfig }
        override fun serviceRoleArn(serviceRoleArn: String): FluentBuilder = apply { this.serviceRoleArn = serviceRoleArn }
        override fun type(type: DataSourceType): FluentBuilder = apply { this.type = type }
    }
}
