// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model



/**
 * Describes an Amazon DynamoDB data source configuration.
 */
class DynamodbDataSourceConfig private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Web Services Region.
     */
    val awsRegion: String? = builder.awsRegion
    /**
     * The DeltaSyncConfig for a versioned datasource.
     */
    val deltaSyncConfig: DeltaSyncConfig? = builder.deltaSyncConfig
    /**
     * The table name.
     */
    val tableName: String? = builder.tableName
    /**
     * Set to TRUE to use Amazon Cognito credentials with this data source.
     */
    val useCallerCredentials: Boolean = builder.useCallerCredentials
    /**
     * Set to TRUE to use Conflict Detection and Resolution with this data source.
     */
    val versioned: Boolean = builder.versioned

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DynamodbDataSourceConfig = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DynamodbDataSourceConfig(")
        append("awsRegion=$awsRegion,")
        append("deltaSyncConfig=$deltaSyncConfig,")
        append("tableName=$tableName,")
        append("useCallerCredentials=$useCallerCredentials,")
        append("versioned=$versioned)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsRegion?.hashCode() ?: 0
        result = 31 * result + (deltaSyncConfig?.hashCode() ?: 0)
        result = 31 * result + (tableName?.hashCode() ?: 0)
        result = 31 * result + (useCallerCredentials.hashCode())
        result = 31 * result + (versioned.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DynamodbDataSourceConfig

        if (awsRegion != other.awsRegion) return false
        if (deltaSyncConfig != other.deltaSyncConfig) return false
        if (tableName != other.tableName) return false
        if (useCallerCredentials != other.useCallerCredentials) return false
        if (versioned != other.versioned) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DynamodbDataSourceConfig = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DynamodbDataSourceConfig
        /**
         * The Amazon Web Services Region.
         */
        fun awsRegion(awsRegion: String): FluentBuilder
        /**
         * The DeltaSyncConfig for a versioned datasource.
         */
        fun deltaSyncConfig(deltaSyncConfig: DeltaSyncConfig): FluentBuilder
        /**
         * The table name.
         */
        fun tableName(tableName: String): FluentBuilder
        /**
         * Set to TRUE to use Amazon Cognito credentials with this data source.
         */
        fun useCallerCredentials(useCallerCredentials: Boolean): FluentBuilder
        /**
         * Set to TRUE to use Conflict Detection and Resolution with this data source.
         */
        fun versioned(versioned: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Web Services Region.
         */
        var awsRegion: String?
        /**
         * The DeltaSyncConfig for a versioned datasource.
         */
        var deltaSyncConfig: DeltaSyncConfig?
        /**
         * The table name.
         */
        var tableName: String?
        /**
         * Set to TRUE to use Amazon Cognito credentials with this data source.
         */
        var useCallerCredentials: Boolean
        /**
         * Set to TRUE to use Conflict Detection and Resolution with this data source.
         */
        var versioned: Boolean

        fun build(): DynamodbDataSourceConfig
        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.DeltaSyncConfig] inside the given [block]
         */
        fun deltaSyncConfig(block: DeltaSyncConfig.DslBuilder.() -> kotlin.Unit) {
            this.deltaSyncConfig = DeltaSyncConfig.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var awsRegion: String? = null
        override var deltaSyncConfig: DeltaSyncConfig? = null
        override var tableName: String? = null
        override var useCallerCredentials: Boolean = false
        override var versioned: Boolean = false

        constructor(x: DynamodbDataSourceConfig) : this() {
            this.awsRegion = x.awsRegion
            this.deltaSyncConfig = x.deltaSyncConfig
            this.tableName = x.tableName
            this.useCallerCredentials = x.useCallerCredentials
            this.versioned = x.versioned
        }

        override fun build(): DynamodbDataSourceConfig = DynamodbDataSourceConfig(this)
        override fun awsRegion(awsRegion: String): FluentBuilder = apply { this.awsRegion = awsRegion }
        override fun deltaSyncConfig(deltaSyncConfig: DeltaSyncConfig): FluentBuilder = apply { this.deltaSyncConfig = deltaSyncConfig }
        override fun tableName(tableName: String): FluentBuilder = apply { this.tableName = tableName }
        override fun useCallerCredentials(useCallerCredentials: Boolean): FluentBuilder = apply { this.useCallerCredentials = useCallerCredentials }
        override fun versioned(versioned: Boolean): FluentBuilder = apply { this.versioned = versioned }
    }
}
