// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model



/**
 * A function is a reusable entity. Multiple functions can be used to compose the resolver
 * logic.
 */
class FunctionConfiguration private constructor(builder: BuilderImpl) {
    /**
     * The name of the DataSource.
     */
    val dataSourceName: String? = builder.dataSourceName
    /**
     * The Function description.
     */
    val description: String? = builder.description
    /**
     * The ARN of the Function object.
     */
    val functionArn: String? = builder.functionArn
    /**
     * A unique ID representing the Function object.
     */
    val functionId: String? = builder.functionId
    /**
     * The version of the request mapping template. Currently only the 2018-05-29 version of
     * the template is supported.
     */
    val functionVersion: String? = builder.functionVersion
    /**
     * The name of the Function object.
     */
    val name: String? = builder.name
    /**
     * The Function request mapping template. Functions support only the
     * 2018-05-29 version of the request mapping template.
     */
    val requestMappingTemplate: String? = builder.requestMappingTemplate
    /**
     * The Function response mapping template.
     */
    val responseMappingTemplate: String? = builder.responseMappingTemplate
    /**
     * Describes a Sync configuration for a resolver.
     * Contains information on which Conflict Detection as well as Resolution strategy should
     * be performed when the resolver is invoked.
     */
    val syncConfig: SyncConfig? = builder.syncConfig

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): FunctionConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("FunctionConfiguration(")
        append("dataSourceName=$dataSourceName,")
        append("description=$description,")
        append("functionArn=$functionArn,")
        append("functionId=$functionId,")
        append("functionVersion=$functionVersion,")
        append("name=$name,")
        append("requestMappingTemplate=$requestMappingTemplate,")
        append("responseMappingTemplate=$responseMappingTemplate,")
        append("syncConfig=$syncConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSourceName?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (functionArn?.hashCode() ?: 0)
        result = 31 * result + (functionId?.hashCode() ?: 0)
        result = 31 * result + (functionVersion?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (requestMappingTemplate?.hashCode() ?: 0)
        result = 31 * result + (responseMappingTemplate?.hashCode() ?: 0)
        result = 31 * result + (syncConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as FunctionConfiguration

        if (dataSourceName != other.dataSourceName) return false
        if (description != other.description) return false
        if (functionArn != other.functionArn) return false
        if (functionId != other.functionId) return false
        if (functionVersion != other.functionVersion) return false
        if (name != other.name) return false
        if (requestMappingTemplate != other.requestMappingTemplate) return false
        if (responseMappingTemplate != other.responseMappingTemplate) return false
        if (syncConfig != other.syncConfig) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): FunctionConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): FunctionConfiguration
        /**
         * The name of the DataSource.
         */
        fun dataSourceName(dataSourceName: String): FluentBuilder
        /**
         * The Function description.
         */
        fun description(description: String): FluentBuilder
        /**
         * The ARN of the Function object.
         */
        fun functionArn(functionArn: String): FluentBuilder
        /**
         * A unique ID representing the Function object.
         */
        fun functionId(functionId: String): FluentBuilder
        /**
         * The version of the request mapping template. Currently only the 2018-05-29 version of
         * the template is supported.
         */
        fun functionVersion(functionVersion: String): FluentBuilder
        /**
         * The name of the Function object.
         */
        fun name(name: String): FluentBuilder
        /**
         * The Function request mapping template. Functions support only the
         * 2018-05-29 version of the request mapping template.
         */
        fun requestMappingTemplate(requestMappingTemplate: String): FluentBuilder
        /**
         * The Function response mapping template.
         */
        fun responseMappingTemplate(responseMappingTemplate: String): FluentBuilder
        /**
         * Describes a Sync configuration for a resolver.
         * Contains information on which Conflict Detection as well as Resolution strategy should
         * be performed when the resolver is invoked.
         */
        fun syncConfig(syncConfig: SyncConfig): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the DataSource.
         */
        var dataSourceName: String?
        /**
         * The Function description.
         */
        var description: String?
        /**
         * The ARN of the Function object.
         */
        var functionArn: String?
        /**
         * A unique ID representing the Function object.
         */
        var functionId: String?
        /**
         * The version of the request mapping template. Currently only the 2018-05-29 version of
         * the template is supported.
         */
        var functionVersion: String?
        /**
         * The name of the Function object.
         */
        var name: String?
        /**
         * The Function request mapping template. Functions support only the
         * 2018-05-29 version of the request mapping template.
         */
        var requestMappingTemplate: String?
        /**
         * The Function response mapping template.
         */
        var responseMappingTemplate: String?
        /**
         * Describes a Sync configuration for a resolver.
         * Contains information on which Conflict Detection as well as Resolution strategy should
         * be performed when the resolver is invoked.
         */
        var syncConfig: SyncConfig?

        fun build(): FunctionConfiguration
        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.SyncConfig] inside the given [block]
         */
        fun syncConfig(block: SyncConfig.DslBuilder.() -> kotlin.Unit) {
            this.syncConfig = SyncConfig.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dataSourceName: String? = null
        override var description: String? = null
        override var functionArn: String? = null
        override var functionId: String? = null
        override var functionVersion: String? = null
        override var name: String? = null
        override var requestMappingTemplate: String? = null
        override var responseMappingTemplate: String? = null
        override var syncConfig: SyncConfig? = null

        constructor(x: FunctionConfiguration) : this() {
            this.dataSourceName = x.dataSourceName
            this.description = x.description
            this.functionArn = x.functionArn
            this.functionId = x.functionId
            this.functionVersion = x.functionVersion
            this.name = x.name
            this.requestMappingTemplate = x.requestMappingTemplate
            this.responseMappingTemplate = x.responseMappingTemplate
            this.syncConfig = x.syncConfig
        }

        override fun build(): FunctionConfiguration = FunctionConfiguration(this)
        override fun dataSourceName(dataSourceName: String): FluentBuilder = apply { this.dataSourceName = dataSourceName }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun functionArn(functionArn: String): FluentBuilder = apply { this.functionArn = functionArn }
        override fun functionId(functionId: String): FluentBuilder = apply { this.functionId = functionId }
        override fun functionVersion(functionVersion: String): FluentBuilder = apply { this.functionVersion = functionVersion }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun requestMappingTemplate(requestMappingTemplate: String): FluentBuilder = apply { this.requestMappingTemplate = requestMappingTemplate }
        override fun responseMappingTemplate(responseMappingTemplate: String): FluentBuilder = apply { this.responseMappingTemplate = responseMappingTemplate }
        override fun syncConfig(syncConfig: SyncConfig): FluentBuilder = apply { this.syncConfig = syncConfig }
    }
}
