// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model



/**
 * Describes a GraphQL API.
 */
class GraphqlApi private constructor(builder: BuilderImpl) {
    /**
     * A list of additional authentication providers for the GraphqlApi
     * API.
     */
    val additionalAuthenticationProviders: List<AdditionalAuthenticationProvider>? = builder.additionalAuthenticationProviders
    /**
     * The API ID.
     */
    val apiId: String? = builder.apiId
    /**
     * The ARN.
     */
    val arn: String? = builder.arn
    /**
     * The authentication type.
     */
    val authenticationType: AuthenticationType? = builder.authenticationType
    /**
     * Configuration for AWS Lambda function authorization.
     */
    val lambdaAuthorizerConfig: LambdaAuthorizerConfig? = builder.lambdaAuthorizerConfig
    /**
     * The Amazon CloudWatch Logs configuration.
     */
    val logConfig: LogConfig? = builder.logConfig
    /**
     * The API name.
     */
    val name: String? = builder.name
    /**
     * The OpenID Connect configuration.
     */
    val openIdConnectConfig: OpenIdConnectConfig? = builder.openIdConnectConfig
    /**
     * The tags.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The URIs.
     */
    val uris: Map<String, String>? = builder.uris
    /**
     * The Amazon Cognito user pool configuration.
     */
    val userPoolConfig: UserPoolConfig? = builder.userPoolConfig
    /**
     * The ARN of the WAF ACL associated with this
     * GraphqlApi, if one exists.
     */
    val wafWebAclArn: String? = builder.wafWebAclArn
    /**
     * A flag representing whether X-Ray tracing is enabled for this
     * GraphqlApi.
     */
    val xrayEnabled: Boolean = builder.xrayEnabled

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GraphqlApi = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GraphqlApi(")
        append("additionalAuthenticationProviders=$additionalAuthenticationProviders,")
        append("apiId=$apiId,")
        append("arn=$arn,")
        append("authenticationType=$authenticationType,")
        append("lambdaAuthorizerConfig=$lambdaAuthorizerConfig,")
        append("logConfig=$logConfig,")
        append("name=$name,")
        append("openIdConnectConfig=$openIdConnectConfig,")
        append("tags=$tags,")
        append("uris=$uris,")
        append("userPoolConfig=$userPoolConfig,")
        append("wafWebAclArn=$wafWebAclArn,")
        append("xrayEnabled=$xrayEnabled)")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalAuthenticationProviders?.hashCode() ?: 0
        result = 31 * result + (apiId?.hashCode() ?: 0)
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (authenticationType?.hashCode() ?: 0)
        result = 31 * result + (lambdaAuthorizerConfig?.hashCode() ?: 0)
        result = 31 * result + (logConfig?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (openIdConnectConfig?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (uris?.hashCode() ?: 0)
        result = 31 * result + (userPoolConfig?.hashCode() ?: 0)
        result = 31 * result + (wafWebAclArn?.hashCode() ?: 0)
        result = 31 * result + (xrayEnabled.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GraphqlApi

        if (additionalAuthenticationProviders != other.additionalAuthenticationProviders) return false
        if (apiId != other.apiId) return false
        if (arn != other.arn) return false
        if (authenticationType != other.authenticationType) return false
        if (lambdaAuthorizerConfig != other.lambdaAuthorizerConfig) return false
        if (logConfig != other.logConfig) return false
        if (name != other.name) return false
        if (openIdConnectConfig != other.openIdConnectConfig) return false
        if (tags != other.tags) return false
        if (uris != other.uris) return false
        if (userPoolConfig != other.userPoolConfig) return false
        if (wafWebAclArn != other.wafWebAclArn) return false
        if (xrayEnabled != other.xrayEnabled) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GraphqlApi = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GraphqlApi
        /**
         * A list of additional authentication providers for the GraphqlApi
         * API.
         */
        fun additionalAuthenticationProviders(additionalAuthenticationProviders: List<AdditionalAuthenticationProvider>): FluentBuilder
        /**
         * The API ID.
         */
        fun apiId(apiId: String): FluentBuilder
        /**
         * The ARN.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The authentication type.
         */
        fun authenticationType(authenticationType: AuthenticationType): FluentBuilder
        /**
         * Configuration for AWS Lambda function authorization.
         */
        fun lambdaAuthorizerConfig(lambdaAuthorizerConfig: LambdaAuthorizerConfig): FluentBuilder
        /**
         * The Amazon CloudWatch Logs configuration.
         */
        fun logConfig(logConfig: LogConfig): FluentBuilder
        /**
         * The API name.
         */
        fun name(name: String): FluentBuilder
        /**
         * The OpenID Connect configuration.
         */
        fun openIdConnectConfig(openIdConnectConfig: OpenIdConnectConfig): FluentBuilder
        /**
         * The tags.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
        /**
         * The URIs.
         */
        fun uris(uris: Map<String, String>): FluentBuilder
        /**
         * The Amazon Cognito user pool configuration.
         */
        fun userPoolConfig(userPoolConfig: UserPoolConfig): FluentBuilder
        /**
         * The ARN of the WAF ACL associated with this
         * GraphqlApi, if one exists.
         */
        fun wafWebAclArn(wafWebAclArn: String): FluentBuilder
        /**
         * A flag representing whether X-Ray tracing is enabled for this
         * GraphqlApi.
         */
        fun xrayEnabled(xrayEnabled: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A list of additional authentication providers for the GraphqlApi
         * API.
         */
        var additionalAuthenticationProviders: List<AdditionalAuthenticationProvider>?
        /**
         * The API ID.
         */
        var apiId: String?
        /**
         * The ARN.
         */
        var arn: String?
        /**
         * The authentication type.
         */
        var authenticationType: AuthenticationType?
        /**
         * Configuration for AWS Lambda function authorization.
         */
        var lambdaAuthorizerConfig: LambdaAuthorizerConfig?
        /**
         * The Amazon CloudWatch Logs configuration.
         */
        var logConfig: LogConfig?
        /**
         * The API name.
         */
        var name: String?
        /**
         * The OpenID Connect configuration.
         */
        var openIdConnectConfig: OpenIdConnectConfig?
        /**
         * The tags.
         */
        var tags: Map<String, String>?
        /**
         * The URIs.
         */
        var uris: Map<String, String>?
        /**
         * The Amazon Cognito user pool configuration.
         */
        var userPoolConfig: UserPoolConfig?
        /**
         * The ARN of the WAF ACL associated with this
         * GraphqlApi, if one exists.
         */
        var wafWebAclArn: String?
        /**
         * A flag representing whether X-Ray tracing is enabled for this
         * GraphqlApi.
         */
        var xrayEnabled: Boolean

        fun build(): GraphqlApi
        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.LambdaAuthorizerConfig] inside the given [block]
         */
        fun lambdaAuthorizerConfig(block: LambdaAuthorizerConfig.DslBuilder.() -> kotlin.Unit) {
            this.lambdaAuthorizerConfig = LambdaAuthorizerConfig.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.LogConfig] inside the given [block]
         */
        fun logConfig(block: LogConfig.DslBuilder.() -> kotlin.Unit) {
            this.logConfig = LogConfig.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.OpenIdConnectConfig] inside the given [block]
         */
        fun openIdConnectConfig(block: OpenIdConnectConfig.DslBuilder.() -> kotlin.Unit) {
            this.openIdConnectConfig = OpenIdConnectConfig.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.UserPoolConfig] inside the given [block]
         */
        fun userPoolConfig(block: UserPoolConfig.DslBuilder.() -> kotlin.Unit) {
            this.userPoolConfig = UserPoolConfig.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var additionalAuthenticationProviders: List<AdditionalAuthenticationProvider>? = null
        override var apiId: String? = null
        override var arn: String? = null
        override var authenticationType: AuthenticationType? = null
        override var lambdaAuthorizerConfig: LambdaAuthorizerConfig? = null
        override var logConfig: LogConfig? = null
        override var name: String? = null
        override var openIdConnectConfig: OpenIdConnectConfig? = null
        override var tags: Map<String, String>? = null
        override var uris: Map<String, String>? = null
        override var userPoolConfig: UserPoolConfig? = null
        override var wafWebAclArn: String? = null
        override var xrayEnabled: Boolean = false

        constructor(x: GraphqlApi) : this() {
            this.additionalAuthenticationProviders = x.additionalAuthenticationProviders
            this.apiId = x.apiId
            this.arn = x.arn
            this.authenticationType = x.authenticationType
            this.lambdaAuthorizerConfig = x.lambdaAuthorizerConfig
            this.logConfig = x.logConfig
            this.name = x.name
            this.openIdConnectConfig = x.openIdConnectConfig
            this.tags = x.tags
            this.uris = x.uris
            this.userPoolConfig = x.userPoolConfig
            this.wafWebAclArn = x.wafWebAclArn
            this.xrayEnabled = x.xrayEnabled
        }

        override fun build(): GraphqlApi = GraphqlApi(this)
        override fun additionalAuthenticationProviders(additionalAuthenticationProviders: List<AdditionalAuthenticationProvider>): FluentBuilder = apply { this.additionalAuthenticationProviders = additionalAuthenticationProviders }
        override fun apiId(apiId: String): FluentBuilder = apply { this.apiId = apiId }
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun authenticationType(authenticationType: AuthenticationType): FluentBuilder = apply { this.authenticationType = authenticationType }
        override fun lambdaAuthorizerConfig(lambdaAuthorizerConfig: LambdaAuthorizerConfig): FluentBuilder = apply { this.lambdaAuthorizerConfig = lambdaAuthorizerConfig }
        override fun logConfig(logConfig: LogConfig): FluentBuilder = apply { this.logConfig = logConfig }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun openIdConnectConfig(openIdConnectConfig: OpenIdConnectConfig): FluentBuilder = apply { this.openIdConnectConfig = openIdConnectConfig }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
        override fun uris(uris: Map<String, String>): FluentBuilder = apply { this.uris = uris }
        override fun userPoolConfig(userPoolConfig: UserPoolConfig): FluentBuilder = apply { this.userPoolConfig = userPoolConfig }
        override fun wafWebAclArn(wafWebAclArn: String): FluentBuilder = apply { this.wafWebAclArn = wafWebAclArn }
        override fun xrayEnabled(xrayEnabled: Boolean): FluentBuilder = apply { this.xrayEnabled = xrayEnabled }
    }
}
