// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model



/**
 * Describes an HTTP data source configuration.
 */
class HttpDataSourceConfig private constructor(builder: BuilderImpl) {
    /**
     * The authorization config in case the HTTP endpoint requires authorization.
     */
    val authorizationConfig: AuthorizationConfig? = builder.authorizationConfig
    /**
     * The HTTP URL endpoint. You can either specify the domain name or IP, and port
     * combination, and the URL scheme must be HTTP or HTTPS. If the port is not specified, AppSync uses the default port 80 for the HTTP endpoint and port 443 for HTTPS
     * endpoints.
     */
    val endpoint: String? = builder.endpoint

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): HttpDataSourceConfig = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("HttpDataSourceConfig(")
        append("authorizationConfig=$authorizationConfig,")
        append("endpoint=$endpoint)")
    }

    override fun hashCode(): kotlin.Int {
        var result = authorizationConfig?.hashCode() ?: 0
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as HttpDataSourceConfig

        if (authorizationConfig != other.authorizationConfig) return false
        if (endpoint != other.endpoint) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): HttpDataSourceConfig = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): HttpDataSourceConfig
        /**
         * The authorization config in case the HTTP endpoint requires authorization.
         */
        fun authorizationConfig(authorizationConfig: AuthorizationConfig): FluentBuilder
        /**
         * The HTTP URL endpoint. You can either specify the domain name or IP, and port
         * combination, and the URL scheme must be HTTP or HTTPS. If the port is not specified, AppSync uses the default port 80 for the HTTP endpoint and port 443 for HTTPS
         * endpoints.
         */
        fun endpoint(endpoint: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The authorization config in case the HTTP endpoint requires authorization.
         */
        var authorizationConfig: AuthorizationConfig?
        /**
         * The HTTP URL endpoint. You can either specify the domain name or IP, and port
         * combination, and the URL scheme must be HTTP or HTTPS. If the port is not specified, AppSync uses the default port 80 for the HTTP endpoint and port 443 for HTTPS
         * endpoints.
         */
        var endpoint: String?

        fun build(): HttpDataSourceConfig
        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.AuthorizationConfig] inside the given [block]
         */
        fun authorizationConfig(block: AuthorizationConfig.DslBuilder.() -> kotlin.Unit) {
            this.authorizationConfig = AuthorizationConfig.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var authorizationConfig: AuthorizationConfig? = null
        override var endpoint: String? = null

        constructor(x: HttpDataSourceConfig) : this() {
            this.authorizationConfig = x.authorizationConfig
            this.endpoint = x.endpoint
        }

        override fun build(): HttpDataSourceConfig = HttpDataSourceConfig(this)
        override fun authorizationConfig(authorizationConfig: AuthorizationConfig): FluentBuilder = apply { this.authorizationConfig = authorizationConfig }
        override fun endpoint(endpoint: String): FluentBuilder = apply { this.endpoint = endpoint }
    }
}
