// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model



/**
 * A LambdaAuthorizerConfig holds configuration on how to authorize AppSync API access when using
 * the AWS_LAMBDA authorizer mode. Be aware that an AppSync API may have only one Lambda authorizer configured
 * at a time.
 */
class LambdaAuthorizerConfig private constructor(builder: BuilderImpl) {
    /**
     * The number of seconds a response should be cached for. The default is 5 minutes (300 seconds).
     * The Lambda function can override this by returning a
     * ttlOverride key in its response. A value of 0 disables caching of
     * responses.
     */
    val authorizerResultTtlInSeconds: Int = builder.authorizerResultTtlInSeconds
    /**
     * The ARN of the lambda function to be called for authorization. This may be a standard
     * Lambda ARN, a version ARN (.../v3) or alias ARN.
     * Note: This Lambda function must have the following resource-based
     * policy assigned to it. When configuring Lambda authorizers in the Console, this is done for
     * you. To do so with the AWS CLI, run the following:
     * aws lambda add-permission --function-name "arn:aws:lambda:us-east-2:111122223333:function:my-function" --statement-id "appsync" --principal appsync.amazonaws.com --action lambda:InvokeFunction
     */
    val authorizerUri: String? = builder.authorizerUri
    /**
     * A regular expression for validation of tokens before the Lambda Function is called.
     */
    val identityValidationExpression: String? = builder.identityValidationExpression

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): LambdaAuthorizerConfig = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaAuthorizerConfig(")
        append("authorizerResultTtlInSeconds=$authorizerResultTtlInSeconds,")
        append("authorizerUri=$authorizerUri,")
        append("identityValidationExpression=$identityValidationExpression)")
    }

    override fun hashCode(): kotlin.Int {
        var result = authorizerResultTtlInSeconds
        result = 31 * result + (authorizerUri?.hashCode() ?: 0)
        result = 31 * result + (identityValidationExpression?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LambdaAuthorizerConfig

        if (authorizerResultTtlInSeconds != other.authorizerResultTtlInSeconds) return false
        if (authorizerUri != other.authorizerUri) return false
        if (identityValidationExpression != other.identityValidationExpression) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): LambdaAuthorizerConfig = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): LambdaAuthorizerConfig
        /**
         * The number of seconds a response should be cached for. The default is 5 minutes (300 seconds).
         * The Lambda function can override this by returning a
         * ttlOverride key in its response. A value of 0 disables caching of
         * responses.
         */
        fun authorizerResultTtlInSeconds(authorizerResultTtlInSeconds: Int): FluentBuilder
        /**
         * The ARN of the lambda function to be called for authorization. This may be a standard
         * Lambda ARN, a version ARN (.../v3) or alias ARN.
         * Note: This Lambda function must have the following resource-based
         * policy assigned to it. When configuring Lambda authorizers in the Console, this is done for
         * you. To do so with the AWS CLI, run the following:
         * aws lambda add-permission --function-name "arn:aws:lambda:us-east-2:111122223333:function:my-function" --statement-id "appsync" --principal appsync.amazonaws.com --action lambda:InvokeFunction
         */
        fun authorizerUri(authorizerUri: String): FluentBuilder
        /**
         * A regular expression for validation of tokens before the Lambda Function is called.
         */
        fun identityValidationExpression(identityValidationExpression: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The number of seconds a response should be cached for. The default is 5 minutes (300 seconds).
         * The Lambda function can override this by returning a
         * ttlOverride key in its response. A value of 0 disables caching of
         * responses.
         */
        var authorizerResultTtlInSeconds: Int
        /**
         * The ARN of the lambda function to be called for authorization. This may be a standard
         * Lambda ARN, a version ARN (.../v3) or alias ARN.
         * Note: This Lambda function must have the following resource-based
         * policy assigned to it. When configuring Lambda authorizers in the Console, this is done for
         * you. To do so with the AWS CLI, run the following:
         * aws lambda add-permission --function-name "arn:aws:lambda:us-east-2:111122223333:function:my-function" --statement-id "appsync" --principal appsync.amazonaws.com --action lambda:InvokeFunction
         */
        var authorizerUri: String?
        /**
         * A regular expression for validation of tokens before the Lambda Function is called.
         */
        var identityValidationExpression: String?

        fun build(): LambdaAuthorizerConfig
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var authorizerResultTtlInSeconds: Int = 0
        override var authorizerUri: String? = null
        override var identityValidationExpression: String? = null

        constructor(x: LambdaAuthorizerConfig) : this() {
            this.authorizerResultTtlInSeconds = x.authorizerResultTtlInSeconds
            this.authorizerUri = x.authorizerUri
            this.identityValidationExpression = x.identityValidationExpression
        }

        override fun build(): LambdaAuthorizerConfig = LambdaAuthorizerConfig(this)
        override fun authorizerResultTtlInSeconds(authorizerResultTtlInSeconds: Int): FluentBuilder = apply { this.authorizerResultTtlInSeconds = authorizerResultTtlInSeconds }
        override fun authorizerUri(authorizerUri: String): FluentBuilder = apply { this.authorizerUri = authorizerUri }
        override fun identityValidationExpression(identityValidationExpression: String): FluentBuilder = apply { this.identityValidationExpression = identityValidationExpression }
    }
}
