// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model



/**
 * The CloudWatch Logs configuration.
 */
class LogConfig private constructor(builder: BuilderImpl) {
    /**
     * The service role that AppSync will assume to publish to Amazon CloudWatch logs in
     * your account.
     */
    val cloudWatchLogsRoleArn: String? = builder.cloudWatchLogsRoleArn
    /**
     * Set to TRUE to exclude sections that contain information such as headers, context, and
     * evaluated mapping templates, regardless of logging level.
     */
    val excludeVerboseContent: Boolean = builder.excludeVerboseContent
    /**
     * The field logging level. Values can be NONE, ERROR, or ALL.
     * NONE: No field-level logs are
     * captured.
     * ERROR: Logs the following information only for
     * the fields that are in error:
     * The error section in the server response.
     * Field-level errors.
     * The generated request/response functions that got resolved for error
     * fields.
     * ALL: The following information is logged for
     * all fields in the query:
     * Field-level tracing information.
     * The generated request/response functions that got resolved for each
     * field.
     */
    val fieldLogLevel: FieldLogLevel? = builder.fieldLogLevel

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): LogConfig = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("LogConfig(")
        append("cloudWatchLogsRoleArn=$cloudWatchLogsRoleArn,")
        append("excludeVerboseContent=$excludeVerboseContent,")
        append("fieldLogLevel=$fieldLogLevel)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchLogsRoleArn?.hashCode() ?: 0
        result = 31 * result + (excludeVerboseContent.hashCode())
        result = 31 * result + (fieldLogLevel?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as LogConfig

        if (cloudWatchLogsRoleArn != other.cloudWatchLogsRoleArn) return false
        if (excludeVerboseContent != other.excludeVerboseContent) return false
        if (fieldLogLevel != other.fieldLogLevel) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): LogConfig = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): LogConfig
        /**
         * The service role that AppSync will assume to publish to Amazon CloudWatch logs in
         * your account.
         */
        fun cloudWatchLogsRoleArn(cloudWatchLogsRoleArn: String): FluentBuilder
        /**
         * Set to TRUE to exclude sections that contain information such as headers, context, and
         * evaluated mapping templates, regardless of logging level.
         */
        fun excludeVerboseContent(excludeVerboseContent: Boolean): FluentBuilder
        /**
         * The field logging level. Values can be NONE, ERROR, or ALL.
         * NONE: No field-level logs are
         * captured.
         * ERROR: Logs the following information only for
         * the fields that are in error:
         * The error section in the server response.
         * Field-level errors.
         * The generated request/response functions that got resolved for error
         * fields.
         * ALL: The following information is logged for
         * all fields in the query:
         * Field-level tracing information.
         * The generated request/response functions that got resolved for each
         * field.
         */
        fun fieldLogLevel(fieldLogLevel: FieldLogLevel): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The service role that AppSync will assume to publish to Amazon CloudWatch logs in
         * your account.
         */
        var cloudWatchLogsRoleArn: String?
        /**
         * Set to TRUE to exclude sections that contain information such as headers, context, and
         * evaluated mapping templates, regardless of logging level.
         */
        var excludeVerboseContent: Boolean
        /**
         * The field logging level. Values can be NONE, ERROR, or ALL.
         * NONE: No field-level logs are
         * captured.
         * ERROR: Logs the following information only for
         * the fields that are in error:
         * The error section in the server response.
         * Field-level errors.
         * The generated request/response functions that got resolved for error
         * fields.
         * ALL: The following information is logged for
         * all fields in the query:
         * Field-level tracing information.
         * The generated request/response functions that got resolved for each
         * field.
         */
        var fieldLogLevel: FieldLogLevel?

        fun build(): LogConfig
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var cloudWatchLogsRoleArn: String? = null
        override var excludeVerboseContent: Boolean = false
        override var fieldLogLevel: FieldLogLevel? = null

        constructor(x: LogConfig) : this() {
            this.cloudWatchLogsRoleArn = x.cloudWatchLogsRoleArn
            this.excludeVerboseContent = x.excludeVerboseContent
            this.fieldLogLevel = x.fieldLogLevel
        }

        override fun build(): LogConfig = LogConfig(this)
        override fun cloudWatchLogsRoleArn(cloudWatchLogsRoleArn: String): FluentBuilder = apply { this.cloudWatchLogsRoleArn = cloudWatchLogsRoleArn }
        override fun excludeVerboseContent(excludeVerboseContent: Boolean): FluentBuilder = apply { this.excludeVerboseContent = excludeVerboseContent }
        override fun fieldLogLevel(fieldLogLevel: FieldLogLevel): FluentBuilder = apply { this.fieldLogLevel = fieldLogLevel }
    }
}
