// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model



/**
 * Describes an OpenID Connect configuration.
 */
class OpenIdConnectConfig private constructor(builder: BuilderImpl) {
    /**
     * The number of milliseconds a token is valid after being authenticated.
     */
    val authTtl: Long = builder.authTtl
    /**
     * The client identifier of the Relying party at the OpenID identity provider. This
     * identifier is typically obtained when the Relying party is registered with the OpenID
     * identity provider. You can specify a regular expression so the AppSync can validate
     * against multiple client identifiers at a time.
     */
    val clientId: String? = builder.clientId
    /**
     * The number of milliseconds a token is valid after being issued to a user.
     */
    val iatTtl: Long = builder.iatTtl
    /**
     * The issuer for the OpenID Connect configuration. The issuer returned by discovery must
     * exactly match the value of iss in the ID token.
     */
    val issuer: String? = builder.issuer

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): OpenIdConnectConfig = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("OpenIdConnectConfig(")
        append("authTtl=$authTtl,")
        append("clientId=$clientId,")
        append("iatTtl=$iatTtl,")
        append("issuer=$issuer)")
    }

    override fun hashCode(): kotlin.Int {
        var result = authTtl.hashCode()
        result = 31 * result + (clientId?.hashCode() ?: 0)
        result = 31 * result + (iatTtl.hashCode())
        result = 31 * result + (issuer?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as OpenIdConnectConfig

        if (authTtl != other.authTtl) return false
        if (clientId != other.clientId) return false
        if (iatTtl != other.iatTtl) return false
        if (issuer != other.issuer) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): OpenIdConnectConfig = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): OpenIdConnectConfig
        /**
         * The number of milliseconds a token is valid after being authenticated.
         */
        fun authTtl(authTtl: Long): FluentBuilder
        /**
         * The client identifier of the Relying party at the OpenID identity provider. This
         * identifier is typically obtained when the Relying party is registered with the OpenID
         * identity provider. You can specify a regular expression so the AppSync can validate
         * against multiple client identifiers at a time.
         */
        fun clientId(clientId: String): FluentBuilder
        /**
         * The number of milliseconds a token is valid after being issued to a user.
         */
        fun iatTtl(iatTtl: Long): FluentBuilder
        /**
         * The issuer for the OpenID Connect configuration. The issuer returned by discovery must
         * exactly match the value of iss in the ID token.
         */
        fun issuer(issuer: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The number of milliseconds a token is valid after being authenticated.
         */
        var authTtl: Long
        /**
         * The client identifier of the Relying party at the OpenID identity provider. This
         * identifier is typically obtained when the Relying party is registered with the OpenID
         * identity provider. You can specify a regular expression so the AppSync can validate
         * against multiple client identifiers at a time.
         */
        var clientId: String?
        /**
         * The number of milliseconds a token is valid after being issued to a user.
         */
        var iatTtl: Long
        /**
         * The issuer for the OpenID Connect configuration. The issuer returned by discovery must
         * exactly match the value of iss in the ID token.
         */
        var issuer: String?

        fun build(): OpenIdConnectConfig
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var authTtl: Long = 0L
        override var clientId: String? = null
        override var iatTtl: Long = 0L
        override var issuer: String? = null

        constructor(x: OpenIdConnectConfig) : this() {
            this.authTtl = x.authTtl
            this.clientId = x.clientId
            this.iatTtl = x.iatTtl
            this.issuer = x.issuer
        }

        override fun build(): OpenIdConnectConfig = OpenIdConnectConfig(this)
        override fun authTtl(authTtl: Long): FluentBuilder = apply { this.authTtl = authTtl }
        override fun clientId(clientId: String): FluentBuilder = apply { this.clientId = clientId }
        override fun iatTtl(iatTtl: Long): FluentBuilder = apply { this.iatTtl = iatTtl }
        override fun issuer(issuer: String): FluentBuilder = apply { this.issuer = issuer }
    }
}
