// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model



/**
 * The Amazon RDS HTTP endpoint configuration.
 */
class RdsHttpEndpointConfig private constructor(builder: BuilderImpl) {
    /**
     * Amazon Web Services Region for RDS HTTP endpoint.
     */
    val awsRegion: String? = builder.awsRegion
    /**
     * Amazon Web Services secret store ARN for database credentials.
     */
    val awsSecretStoreArn: String? = builder.awsSecretStoreArn
    /**
     * Logical database name.
     */
    val databaseName: String? = builder.databaseName
    /**
     * Amazon RDS cluster ARN.
     */
    val dbClusterIdentifier: String? = builder.dbClusterIdentifier
    /**
     * Logical schema name.
     */
    val schema: String? = builder.schema

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RdsHttpEndpointConfig = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RdsHttpEndpointConfig(")
        append("awsRegion=$awsRegion,")
        append("awsSecretStoreArn=$awsSecretStoreArn,")
        append("databaseName=$databaseName,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("schema=$schema)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsRegion?.hashCode() ?: 0
        result = 31 * result + (awsSecretStoreArn?.hashCode() ?: 0)
        result = 31 * result + (databaseName?.hashCode() ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (schema?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RdsHttpEndpointConfig

        if (awsRegion != other.awsRegion) return false
        if (awsSecretStoreArn != other.awsSecretStoreArn) return false
        if (databaseName != other.databaseName) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (schema != other.schema) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RdsHttpEndpointConfig = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RdsHttpEndpointConfig
        /**
         * Amazon Web Services Region for RDS HTTP endpoint.
         */
        fun awsRegion(awsRegion: String): FluentBuilder
        /**
         * Amazon Web Services secret store ARN for database credentials.
         */
        fun awsSecretStoreArn(awsSecretStoreArn: String): FluentBuilder
        /**
         * Logical database name.
         */
        fun databaseName(databaseName: String): FluentBuilder
        /**
         * Amazon RDS cluster ARN.
         */
        fun dbClusterIdentifier(dbClusterIdentifier: String): FluentBuilder
        /**
         * Logical schema name.
         */
        fun schema(schema: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Amazon Web Services Region for RDS HTTP endpoint.
         */
        var awsRegion: String?
        /**
         * Amazon Web Services secret store ARN for database credentials.
         */
        var awsSecretStoreArn: String?
        /**
         * Logical database name.
         */
        var databaseName: String?
        /**
         * Amazon RDS cluster ARN.
         */
        var dbClusterIdentifier: String?
        /**
         * Logical schema name.
         */
        var schema: String?

        fun build(): RdsHttpEndpointConfig
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var awsRegion: String? = null
        override var awsSecretStoreArn: String? = null
        override var databaseName: String? = null
        override var dbClusterIdentifier: String? = null
        override var schema: String? = null

        constructor(x: RdsHttpEndpointConfig) : this() {
            this.awsRegion = x.awsRegion
            this.awsSecretStoreArn = x.awsSecretStoreArn
            this.databaseName = x.databaseName
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.schema = x.schema
        }

        override fun build(): RdsHttpEndpointConfig = RdsHttpEndpointConfig(this)
        override fun awsRegion(awsRegion: String): FluentBuilder = apply { this.awsRegion = awsRegion }
        override fun awsSecretStoreArn(awsSecretStoreArn: String): FluentBuilder = apply { this.awsSecretStoreArn = awsSecretStoreArn }
        override fun databaseName(databaseName: String): FluentBuilder = apply { this.databaseName = databaseName }
        override fun dbClusterIdentifier(dbClusterIdentifier: String): FluentBuilder = apply { this.dbClusterIdentifier = dbClusterIdentifier }
        override fun schema(schema: String): FluentBuilder = apply { this.schema = schema }
    }
}
