// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model



/**
 * Describes a relational database data source configuration.
 */
class RelationalDatabaseDataSourceConfig private constructor(builder: BuilderImpl) {
    /**
     * Amazon RDS HTTP endpoint settings.
     */
    val rdsHttpEndpointConfig: RdsHttpEndpointConfig? = builder.rdsHttpEndpointConfig
    /**
     * Source type for the relational database.
     * RDS_HTTP_ENDPOINT: The relational database
     * source type is an Amazon RDS HTTP endpoint.
     */
    val relationalDatabaseSourceType: RelationalDatabaseSourceType? = builder.relationalDatabaseSourceType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): RelationalDatabaseDataSourceConfig = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("RelationalDatabaseDataSourceConfig(")
        append("rdsHttpEndpointConfig=$rdsHttpEndpointConfig,")
        append("relationalDatabaseSourceType=$relationalDatabaseSourceType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = rdsHttpEndpointConfig?.hashCode() ?: 0
        result = 31 * result + (relationalDatabaseSourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RelationalDatabaseDataSourceConfig

        if (rdsHttpEndpointConfig != other.rdsHttpEndpointConfig) return false
        if (relationalDatabaseSourceType != other.relationalDatabaseSourceType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): RelationalDatabaseDataSourceConfig = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): RelationalDatabaseDataSourceConfig
        /**
         * Amazon RDS HTTP endpoint settings.
         */
        fun rdsHttpEndpointConfig(rdsHttpEndpointConfig: RdsHttpEndpointConfig): FluentBuilder
        /**
         * Source type for the relational database.
         * RDS_HTTP_ENDPOINT: The relational database
         * source type is an Amazon RDS HTTP endpoint.
         */
        fun relationalDatabaseSourceType(relationalDatabaseSourceType: RelationalDatabaseSourceType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Amazon RDS HTTP endpoint settings.
         */
        var rdsHttpEndpointConfig: RdsHttpEndpointConfig?
        /**
         * Source type for the relational database.
         * RDS_HTTP_ENDPOINT: The relational database
         * source type is an Amazon RDS HTTP endpoint.
         */
        var relationalDatabaseSourceType: RelationalDatabaseSourceType?

        fun build(): RelationalDatabaseDataSourceConfig
        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.RdsHttpEndpointConfig] inside the given [block]
         */
        fun rdsHttpEndpointConfig(block: RdsHttpEndpointConfig.DslBuilder.() -> kotlin.Unit) {
            this.rdsHttpEndpointConfig = RdsHttpEndpointConfig.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var rdsHttpEndpointConfig: RdsHttpEndpointConfig? = null
        override var relationalDatabaseSourceType: RelationalDatabaseSourceType? = null

        constructor(x: RelationalDatabaseDataSourceConfig) : this() {
            this.rdsHttpEndpointConfig = x.rdsHttpEndpointConfig
            this.relationalDatabaseSourceType = x.relationalDatabaseSourceType
        }

        override fun build(): RelationalDatabaseDataSourceConfig = RelationalDatabaseDataSourceConfig(this)
        override fun rdsHttpEndpointConfig(rdsHttpEndpointConfig: RdsHttpEndpointConfig): FluentBuilder = apply { this.rdsHttpEndpointConfig = rdsHttpEndpointConfig }
        override fun relationalDatabaseSourceType(relationalDatabaseSourceType: RelationalDatabaseSourceType): FluentBuilder = apply { this.relationalDatabaseSourceType = relationalDatabaseSourceType }
    }
}
