// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model



/**
 * Describes a Sync configuration for a resolver.
 * Contains information on which Conflict Detection as well as Resolution strategy should
 * be performed when the resolver is invoked.
 */
class SyncConfig private constructor(builder: BuilderImpl) {
    /**
     * The Conflict Detection strategy to use.
     * VERSION: Detect conflicts based on object
     * versions for this resolver.
     * NONE: Do not detect conflicts when executing
     * this resolver.
     */
    val conflictDetection: ConflictDetectionType? = builder.conflictDetection
    /**
     * The Conflict Resolution strategy to perform in the event of a conflict.
     * OPTIMISTIC_CONCURRENCY: Resolve conflicts by
     * rejecting mutations when versions do not match the latest version at the
     * server.
     * AUTOMERGE: Resolve conflicts with the
     * Automerge conflict resolution strategy.
     * LAMBDA: Resolve conflicts with a Lambda
     * function supplied in the LambdaConflictHandlerConfig.
     */
    val conflictHandler: ConflictHandlerType? = builder.conflictHandler
    /**
     * The LambdaConflictHandlerConfig when configuring LAMBDA as the Conflict
     * Handler.
     */
    val lambdaConflictHandlerConfig: LambdaConflictHandlerConfig? = builder.lambdaConflictHandlerConfig

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): SyncConfig = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("SyncConfig(")
        append("conflictDetection=$conflictDetection,")
        append("conflictHandler=$conflictHandler,")
        append("lambdaConflictHandlerConfig=$lambdaConflictHandlerConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = conflictDetection?.hashCode() ?: 0
        result = 31 * result + (conflictHandler?.hashCode() ?: 0)
        result = 31 * result + (lambdaConflictHandlerConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SyncConfig

        if (conflictDetection != other.conflictDetection) return false
        if (conflictHandler != other.conflictHandler) return false
        if (lambdaConflictHandlerConfig != other.lambdaConflictHandlerConfig) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): SyncConfig = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): SyncConfig
        /**
         * The Conflict Detection strategy to use.
         * VERSION: Detect conflicts based on object
         * versions for this resolver.
         * NONE: Do not detect conflicts when executing
         * this resolver.
         */
        fun conflictDetection(conflictDetection: ConflictDetectionType): FluentBuilder
        /**
         * The Conflict Resolution strategy to perform in the event of a conflict.
         * OPTIMISTIC_CONCURRENCY: Resolve conflicts by
         * rejecting mutations when versions do not match the latest version at the
         * server.
         * AUTOMERGE: Resolve conflicts with the
         * Automerge conflict resolution strategy.
         * LAMBDA: Resolve conflicts with a Lambda
         * function supplied in the LambdaConflictHandlerConfig.
         */
        fun conflictHandler(conflictHandler: ConflictHandlerType): FluentBuilder
        /**
         * The LambdaConflictHandlerConfig when configuring LAMBDA as the Conflict
         * Handler.
         */
        fun lambdaConflictHandlerConfig(lambdaConflictHandlerConfig: LambdaConflictHandlerConfig): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Conflict Detection strategy to use.
         * VERSION: Detect conflicts based on object
         * versions for this resolver.
         * NONE: Do not detect conflicts when executing
         * this resolver.
         */
        var conflictDetection: ConflictDetectionType?
        /**
         * The Conflict Resolution strategy to perform in the event of a conflict.
         * OPTIMISTIC_CONCURRENCY: Resolve conflicts by
         * rejecting mutations when versions do not match the latest version at the
         * server.
         * AUTOMERGE: Resolve conflicts with the
         * Automerge conflict resolution strategy.
         * LAMBDA: Resolve conflicts with a Lambda
         * function supplied in the LambdaConflictHandlerConfig.
         */
        var conflictHandler: ConflictHandlerType?
        /**
         * The LambdaConflictHandlerConfig when configuring LAMBDA as the Conflict
         * Handler.
         */
        var lambdaConflictHandlerConfig: LambdaConflictHandlerConfig?

        fun build(): SyncConfig
        /**
         * construct an [aws.sdk.kotlin.services.appsync.model.LambdaConflictHandlerConfig] inside the given [block]
         */
        fun lambdaConflictHandlerConfig(block: LambdaConflictHandlerConfig.DslBuilder.() -> kotlin.Unit) {
            this.lambdaConflictHandlerConfig = LambdaConflictHandlerConfig.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var conflictDetection: ConflictDetectionType? = null
        override var conflictHandler: ConflictHandlerType? = null
        override var lambdaConflictHandlerConfig: LambdaConflictHandlerConfig? = null

        constructor(x: SyncConfig) : this() {
            this.conflictDetection = x.conflictDetection
            this.conflictHandler = x.conflictHandler
            this.lambdaConflictHandlerConfig = x.lambdaConflictHandlerConfig
        }

        override fun build(): SyncConfig = SyncConfig(this)
        override fun conflictDetection(conflictDetection: ConflictDetectionType): FluentBuilder = apply { this.conflictDetection = conflictDetection }
        override fun conflictHandler(conflictHandler: ConflictHandlerType): FluentBuilder = apply { this.conflictHandler = conflictHandler }
        override fun lambdaConflictHandlerConfig(lambdaConflictHandlerConfig: LambdaConflictHandlerConfig): FluentBuilder = apply { this.lambdaConflictHandlerConfig = lambdaConflictHandlerConfig }
    }
}
