// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.model



/**
 * Describes an Amazon Cognito user pool configuration.
 */
class UserPoolConfig private constructor(builder: BuilderImpl) {
    /**
     * A regular expression for validating the incoming Amazon Cognito user pool app client
     * ID.
     */
    val appIdClientRegex: String? = builder.appIdClientRegex
    /**
     * The Amazon Web Services Region in which the user pool was created.
     */
    val awsRegion: String? = builder.awsRegion
    /**
     * The action that you want your GraphQL API to take when a request that uses Amazon
     * Cognito user pool authentication doesn't match the Amazon Cognito user pool
     * configuration.
     */
    val defaultAction: DefaultAction? = builder.defaultAction
    /**
     * The user pool ID.
     */
    val userPoolId: String? = builder.userPoolId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UserPoolConfig = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UserPoolConfig(")
        append("appIdClientRegex=$appIdClientRegex,")
        append("awsRegion=$awsRegion,")
        append("defaultAction=$defaultAction,")
        append("userPoolId=$userPoolId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = appIdClientRegex?.hashCode() ?: 0
        result = 31 * result + (awsRegion?.hashCode() ?: 0)
        result = 31 * result + (defaultAction?.hashCode() ?: 0)
        result = 31 * result + (userPoolId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UserPoolConfig

        if (appIdClientRegex != other.appIdClientRegex) return false
        if (awsRegion != other.awsRegion) return false
        if (defaultAction != other.defaultAction) return false
        if (userPoolId != other.userPoolId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UserPoolConfig = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UserPoolConfig
        /**
         * A regular expression for validating the incoming Amazon Cognito user pool app client
         * ID.
         */
        fun appIdClientRegex(appIdClientRegex: String): FluentBuilder
        /**
         * The Amazon Web Services Region in which the user pool was created.
         */
        fun awsRegion(awsRegion: String): FluentBuilder
        /**
         * The action that you want your GraphQL API to take when a request that uses Amazon
         * Cognito user pool authentication doesn't match the Amazon Cognito user pool
         * configuration.
         */
        fun defaultAction(defaultAction: DefaultAction): FluentBuilder
        /**
         * The user pool ID.
         */
        fun userPoolId(userPoolId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A regular expression for validating the incoming Amazon Cognito user pool app client
         * ID.
         */
        var appIdClientRegex: String?
        /**
         * The Amazon Web Services Region in which the user pool was created.
         */
        var awsRegion: String?
        /**
         * The action that you want your GraphQL API to take when a request that uses Amazon
         * Cognito user pool authentication doesn't match the Amazon Cognito user pool
         * configuration.
         */
        var defaultAction: DefaultAction?
        /**
         * The user pool ID.
         */
        var userPoolId: String?

        fun build(): UserPoolConfig
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var appIdClientRegex: String? = null
        override var awsRegion: String? = null
        override var defaultAction: DefaultAction? = null
        override var userPoolId: String? = null

        constructor(x: UserPoolConfig) : this() {
            this.appIdClientRegex = x.appIdClientRegex
            this.awsRegion = x.awsRegion
            this.defaultAction = x.defaultAction
            this.userPoolId = x.userPoolId
        }

        override fun build(): UserPoolConfig = UserPoolConfig(this)
        override fun appIdClientRegex(appIdClientRegex: String): FluentBuilder = apply { this.appIdClientRegex = appIdClientRegex }
        override fun awsRegion(awsRegion: String): FluentBuilder = apply { this.awsRegion = awsRegion }
        override fun defaultAction(defaultAction: DefaultAction): FluentBuilder = apply { this.defaultAction = defaultAction }
        override fun userPoolId(userPoolId: String): FluentBuilder = apply { this.userPoolId = userPoolId }
    }
}
