// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.transform

import aws.sdk.kotlin.services.appsync.model.CreateApiCacheRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateApiCacheOperationSerializer: HttpSerialize<CreateApiCacheRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateApiCacheRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "v1",
                "apis",
                "${input.apiId}".encodeLabel(),
                "ApiCaches",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateApiCacheOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateApiCacheOperationBody(context: ExecutionContext, input: CreateApiCacheRequest): ByteArray {
    val serializer = JsonSerializer()
    val APICACHINGBEHAVIOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("apiCachingBehavior"))
    val ATRESTENCRYPTIONENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("atRestEncryptionEnabled"))
    val TRANSITENCRYPTIONENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("transitEncryptionEnabled"))
    val TTL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("ttl"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("type"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APICACHINGBEHAVIOR_DESCRIPTOR)
        field(ATRESTENCRYPTIONENABLED_DESCRIPTOR)
        field(TRANSITENCRYPTIONENABLED_DESCRIPTOR)
        field(TTL_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.apiCachingBehavior?.let { field(APICACHINGBEHAVIOR_DESCRIPTOR, it.value) }
        if (input.atRestEncryptionEnabled != false) field(ATRESTENCRYPTIONENABLED_DESCRIPTOR, input.atRestEncryptionEnabled)
        if (input.transitEncryptionEnabled != false) field(TRANSITENCRYPTIONENABLED_DESCRIPTOR, input.transitEncryptionEnabled)
        field(TTL_DESCRIPTOR, input.ttl)
        input.type?.let { field(TYPE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
