// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appsync.transform

import aws.sdk.kotlin.services.appsync.model.UpdateFunctionRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateFunctionOperationSerializer: HttpSerialize<UpdateFunctionRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateFunctionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "v1",
                "apis",
                "${input.apiId}".encodeLabel(),
                "functions",
                "${input.functionId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateFunctionOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateFunctionOperationBody(context: ExecutionContext, input: UpdateFunctionRequest): ByteArray {
    val serializer = JsonSerializer()
    val DATASOURCENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("dataSourceName"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val FUNCTIONVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("functionVersion"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val REQUESTMAPPINGTEMPLATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("requestMappingTemplate"))
    val RESPONSEMAPPINGTEMPLATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("responseMappingTemplate"))
    val SYNCCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("syncConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DATASOURCENAME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(FUNCTIONVERSION_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(REQUESTMAPPINGTEMPLATE_DESCRIPTOR)
        field(RESPONSEMAPPINGTEMPLATE_DESCRIPTOR)
        field(SYNCCONFIG_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.dataSourceName?.let { field(DATASOURCENAME_DESCRIPTOR, it) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.functionVersion?.let { field(FUNCTIONVERSION_DESCRIPTOR, it) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.requestMappingTemplate?.let { field(REQUESTMAPPINGTEMPLATE_DESCRIPTOR, it) }
        input.responseMappingTemplate?.let { field(RESPONSEMAPPINGTEMPLATE_DESCRIPTOR, it) }
        input.syncConfig?.let { field(SYNCCONFIG_DESCRIPTOR, it, ::serializeSyncConfigDocument) }
    }
    return serializer.toByteArray()
}
