// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.auditmanager.model.*
import aws.sdk.kotlin.services.auditmanager.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "AuditManager"
const val ServiceApiVersion: String = "2017-07-25"
const val SdkVersion: String = "0.17.0-beta"

internal class DefaultAuditManagerClient(override val config: AuditManagerClient.Config) : AuditManagerClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Associates an evidence folder to an assessment report in a Audit Manager assessment.
     */
    override suspend fun associateAssessmentReportEvidenceFolder(input: AssociateAssessmentReportEvidenceFolderRequest): AssociateAssessmentReportEvidenceFolderResponse {
        val op = SdkHttpOperation.build<AssociateAssessmentReportEvidenceFolderRequest, AssociateAssessmentReportEvidenceFolderResponse> {
            serializer = AssociateAssessmentReportEvidenceFolderOperationSerializer()
            deserializer = AssociateAssessmentReportEvidenceFolderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateAssessmentReportEvidenceFolder"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates a list of evidence to an assessment report in an Audit Manager assessment.
     */
    override suspend fun batchAssociateAssessmentReportEvidence(input: BatchAssociateAssessmentReportEvidenceRequest): BatchAssociateAssessmentReportEvidenceResponse {
        val op = SdkHttpOperation.build<BatchAssociateAssessmentReportEvidenceRequest, BatchAssociateAssessmentReportEvidenceResponse> {
            serializer = BatchAssociateAssessmentReportEvidenceOperationSerializer()
            deserializer = BatchAssociateAssessmentReportEvidenceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchAssociateAssessmentReportEvidence"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a batch of delegations for an assessment in Audit Manager.
     */
    override suspend fun batchCreateDelegationByAssessment(input: BatchCreateDelegationByAssessmentRequest): BatchCreateDelegationByAssessmentResponse {
        val op = SdkHttpOperation.build<BatchCreateDelegationByAssessmentRequest, BatchCreateDelegationByAssessmentResponse> {
            serializer = BatchCreateDelegationByAssessmentOperationSerializer()
            deserializer = BatchCreateDelegationByAssessmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchCreateDelegationByAssessment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a batch of delegations for an assessment in Audit Manager.
     */
    override suspend fun batchDeleteDelegationByAssessment(input: BatchDeleteDelegationByAssessmentRequest): BatchDeleteDelegationByAssessmentResponse {
        val op = SdkHttpOperation.build<BatchDeleteDelegationByAssessmentRequest, BatchDeleteDelegationByAssessmentResponse> {
            serializer = BatchDeleteDelegationByAssessmentOperationSerializer()
            deserializer = BatchDeleteDelegationByAssessmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchDeleteDelegationByAssessment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a list of evidence from an assessment report in Audit Manager.
     */
    override suspend fun batchDisassociateAssessmentReportEvidence(input: BatchDisassociateAssessmentReportEvidenceRequest): BatchDisassociateAssessmentReportEvidenceResponse {
        val op = SdkHttpOperation.build<BatchDisassociateAssessmentReportEvidenceRequest, BatchDisassociateAssessmentReportEvidenceResponse> {
            serializer = BatchDisassociateAssessmentReportEvidenceOperationSerializer()
            deserializer = BatchDisassociateAssessmentReportEvidenceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchDisassociateAssessmentReportEvidence"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Uploads one or more pieces of evidence to a control in an Audit Manager assessment.
     */
    override suspend fun batchImportEvidenceToAssessmentControl(input: BatchImportEvidenceToAssessmentControlRequest): BatchImportEvidenceToAssessmentControlResponse {
        val op = SdkHttpOperation.build<BatchImportEvidenceToAssessmentControlRequest, BatchImportEvidenceToAssessmentControlResponse> {
            serializer = BatchImportEvidenceToAssessmentControlOperationSerializer()
            deserializer = BatchImportEvidenceToAssessmentControlOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchImportEvidenceToAssessmentControl"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an assessment in Audit Manager.
     */
    override suspend fun createAssessment(input: CreateAssessmentRequest): CreateAssessmentResponse {
        val op = SdkHttpOperation.build<CreateAssessmentRequest, CreateAssessmentResponse> {
            serializer = CreateAssessmentOperationSerializer()
            deserializer = CreateAssessmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateAssessment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a custom framework in Audit Manager.
     */
    override suspend fun createAssessmentFramework(input: CreateAssessmentFrameworkRequest): CreateAssessmentFrameworkResponse {
        val op = SdkHttpOperation.build<CreateAssessmentFrameworkRequest, CreateAssessmentFrameworkResponse> {
            serializer = CreateAssessmentFrameworkOperationSerializer()
            deserializer = CreateAssessmentFrameworkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateAssessmentFramework"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an assessment report for the specified assessment.
     */
    override suspend fun createAssessmentReport(input: CreateAssessmentReportRequest): CreateAssessmentReportResponse {
        val op = SdkHttpOperation.build<CreateAssessmentReportRequest, CreateAssessmentReportResponse> {
            serializer = CreateAssessmentReportOperationSerializer()
            deserializer = CreateAssessmentReportOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateAssessmentReport"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new custom control in Audit Manager.
     */
    override suspend fun createControl(input: CreateControlRequest): CreateControlResponse {
        val op = SdkHttpOperation.build<CreateControlRequest, CreateControlResponse> {
            serializer = CreateControlOperationSerializer()
            deserializer = CreateControlOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateControl"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an assessment in Audit Manager.
     */
    override suspend fun deleteAssessment(input: DeleteAssessmentRequest): DeleteAssessmentResponse {
        val op = SdkHttpOperation.build<DeleteAssessmentRequest, DeleteAssessmentResponse> {
            serializer = DeleteAssessmentOperationSerializer()
            deserializer = DeleteAssessmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAssessment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a custom framework in Audit Manager.
     */
    override suspend fun deleteAssessmentFramework(input: DeleteAssessmentFrameworkRequest): DeleteAssessmentFrameworkResponse {
        val op = SdkHttpOperation.build<DeleteAssessmentFrameworkRequest, DeleteAssessmentFrameworkResponse> {
            serializer = DeleteAssessmentFrameworkOperationSerializer()
            deserializer = DeleteAssessmentFrameworkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAssessmentFramework"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a share request for a custom framework in Audit Manager.
     */
    override suspend fun deleteAssessmentFrameworkShare(input: DeleteAssessmentFrameworkShareRequest): DeleteAssessmentFrameworkShareResponse {
        val op = SdkHttpOperation.build<DeleteAssessmentFrameworkShareRequest, DeleteAssessmentFrameworkShareResponse> {
            serializer = DeleteAssessmentFrameworkShareOperationSerializer()
            deserializer = DeleteAssessmentFrameworkShareOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAssessmentFrameworkShare"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an assessment report in Audit Manager.
     *
     * When you run the `DeleteAssessmentReport` operation, Audit Manager attempts to delete the following data:
     * + The specified assessment report that’s stored in your S3 bucket
     * + The associated metadata that’s stored in Audit Manager
     *
     * If Audit Manager can’t access the assessment report in your S3 bucket, the report isn’t deleted. In this event, the `DeleteAssessmentReport` operation doesn’t fail. Instead, it proceeds to delete the associated metadata only. You must then delete the assessment report from the S3 bucket yourself.
     *
     * This scenario happens when Audit Manager receives a `403 (Forbidden)` or `404 (Not Found)` error from Amazon S3. To avoid this, make sure that your S3 bucket is available, and that you configured the correct permissions for Audit Manager to delete resources in your S3 bucket. For an example permissions policy that you can use, see [Assessment report destination permissions](https://docs.aws.amazon.com/audit-manager/latest/userguide/security_iam_id-based-policy-examples.html#full-administrator-access-assessment-report-destination) in the *Audit Manager User Guide*. For information about the issues that could cause a `403 (Forbidden)` or `404 (Not Found`) error from Amazon S3, see [List of Error Codes](https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ErrorCodeList) in the *Amazon Simple Storage Service API Reference*.
     */
    override suspend fun deleteAssessmentReport(input: DeleteAssessmentReportRequest): DeleteAssessmentReportResponse {
        val op = SdkHttpOperation.build<DeleteAssessmentReportRequest, DeleteAssessmentReportResponse> {
            serializer = DeleteAssessmentReportOperationSerializer()
            deserializer = DeleteAssessmentReportOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAssessmentReport"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a custom control in Audit Manager.
     */
    override suspend fun deleteControl(input: DeleteControlRequest): DeleteControlResponse {
        val op = SdkHttpOperation.build<DeleteControlRequest, DeleteControlResponse> {
            serializer = DeleteControlOperationSerializer()
            deserializer = DeleteControlOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteControl"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deregisters an account in Audit Manager.
     *
     * When you deregister your account from Audit Manager, your data isn’t deleted. If you want to delete your resource data, you must perform that task separately before you deregister your account. Either, you can do this in the Audit Manager console. Or, you can use one of the delete API operations that are provided by Audit Manager.
     *
     * To delete your Audit Manager resource data, see the following instructions:
     * + [DeleteAssessment](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessment.html) (see also: [Deleting an assessment](https://docs.aws.amazon.com/audit-manager/latest/userguide/delete-assessment.html) in the *Audit Manager User Guide*)
     * + [DeleteAssessmentFramework](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentFramework.html) (see also: [Deleting a custom framework](https://docs.aws.amazon.com/audit-manager/latest/userguide/delete-custom-framework.html) in the *Audit Manager User Guide*)
     * + [DeleteAssessmentFrameworkShare](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentFrameworkShare.html) (see also: [Deleting a share request](https://docs.aws.amazon.com/audit-manager/latest/userguide/deleting-shared-framework-requests.html) in the *Audit Manager User Guide*)
     * + [DeleteAssessmentReport](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentReport.html) (see also: [Deleting an assessment report](https://docs.aws.amazon.com/audit-manager/latest/userguide/generate-assessment-report.html#delete-assessment-report-steps) in the *Audit Manager User Guide*)
     * + [DeleteControl](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteControl.html) (see also: [Deleting a custom control](https://docs.aws.amazon.com/audit-manager/latest/userguide/delete-controls.html) in the *Audit Manager User Guide*)
     * At this time, Audit Manager doesn't provide an option to delete evidence. All available delete operations are listed above.
     */
    override suspend fun deregisterAccount(input: DeregisterAccountRequest): DeregisterAccountResponse {
        val op = SdkHttpOperation.build<DeregisterAccountRequest, DeregisterAccountResponse> {
            serializer = DeregisterAccountOperationSerializer()
            deserializer = DeregisterAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeregisterAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified Amazon Web Services account as a delegated administrator for Audit Manager.
     *
     * When you remove a delegated administrator from your Audit Manager settings, you continue to have access to the evidence that you previously collected under that account. This is also the case when you deregister a delegated administrator from Organizations. However, Audit Manager will stop collecting and attaching evidence to that delegated administrator account moving forward.
     *
     * When you deregister a delegated administrator account for Audit Manager, the data for that account isn’t deleted. If you want to delete resource data for a delegated administrator account, you must perform that task separately before you deregister the account. Either, you can do this in the Audit Manager console. Or, you can use one of the delete API operations that are provided by Audit Manager.
     *
     * To delete your Audit Manager resource data, see the following instructions:
     * + [DeleteAssessment](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessment.html) (see also: [Deleting an assessment](https://docs.aws.amazon.com/audit-manager/latest/userguide/delete-assessment.html) in the *Audit Manager User Guide*)
     * + [DeleteAssessmentFramework](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentFramework.html) (see also: [Deleting a custom framework](https://docs.aws.amazon.com/audit-manager/latest/userguide/delete-custom-framework.html) in the *Audit Manager User Guide*)
     * + [DeleteAssessmentFrameworkShare](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentFrameworkShare.html) (see also: [Deleting a share request](https://docs.aws.amazon.com/audit-manager/latest/userguide/deleting-shared-framework-requests.html) in the *Audit Manager User Guide*)
     * + [DeleteAssessmentReport](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentReport.html) (see also: [Deleting an assessment report](https://docs.aws.amazon.com/audit-manager/latest/userguide/generate-assessment-report.html#delete-assessment-report-steps) in the *Audit Manager User Guide*)
     * + [DeleteControl](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteControl.html) (see also: [Deleting a custom control](https://docs.aws.amazon.com/audit-manager/latest/userguide/delete-controls.html) in the *Audit Manager User Guide*)
     * At this time, Audit Manager doesn't provide an option to delete evidence. All available delete operations are listed above.
     */
    override suspend fun deregisterOrganizationAdminAccount(input: DeregisterOrganizationAdminAccountRequest): DeregisterOrganizationAdminAccountResponse {
        val op = SdkHttpOperation.build<DeregisterOrganizationAdminAccountRequest, DeregisterOrganizationAdminAccountResponse> {
            serializer = DeregisterOrganizationAdminAccountOperationSerializer()
            deserializer = DeregisterOrganizationAdminAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeregisterOrganizationAdminAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates an evidence folder from the specified assessment report in Audit Manager.
     */
    override suspend fun disassociateAssessmentReportEvidenceFolder(input: DisassociateAssessmentReportEvidenceFolderRequest): DisassociateAssessmentReportEvidenceFolderResponse {
        val op = SdkHttpOperation.build<DisassociateAssessmentReportEvidenceFolderRequest, DisassociateAssessmentReportEvidenceFolderResponse> {
            serializer = DisassociateAssessmentReportEvidenceFolderOperationSerializer()
            deserializer = DisassociateAssessmentReportEvidenceFolderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateAssessmentReportEvidenceFolder"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the registration status of an account in Audit Manager.
     */
    override suspend fun getAccountStatus(input: GetAccountStatusRequest): GetAccountStatusResponse {
        val op = SdkHttpOperation.build<GetAccountStatusRequest, GetAccountStatusResponse> {
            serializer = GetAccountStatusOperationSerializer()
            deserializer = GetAccountStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAccountStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns an assessment from Audit Manager.
     */
    override suspend fun getAssessment(input: GetAssessmentRequest): GetAssessmentResponse {
        val op = SdkHttpOperation.build<GetAssessmentRequest, GetAssessmentResponse> {
            serializer = GetAssessmentOperationSerializer()
            deserializer = GetAssessmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAssessment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a framework from Audit Manager.
     */
    override suspend fun getAssessmentFramework(input: GetAssessmentFrameworkRequest): GetAssessmentFrameworkResponse {
        val op = SdkHttpOperation.build<GetAssessmentFrameworkRequest, GetAssessmentFrameworkResponse> {
            serializer = GetAssessmentFrameworkOperationSerializer()
            deserializer = GetAssessmentFrameworkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAssessmentFramework"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the URL of an assessment report in Audit Manager.
     */
    override suspend fun getAssessmentReportUrl(input: GetAssessmentReportUrlRequest): GetAssessmentReportUrlResponse {
        val op = SdkHttpOperation.build<GetAssessmentReportUrlRequest, GetAssessmentReportUrlResponse> {
            serializer = GetAssessmentReportUrlOperationSerializer()
            deserializer = GetAssessmentReportUrlOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAssessmentReportUrl"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of changelogs from Audit Manager.
     */
    override suspend fun getChangeLogs(input: GetChangeLogsRequest): GetChangeLogsResponse {
        val op = SdkHttpOperation.build<GetChangeLogsRequest, GetChangeLogsResponse> {
            serializer = GetChangeLogsOperationSerializer()
            deserializer = GetChangeLogsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetChangeLogs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a control from Audit Manager.
     */
    override suspend fun getControl(input: GetControlRequest): GetControlResponse {
        val op = SdkHttpOperation.build<GetControlRequest, GetControlResponse> {
            serializer = GetControlOperationSerializer()
            deserializer = GetControlOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetControl"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of delegations from an audit owner to a delegate.
     */
    override suspend fun getDelegations(input: GetDelegationsRequest): GetDelegationsResponse {
        val op = SdkHttpOperation.build<GetDelegationsRequest, GetDelegationsResponse> {
            serializer = GetDelegationsOperationSerializer()
            deserializer = GetDelegationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDelegations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns evidence from Audit Manager.
     */
    override suspend fun getEvidence(input: GetEvidenceRequest): GetEvidenceResponse {
        val op = SdkHttpOperation.build<GetEvidenceRequest, GetEvidenceResponse> {
            serializer = GetEvidenceOperationSerializer()
            deserializer = GetEvidenceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEvidence"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns all evidence from a specified evidence folder in Audit Manager.
     */
    override suspend fun getEvidenceByEvidenceFolder(input: GetEvidenceByEvidenceFolderRequest): GetEvidenceByEvidenceFolderResponse {
        val op = SdkHttpOperation.build<GetEvidenceByEvidenceFolderRequest, GetEvidenceByEvidenceFolderResponse> {
            serializer = GetEvidenceByEvidenceFolderOperationSerializer()
            deserializer = GetEvidenceByEvidenceFolderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEvidenceByEvidenceFolder"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns an evidence folder from the specified assessment in Audit Manager.
     */
    override suspend fun getEvidenceFolder(input: GetEvidenceFolderRequest): GetEvidenceFolderResponse {
        val op = SdkHttpOperation.build<GetEvidenceFolderRequest, GetEvidenceFolderResponse> {
            serializer = GetEvidenceFolderOperationSerializer()
            deserializer = GetEvidenceFolderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEvidenceFolder"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the evidence folders from a specified assessment in Audit Manager.
     */
    override suspend fun getEvidenceFoldersByAssessment(input: GetEvidenceFoldersByAssessmentRequest): GetEvidenceFoldersByAssessmentResponse {
        val op = SdkHttpOperation.build<GetEvidenceFoldersByAssessmentRequest, GetEvidenceFoldersByAssessmentResponse> {
            serializer = GetEvidenceFoldersByAssessmentOperationSerializer()
            deserializer = GetEvidenceFoldersByAssessmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEvidenceFoldersByAssessment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of evidence folders that are associated with a specified control of an assessment in Audit Manager.
     */
    override suspend fun getEvidenceFoldersByAssessmentControl(input: GetEvidenceFoldersByAssessmentControlRequest): GetEvidenceFoldersByAssessmentControlResponse {
        val op = SdkHttpOperation.build<GetEvidenceFoldersByAssessmentControlRequest, GetEvidenceFoldersByAssessmentControlResponse> {
            serializer = GetEvidenceFoldersByAssessmentControlOperationSerializer()
            deserializer = GetEvidenceFoldersByAssessmentControlOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetEvidenceFoldersByAssessmentControl"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the latest analytics data for all your current active assessments.
     */
    override suspend fun getInsights(input: GetInsightsRequest): GetInsightsResponse {
        val op = SdkHttpOperation.build<GetInsightsRequest, GetInsightsResponse> {
            serializer = GetInsightsOperationSerializer()
            deserializer = GetInsightsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetInsights"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the latest analytics data for a specific active assessment.
     */
    override suspend fun getInsightsByAssessment(input: GetInsightsByAssessmentRequest): GetInsightsByAssessmentResponse {
        val op = SdkHttpOperation.build<GetInsightsByAssessmentRequest, GetInsightsByAssessmentResponse> {
            serializer = GetInsightsByAssessmentOperationSerializer()
            deserializer = GetInsightsByAssessmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetInsightsByAssessment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the name of the delegated Amazon Web Services administrator account for the organization.
     */
    override suspend fun getOrganizationAdminAccount(input: GetOrganizationAdminAccountRequest): GetOrganizationAdminAccountResponse {
        val op = SdkHttpOperation.build<GetOrganizationAdminAccountRequest, GetOrganizationAdminAccountResponse> {
            serializer = GetOrganizationAdminAccountOperationSerializer()
            deserializer = GetOrganizationAdminAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetOrganizationAdminAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of the in-scope Amazon Web Services for the specified assessment.
     */
    override suspend fun getServicesInScope(input: GetServicesInScopeRequest): GetServicesInScopeResponse {
        val op = SdkHttpOperation.build<GetServicesInScopeRequest, GetServicesInScopeResponse> {
            serializer = GetServicesInScopeOperationSerializer()
            deserializer = GetServicesInScopeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetServicesInScope"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the settings for the specified Amazon Web Services account.
     */
    override suspend fun getSettings(input: GetSettingsRequest): GetSettingsResponse {
        val op = SdkHttpOperation.build<GetSettingsRequest, GetSettingsResponse> {
            serializer = GetSettingsOperationSerializer()
            deserializer = GetSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the latest analytics data for controls within a specific control domain and a specific active assessment.
     *
     * Control insights are listed only if the control belongs to the control domain and assessment that was specified. Moreover, the control must have collected evidence on the `lastUpdated` date of `controlInsightsByAssessment`. If neither of these conditions are met, no data is listed for that control.
     */
    override suspend fun listAssessmentControlInsightsByControlDomain(input: ListAssessmentControlInsightsByControlDomainRequest): ListAssessmentControlInsightsByControlDomainResponse {
        val op = SdkHttpOperation.build<ListAssessmentControlInsightsByControlDomainRequest, ListAssessmentControlInsightsByControlDomainResponse> {
            serializer = ListAssessmentControlInsightsByControlDomainOperationSerializer()
            deserializer = ListAssessmentControlInsightsByControlDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAssessmentControlInsightsByControlDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of sent or received share requests for custom frameworks in Audit Manager.
     */
    override suspend fun listAssessmentFrameworkShareRequests(input: ListAssessmentFrameworkShareRequestsRequest): ListAssessmentFrameworkShareRequestsResponse {
        val op = SdkHttpOperation.build<ListAssessmentFrameworkShareRequestsRequest, ListAssessmentFrameworkShareRequestsResponse> {
            serializer = ListAssessmentFrameworkShareRequestsOperationSerializer()
            deserializer = ListAssessmentFrameworkShareRequestsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAssessmentFrameworkShareRequests"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of the frameworks that are available in the Audit Manager framework library.
     */
    override suspend fun listAssessmentFrameworks(input: ListAssessmentFrameworksRequest): ListAssessmentFrameworksResponse {
        val op = SdkHttpOperation.build<ListAssessmentFrameworksRequest, ListAssessmentFrameworksResponse> {
            serializer = ListAssessmentFrameworksOperationSerializer()
            deserializer = ListAssessmentFrameworksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAssessmentFrameworks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of assessment reports created in Audit Manager.
     */
    override suspend fun listAssessmentReports(input: ListAssessmentReportsRequest): ListAssessmentReportsResponse {
        val op = SdkHttpOperation.build<ListAssessmentReportsRequest, ListAssessmentReportsResponse> {
            serializer = ListAssessmentReportsOperationSerializer()
            deserializer = ListAssessmentReportsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAssessmentReports"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of current and past assessments from Audit Manager.
     */
    override suspend fun listAssessments(input: ListAssessmentsRequest): ListAssessmentsResponse {
        val op = SdkHttpOperation.build<ListAssessmentsRequest, ListAssessmentsResponse> {
            serializer = ListAssessmentsOperationSerializer()
            deserializer = ListAssessmentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAssessments"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the latest analytics data for control domains across all of your active assessments.
     *
     * A control domain is listed only if at least one of the controls within that domain collected evidence on the `lastUpdated` date of `controlDomainInsights`. If this condition isn’t met, no data is listed for that control domain.
     */
    override suspend fun listControlDomainInsights(input: ListControlDomainInsightsRequest): ListControlDomainInsightsResponse {
        val op = SdkHttpOperation.build<ListControlDomainInsightsRequest, ListControlDomainInsightsResponse> {
            serializer = ListControlDomainInsightsOperationSerializer()
            deserializer = ListControlDomainInsightsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListControlDomainInsights"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists analytics data for control domains within a specified active assessment.
     *
     * A control domain is listed only if at least one of the controls within that domain collected evidence on the `lastUpdated` date of `controlDomainInsights`. If this condition isn’t met, no data is listed for that domain.
     */
    override suspend fun listControlDomainInsightsByAssessment(input: ListControlDomainInsightsByAssessmentRequest): ListControlDomainInsightsByAssessmentResponse {
        val op = SdkHttpOperation.build<ListControlDomainInsightsByAssessmentRequest, ListControlDomainInsightsByAssessmentResponse> {
            serializer = ListControlDomainInsightsByAssessmentOperationSerializer()
            deserializer = ListControlDomainInsightsByAssessmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListControlDomainInsightsByAssessment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the latest analytics data for controls within a specific control domain across all active assessments.
     *
     * Control insights are listed only if the control belongs to the control domain that was specified and the control collected evidence on the `lastUpdated` date of `controlInsightsMetadata`. If neither of these conditions are met, no data is listed for that control.
     */
    override suspend fun listControlInsightsByControlDomain(input: ListControlInsightsByControlDomainRequest): ListControlInsightsByControlDomainResponse {
        val op = SdkHttpOperation.build<ListControlInsightsByControlDomainRequest, ListControlInsightsByControlDomainResponse> {
            serializer = ListControlInsightsByControlDomainOperationSerializer()
            deserializer = ListControlInsightsByControlDomainOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListControlInsightsByControlDomain"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of controls from Audit Manager.
     */
    override suspend fun listControls(input: ListControlsRequest): ListControlsResponse {
        val op = SdkHttpOperation.build<ListControlsRequest, ListControlsResponse> {
            serializer = ListControlsOperationSerializer()
            deserializer = ListControlsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListControls"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of keywords that are pre-mapped to the specified control data source.
     */
    override suspend fun listKeywordsForDataSource(input: ListKeywordsForDataSourceRequest): ListKeywordsForDataSourceResponse {
        val op = SdkHttpOperation.build<ListKeywordsForDataSourceRequest, ListKeywordsForDataSourceResponse> {
            serializer = ListKeywordsForDataSourceOperationSerializer()
            deserializer = ListKeywordsForDataSourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListKeywordsForDataSource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of all Audit Manager notifications.
     */
    override suspend fun listNotifications(input: ListNotificationsRequest): ListNotificationsResponse {
        val op = SdkHttpOperation.build<ListNotificationsRequest, ListNotificationsResponse> {
            serializer = ListNotificationsOperationSerializer()
            deserializer = ListNotificationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListNotifications"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of tags for the specified resource in Audit Manager.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enables Audit Manager for the specified Amazon Web Services account.
     */
    override suspend fun registerAccount(input: RegisterAccountRequest): RegisterAccountResponse {
        val op = SdkHttpOperation.build<RegisterAccountRequest, RegisterAccountResponse> {
            serializer = RegisterAccountOperationSerializer()
            deserializer = RegisterAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegisterAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enables an Amazon Web Services account within the organization as the delegated administrator for Audit Manager.
     */
    override suspend fun registerOrganizationAdminAccount(input: RegisterOrganizationAdminAccountRequest): RegisterOrganizationAdminAccountResponse {
        val op = SdkHttpOperation.build<RegisterOrganizationAdminAccountRequest, RegisterOrganizationAdminAccountResponse> {
            serializer = RegisterOrganizationAdminAccountOperationSerializer()
            deserializer = RegisterOrganizationAdminAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegisterOrganizationAdminAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a share request for a custom framework in Audit Manager.
     *
     * The share request specifies a recipient and notifies them that a custom framework is available. Recipients have 120 days to accept or decline the request. If no action is taken, the share request expires.
     *
     * When you create a share request, Audit Manager stores a snapshot of your custom framework in the US East (N. Virginia) Amazon Web Services Region. Audit Manager also stores a backup of the same snapshot in the US West (Oregon) Amazon Web Services Region.
     *
     * Audit Manager deletes the snapshot and the backup snapshot when one of the following events occurs:
     * + The sender revokes the share request.
     * + The recipient declines the share request.
     * + The recipient encounters an error and doesn't successfully accept the share request.
     * + The share request expires before the recipient responds to the request.
     *
     * When a sender [resends a share request](https://docs.aws.amazon.com/audit-manager/latest/userguide/framework-sharing.html#framework-sharing-resend), the snapshot is replaced with an updated version that corresponds with the latest version of the custom framework.
     *
     * When a recipient accepts a share request, the snapshot is replicated into their Amazon Web Services account under the Amazon Web Services Region that was specified in the share request.
     *
     * When you invoke the `StartAssessmentFrameworkShare` API, you are about to share a custom framework with another Amazon Web Services account. You may not share a custom framework that is derived from a standard framework if the standard framework is designated as not eligible for sharing by Amazon Web Services, unless you have obtained permission to do so from the owner of the standard framework. To learn more about which standard frameworks are eligible for sharing, see [Framework sharing eligibility](https://docs.aws.amazon.com/audit-manager/latest/userguide/share-custom-framework-concepts-and-terminology.html#eligibility) in the *Audit Manager User Guide*.
     */
    override suspend fun startAssessmentFrameworkShare(input: StartAssessmentFrameworkShareRequest): StartAssessmentFrameworkShareResponse {
        val op = SdkHttpOperation.build<StartAssessmentFrameworkShareRequest, StartAssessmentFrameworkShareResponse> {
            serializer = StartAssessmentFrameworkShareOperationSerializer()
            deserializer = StartAssessmentFrameworkShareOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartAssessmentFrameworkShare"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Tags the specified resource in Audit Manager.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes a tag from a resource in Audit Manager.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Edits an Audit Manager assessment.
     */
    override suspend fun updateAssessment(input: UpdateAssessmentRequest): UpdateAssessmentResponse {
        val op = SdkHttpOperation.build<UpdateAssessmentRequest, UpdateAssessmentResponse> {
            serializer = UpdateAssessmentOperationSerializer()
            deserializer = UpdateAssessmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAssessment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a control within an assessment in Audit Manager.
     */
    override suspend fun updateAssessmentControl(input: UpdateAssessmentControlRequest): UpdateAssessmentControlResponse {
        val op = SdkHttpOperation.build<UpdateAssessmentControlRequest, UpdateAssessmentControlResponse> {
            serializer = UpdateAssessmentControlOperationSerializer()
            deserializer = UpdateAssessmentControlOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAssessmentControl"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the status of a control set in an Audit Manager assessment.
     */
    override suspend fun updateAssessmentControlSetStatus(input: UpdateAssessmentControlSetStatusRequest): UpdateAssessmentControlSetStatusResponse {
        val op = SdkHttpOperation.build<UpdateAssessmentControlSetStatusRequest, UpdateAssessmentControlSetStatusResponse> {
            serializer = UpdateAssessmentControlSetStatusOperationSerializer()
            deserializer = UpdateAssessmentControlSetStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAssessmentControlSetStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a custom framework in Audit Manager.
     */
    override suspend fun updateAssessmentFramework(input: UpdateAssessmentFrameworkRequest): UpdateAssessmentFrameworkResponse {
        val op = SdkHttpOperation.build<UpdateAssessmentFrameworkRequest, UpdateAssessmentFrameworkResponse> {
            serializer = UpdateAssessmentFrameworkOperationSerializer()
            deserializer = UpdateAssessmentFrameworkOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAssessmentFramework"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a share request for a custom framework in Audit Manager.
     */
    override suspend fun updateAssessmentFrameworkShare(input: UpdateAssessmentFrameworkShareRequest): UpdateAssessmentFrameworkShareResponse {
        val op = SdkHttpOperation.build<UpdateAssessmentFrameworkShareRequest, UpdateAssessmentFrameworkShareResponse> {
            serializer = UpdateAssessmentFrameworkShareOperationSerializer()
            deserializer = UpdateAssessmentFrameworkShareOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAssessmentFrameworkShare"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the status of an assessment in Audit Manager.
     */
    override suspend fun updateAssessmentStatus(input: UpdateAssessmentStatusRequest): UpdateAssessmentStatusResponse {
        val op = SdkHttpOperation.build<UpdateAssessmentStatusRequest, UpdateAssessmentStatusResponse> {
            serializer = UpdateAssessmentStatusOperationSerializer()
            deserializer = UpdateAssessmentStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAssessmentStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a custom control in Audit Manager.
     */
    override suspend fun updateControl(input: UpdateControlRequest): UpdateControlResponse {
        val op = SdkHttpOperation.build<UpdateControlRequest, UpdateControlResponse> {
            serializer = UpdateControlOperationSerializer()
            deserializer = UpdateControlOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateControl"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates Audit Manager settings for the current user account.
     */
    override suspend fun updateSettings(input: UpdateSettingsRequest): UpdateSettingsResponse {
        val op = SdkHttpOperation.build<UpdateSettingsRequest, UpdateSettingsResponse> {
            serializer = UpdateSettingsOperationSerializer()
            deserializer = UpdateSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Validates the integrity of an assessment report in Audit Manager.
     */
    override suspend fun validateAssessmentReportIntegrity(input: ValidateAssessmentReportIntegrityRequest): ValidateAssessmentReportIntegrityResponse {
        val op = SdkHttpOperation.build<ValidateAssessmentReportIntegrityRequest, ValidateAssessmentReportIntegrityResponse> {
            serializer = ValidateAssessmentReportIntegrityOperationSerializer()
            deserializer = ValidateAssessmentReportIntegrityOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ValidateAssessmentReportIntegrity"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "auditmanager"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "auditmanager")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
