// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model



/**
 * An entity that defines the scope of audit evidence collected by Audit Manager. An Audit Manager assessment is an implementation of an Audit Manager framework.
 */
class Assessment private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the assessment.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The Amazon Web Services account that's associated with the assessment.
     */
    val awsAccount: aws.sdk.kotlin.services.auditmanager.model.AwsAccount? = builder.awsAccount
    /**
     * The framework that the assessment was created from.
     */
    val framework: aws.sdk.kotlin.services.auditmanager.model.AssessmentFramework? = builder.framework
    /**
     * The metadata for the assessment.
     */
    val metadata: aws.sdk.kotlin.services.auditmanager.model.AssessmentMetadata? = builder.metadata
    /**
     * The tags that are associated with the assessment.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.auditmanager.model.Assessment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Assessment(")
        append("arn=$arn,")
        append("awsAccount=$awsAccount,")
        append("framework=$framework,")
        append("metadata=$metadata,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (awsAccount?.hashCode() ?: 0)
        result = 31 * result + (framework?.hashCode() ?: 0)
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Assessment

        if (arn != other.arn) return false
        if (awsAccount != other.awsAccount) return false
        if (framework != other.framework) return false
        if (metadata != other.metadata) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.auditmanager.model.Assessment = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the assessment.
         */
        var arn: kotlin.String? = null
        /**
         * The Amazon Web Services account that's associated with the assessment.
         */
        var awsAccount: aws.sdk.kotlin.services.auditmanager.model.AwsAccount? = null
        /**
         * The framework that the assessment was created from.
         */
        var framework: aws.sdk.kotlin.services.auditmanager.model.AssessmentFramework? = null
        /**
         * The metadata for the assessment.
         */
        var metadata: aws.sdk.kotlin.services.auditmanager.model.AssessmentMetadata? = null
        /**
         * The tags that are associated with the assessment.
         */
        var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.auditmanager.model.Assessment) : this() {
            this.arn = x.arn
            this.awsAccount = x.awsAccount
            this.framework = x.framework
            this.metadata = x.metadata
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.auditmanager.model.Assessment = Assessment(this)

        /**
         * construct an [aws.sdk.kotlin.services.auditmanager.model.AwsAccount] inside the given [block]
         */
        fun awsAccount(block: aws.sdk.kotlin.services.auditmanager.model.AwsAccount.Builder.() -> kotlin.Unit) {
            this.awsAccount = aws.sdk.kotlin.services.auditmanager.model.AwsAccount.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.auditmanager.model.AssessmentFramework] inside the given [block]
         */
        fun framework(block: aws.sdk.kotlin.services.auditmanager.model.AssessmentFramework.Builder.() -> kotlin.Unit) {
            this.framework = aws.sdk.kotlin.services.auditmanager.model.AssessmentFramework.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.auditmanager.model.AssessmentMetadata] inside the given [block]
         */
        fun metadata(block: aws.sdk.kotlin.services.auditmanager.model.AssessmentMetadata.Builder.() -> kotlin.Unit) {
            this.metadata = aws.sdk.kotlin.services.auditmanager.model.AssessmentMetadata.invoke(block)
        }
    }
}
