// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model



/**
 * Represents a set of controls in an Audit Manager assessment.
 */
class AssessmentControlSet private constructor(builder: Builder) {
    /**
     * The list of controls that's contained with the control set.
     */
    val controls: List<AssessmentControl>? = builder.controls
    /**
     * The delegations that are associated with the control set.
     */
    val delegations: List<Delegation>? = builder.delegations
    /**
     * The description for the control set.
     */
    val description: kotlin.String? = builder.description
    /**
     * The identifier of the control set in the assessment. This is the control set name in a plain string format.
     */
    val id: kotlin.String? = builder.id
    /**
     * The total number of evidence objects that are uploaded manually to the control set.
     */
    val manualEvidenceCount: kotlin.Int = builder.manualEvidenceCount
    /**
     * The roles that are associated with the control set.
     */
    val roles: List<Role>? = builder.roles
    /**
     * Specifies the current status of the control set.
     */
    val status: aws.sdk.kotlin.services.auditmanager.model.ControlSetStatus? = builder.status
    /**
     * The total number of evidence objects that are retrieved automatically for the control set.
     */
    val systemEvidenceCount: kotlin.Int = builder.systemEvidenceCount

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.auditmanager.model.AssessmentControlSet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssessmentControlSet(")
        append("controls=$controls,")
        append("delegations=$delegations,")
        append("description=$description,")
        append("id=$id,")
        append("manualEvidenceCount=$manualEvidenceCount,")
        append("roles=$roles,")
        append("status=$status,")
        append("systemEvidenceCount=$systemEvidenceCount)")
    }

    override fun hashCode(): kotlin.Int {
        var result = controls?.hashCode() ?: 0
        result = 31 * result + (delegations?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (manualEvidenceCount)
        result = 31 * result + (roles?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (systemEvidenceCount)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssessmentControlSet

        if (controls != other.controls) return false
        if (delegations != other.delegations) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (manualEvidenceCount != other.manualEvidenceCount) return false
        if (roles != other.roles) return false
        if (status != other.status) return false
        if (systemEvidenceCount != other.systemEvidenceCount) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.auditmanager.model.AssessmentControlSet = Builder(this).apply(block).build()

    class Builder {
        /**
         * The list of controls that's contained with the control set.
         */
        var controls: List<AssessmentControl>? = null
        /**
         * The delegations that are associated with the control set.
         */
        var delegations: List<Delegation>? = null
        /**
         * The description for the control set.
         */
        var description: kotlin.String? = null
        /**
         * The identifier of the control set in the assessment. This is the control set name in a plain string format.
         */
        var id: kotlin.String? = null
        /**
         * The total number of evidence objects that are uploaded manually to the control set.
         */
        var manualEvidenceCount: kotlin.Int = 0
        /**
         * The roles that are associated with the control set.
         */
        var roles: List<Role>? = null
        /**
         * Specifies the current status of the control set.
         */
        var status: aws.sdk.kotlin.services.auditmanager.model.ControlSetStatus? = null
        /**
         * The total number of evidence objects that are retrieved automatically for the control set.
         */
        var systemEvidenceCount: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.auditmanager.model.AssessmentControlSet) : this() {
            this.controls = x.controls
            this.delegations = x.delegations
            this.description = x.description
            this.id = x.id
            this.manualEvidenceCount = x.manualEvidenceCount
            this.roles = x.roles
            this.status = x.status
            this.systemEvidenceCount = x.systemEvidenceCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.auditmanager.model.AssessmentControlSet = AssessmentControlSet(this)
    }
}
