// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The record of a change within Audit Manager. For example, this could be the status change of an assessment or the delegation of a control set.
 */
class ChangeLog private constructor(builder: Builder) {
    /**
     * The action that was performed.
     */
    val action: aws.sdk.kotlin.services.auditmanager.model.ActionEnum? = builder.action
    /**
     * The time when the action was performed and the changelog record was created.
     */
    val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The IAM user or role that performed the action.
     */
    val createdBy: kotlin.String? = builder.createdBy
    /**
     * The name of the object that changed. This could be the name of an assessment, control, or control set.
     */
    val objectName: kotlin.String? = builder.objectName
    /**
     * The object that was changed, such as an assessment, control, or control set.
     */
    val objectType: aws.sdk.kotlin.services.auditmanager.model.ObjectTypeEnum? = builder.objectType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.auditmanager.model.ChangeLog = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ChangeLog(")
        append("action=$action,")
        append("createdAt=$createdAt,")
        append("createdBy=$createdBy,")
        append("objectName=$objectName,")
        append("objectType=$objectType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (objectName?.hashCode() ?: 0)
        result = 31 * result + (objectType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ChangeLog

        if (action != other.action) return false
        if (createdAt != other.createdAt) return false
        if (createdBy != other.createdBy) return false
        if (objectName != other.objectName) return false
        if (objectType != other.objectType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.auditmanager.model.ChangeLog = Builder(this).apply(block).build()

    class Builder {
        /**
         * The action that was performed.
         */
        var action: aws.sdk.kotlin.services.auditmanager.model.ActionEnum? = null
        /**
         * The time when the action was performed and the changelog record was created.
         */
        var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The IAM user or role that performed the action.
         */
        var createdBy: kotlin.String? = null
        /**
         * The name of the object that changed. This could be the name of an assessment, control, or control set.
         */
        var objectName: kotlin.String? = null
        /**
         * The object that was changed, such as an assessment, control, or control set.
         */
        var objectType: aws.sdk.kotlin.services.auditmanager.model.ObjectTypeEnum? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.auditmanager.model.ChangeLog) : this() {
            this.action = x.action
            this.createdAt = x.createdAt
            this.createdBy = x.createdBy
            this.objectName = x.objectName
            this.objectType = x.objectType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.auditmanager.model.ChangeLog = ChangeLog(this)
    }
}
