// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A summary of the latest analytics data for a specific control.
 *
 * This data reflects the total counts for the specified control across all active assessments. Control insights are grouped by control domain, and ranked by the highest total count of non-compliant evidence.
 */
class ControlInsightsMetadataItem private constructor(builder: Builder) {
    /**
     * A breakdown of the compliance check status for the evidence that’s associated with the control.
     */
    val evidenceInsights: aws.sdk.kotlin.services.auditmanager.model.EvidenceInsights? = builder.evidenceInsights
    /**
     * The unique identifier for the control.
     */
    val id: kotlin.String? = builder.id
    /**
     * The time when the control insights were last updated.
     */
    val lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdated
    /**
     * The name of the control.
     */
    val name: kotlin.String? = builder.name

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.auditmanager.model.ControlInsightsMetadataItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ControlInsightsMetadataItem(")
        append("evidenceInsights=$evidenceInsights,")
        append("id=$id,")
        append("lastUpdated=$lastUpdated,")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = evidenceInsights?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastUpdated?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ControlInsightsMetadataItem

        if (evidenceInsights != other.evidenceInsights) return false
        if (id != other.id) return false
        if (lastUpdated != other.lastUpdated) return false
        if (name != other.name) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.auditmanager.model.ControlInsightsMetadataItem = Builder(this).apply(block).build()

    class Builder {
        /**
         * A breakdown of the compliance check status for the evidence that’s associated with the control.
         */
        var evidenceInsights: aws.sdk.kotlin.services.auditmanager.model.EvidenceInsights? = null
        /**
         * The unique identifier for the control.
         */
        var id: kotlin.String? = null
        /**
         * The time when the control insights were last updated.
         */
        var lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the control.
         */
        var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.auditmanager.model.ControlInsightsMetadataItem) : this() {
            this.evidenceInsights = x.evidenceInsights
            this.id = x.id
            this.lastUpdated = x.lastUpdated
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.auditmanager.model.ControlInsightsMetadataItem = ControlInsightsMetadataItem(this)

        /**
         * construct an [aws.sdk.kotlin.services.auditmanager.model.EvidenceInsights] inside the given [block]
         */
        fun evidenceInsights(block: aws.sdk.kotlin.services.auditmanager.model.EvidenceInsights.Builder.() -> kotlin.Unit) {
            this.evidenceInsights = aws.sdk.kotlin.services.auditmanager.model.EvidenceInsights.invoke(block)
        }
    }
}
