// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model



/**
 * The data source that determines where Audit Manager collects evidence from for the control.
 */
class ControlMappingSource private constructor(builder: Builder) {
    /**
     * The description of the source.
     */
    val sourceDescription: kotlin.String? = builder.sourceDescription
    /**
     * The frequency of evidence collection for the control mapping source.
     */
    val sourceFrequency: aws.sdk.kotlin.services.auditmanager.model.SourceFrequency? = builder.sourceFrequency
    /**
     * The unique identifier for the source.
     */
    val sourceId: kotlin.String? = builder.sourceId
    /**
     * The keyword to search for in CloudTrail logs, Config rules, Security Hub checks, and Amazon Web Services API names.
     */
    val sourceKeyword: aws.sdk.kotlin.services.auditmanager.model.SourceKeyword? = builder.sourceKeyword
    /**
     * The name of the source.
     */
    val sourceName: kotlin.String? = builder.sourceName
    /**
     * The setup option for the data source. This option reflects if the evidence collection is automated or manual.
     */
    val sourceSetUpOption: aws.sdk.kotlin.services.auditmanager.model.SourceSetUpOption? = builder.sourceSetUpOption
    /**
     * Specifies one of the five types of data sources for evidence collection.
     */
    val sourceType: aws.sdk.kotlin.services.auditmanager.model.SourceType? = builder.sourceType
    /**
     * The instructions for troubleshooting the control.
     */
    val troubleshootingText: kotlin.String? = builder.troubleshootingText

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.auditmanager.model.ControlMappingSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ControlMappingSource(")
        append("sourceDescription=$sourceDescription,")
        append("sourceFrequency=$sourceFrequency,")
        append("sourceId=$sourceId,")
        append("sourceKeyword=$sourceKeyword,")
        append("sourceName=$sourceName,")
        append("sourceSetUpOption=$sourceSetUpOption,")
        append("sourceType=$sourceType,")
        append("troubleshootingText=$troubleshootingText)")
    }

    override fun hashCode(): kotlin.Int {
        var result = sourceDescription?.hashCode() ?: 0
        result = 31 * result + (sourceFrequency?.hashCode() ?: 0)
        result = 31 * result + (sourceId?.hashCode() ?: 0)
        result = 31 * result + (sourceKeyword?.hashCode() ?: 0)
        result = 31 * result + (sourceName?.hashCode() ?: 0)
        result = 31 * result + (sourceSetUpOption?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        result = 31 * result + (troubleshootingText?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ControlMappingSource

        if (sourceDescription != other.sourceDescription) return false
        if (sourceFrequency != other.sourceFrequency) return false
        if (sourceId != other.sourceId) return false
        if (sourceKeyword != other.sourceKeyword) return false
        if (sourceName != other.sourceName) return false
        if (sourceSetUpOption != other.sourceSetUpOption) return false
        if (sourceType != other.sourceType) return false
        if (troubleshootingText != other.troubleshootingText) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.auditmanager.model.ControlMappingSource = Builder(this).apply(block).build()

    class Builder {
        /**
         * The description of the source.
         */
        var sourceDescription: kotlin.String? = null
        /**
         * The frequency of evidence collection for the control mapping source.
         */
        var sourceFrequency: aws.sdk.kotlin.services.auditmanager.model.SourceFrequency? = null
        /**
         * The unique identifier for the source.
         */
        var sourceId: kotlin.String? = null
        /**
         * The keyword to search for in CloudTrail logs, Config rules, Security Hub checks, and Amazon Web Services API names.
         */
        var sourceKeyword: aws.sdk.kotlin.services.auditmanager.model.SourceKeyword? = null
        /**
         * The name of the source.
         */
        var sourceName: kotlin.String? = null
        /**
         * The setup option for the data source. This option reflects if the evidence collection is automated or manual.
         */
        var sourceSetUpOption: aws.sdk.kotlin.services.auditmanager.model.SourceSetUpOption? = null
        /**
         * Specifies one of the five types of data sources for evidence collection.
         */
        var sourceType: aws.sdk.kotlin.services.auditmanager.model.SourceType? = null
        /**
         * The instructions for troubleshooting the control.
         */
        var troubleshootingText: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.auditmanager.model.ControlMappingSource) : this() {
            this.sourceDescription = x.sourceDescription
            this.sourceFrequency = x.sourceFrequency
            this.sourceId = x.sourceId
            this.sourceKeyword = x.sourceKeyword
            this.sourceName = x.sourceName
            this.sourceSetUpOption = x.sourceSetUpOption
            this.sourceType = x.sourceType
            this.troubleshootingText = x.troubleshootingText
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.auditmanager.model.ControlMappingSource = ControlMappingSource(this)

        /**
         * construct an [aws.sdk.kotlin.services.auditmanager.model.SourceKeyword] inside the given [block]
         */
        fun sourceKeyword(block: aws.sdk.kotlin.services.auditmanager.model.SourceKeyword.Builder.() -> kotlin.Unit) {
            this.sourceKeyword = aws.sdk.kotlin.services.auditmanager.model.SourceKeyword.invoke(block)
        }
    }
}
