// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model



/**
 * The control mapping fields that represent the source for evidence collection, along with related parameters and metadata. This doesn't contain `mappingID`.
 */
class CreateControlMappingSource private constructor(builder: Builder) {
    /**
     * The description of the data source that determines where Audit Manager collects evidence from for the control.
     */
    val sourceDescription: kotlin.String? = builder.sourceDescription
    /**
     * The frequency of evidence collection for the control mapping source.
     */
    val sourceFrequency: aws.sdk.kotlin.services.auditmanager.model.SourceFrequency? = builder.sourceFrequency
    /**
     * The keyword to search for in CloudTrail logs, Config rules, Security Hub checks, and Amazon Web Services API names.
     */
    val sourceKeyword: aws.sdk.kotlin.services.auditmanager.model.SourceKeyword? = builder.sourceKeyword
    /**
     * The name of the control mapping data source.
     */
    val sourceName: kotlin.String? = builder.sourceName
    /**
     * The setup option for the data source, which reflects if the evidence collection is automated or manual.
     */
    val sourceSetUpOption: aws.sdk.kotlin.services.auditmanager.model.SourceSetUpOption? = builder.sourceSetUpOption
    /**
     * Specifies one of the five types of data sources for evidence collection.
     */
    val sourceType: aws.sdk.kotlin.services.auditmanager.model.SourceType? = builder.sourceType
    /**
     * The instructions for troubleshooting the control.
     */
    val troubleshootingText: kotlin.String? = builder.troubleshootingText

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.auditmanager.model.CreateControlMappingSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateControlMappingSource(")
        append("sourceDescription=$sourceDescription,")
        append("sourceFrequency=$sourceFrequency,")
        append("sourceKeyword=$sourceKeyword,")
        append("sourceName=$sourceName,")
        append("sourceSetUpOption=$sourceSetUpOption,")
        append("sourceType=$sourceType,")
        append("troubleshootingText=$troubleshootingText)")
    }

    override fun hashCode(): kotlin.Int {
        var result = sourceDescription?.hashCode() ?: 0
        result = 31 * result + (sourceFrequency?.hashCode() ?: 0)
        result = 31 * result + (sourceKeyword?.hashCode() ?: 0)
        result = 31 * result + (sourceName?.hashCode() ?: 0)
        result = 31 * result + (sourceSetUpOption?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        result = 31 * result + (troubleshootingText?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateControlMappingSource

        if (sourceDescription != other.sourceDescription) return false
        if (sourceFrequency != other.sourceFrequency) return false
        if (sourceKeyword != other.sourceKeyword) return false
        if (sourceName != other.sourceName) return false
        if (sourceSetUpOption != other.sourceSetUpOption) return false
        if (sourceType != other.sourceType) return false
        if (troubleshootingText != other.troubleshootingText) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.auditmanager.model.CreateControlMappingSource = Builder(this).apply(block).build()

    class Builder {
        /**
         * The description of the data source that determines where Audit Manager collects evidence from for the control.
         */
        var sourceDescription: kotlin.String? = null
        /**
         * The frequency of evidence collection for the control mapping source.
         */
        var sourceFrequency: aws.sdk.kotlin.services.auditmanager.model.SourceFrequency? = null
        /**
         * The keyword to search for in CloudTrail logs, Config rules, Security Hub checks, and Amazon Web Services API names.
         */
        var sourceKeyword: aws.sdk.kotlin.services.auditmanager.model.SourceKeyword? = null
        /**
         * The name of the control mapping data source.
         */
        var sourceName: kotlin.String? = null
        /**
         * The setup option for the data source, which reflects if the evidence collection is automated or manual.
         */
        var sourceSetUpOption: aws.sdk.kotlin.services.auditmanager.model.SourceSetUpOption? = null
        /**
         * Specifies one of the five types of data sources for evidence collection.
         */
        var sourceType: aws.sdk.kotlin.services.auditmanager.model.SourceType? = null
        /**
         * The instructions for troubleshooting the control.
         */
        var troubleshootingText: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.auditmanager.model.CreateControlMappingSource) : this() {
            this.sourceDescription = x.sourceDescription
            this.sourceFrequency = x.sourceFrequency
            this.sourceKeyword = x.sourceKeyword
            this.sourceName = x.sourceName
            this.sourceSetUpOption = x.sourceSetUpOption
            this.sourceType = x.sourceType
            this.troubleshootingText = x.troubleshootingText
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.auditmanager.model.CreateControlMappingSource = CreateControlMappingSource(this)

        /**
         * construct an [aws.sdk.kotlin.services.auditmanager.model.SourceKeyword] inside the given [block]
         */
        fun sourceKeyword(block: aws.sdk.kotlin.services.auditmanager.model.SourceKeyword.Builder.() -> kotlin.Unit) {
            this.sourceKeyword = aws.sdk.kotlin.services.auditmanager.model.SourceKeyword.invoke(block)
        }
    }
}
