// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A record that contains the information needed to demonstrate compliance with the requirements specified by a control. Examples of evidence include change activity triggered by a user, or a system configuration snapshot.
 */
class Evidence private constructor(builder: Builder) {
    /**
     * Specifies whether the evidence is included in the assessment report.
     */
    val assessmentReportSelection: kotlin.String? = builder.assessmentReportSelection
    /**
     * The names and values that are used by the evidence event. This includes an attribute name (such as `allowUsersToChangePassword`) and value (such as `true` or `false`).
     */
    val attributes: Map<String, String>? = builder.attributes
    /**
     * The identifier for the Amazon Web Services account.
     */
    val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * The Amazon Web Services account that the evidence is collected from, and its organization path.
     */
    val awsOrganization: kotlin.String? = builder.awsOrganization
    /**
     * The evaluation status for evidence that falls under the compliance check category. For evidence collected from Security Hub, a *Pass* or *Fail* result is shown. For evidence collected from Config, a *Compliant* or *Noncompliant* result is shown.
     */
    val complianceCheck: kotlin.String? = builder.complianceCheck
    /**
     * The data source where the evidence was collected from.
     */
    val dataSource: kotlin.String? = builder.dataSource
    /**
     * The name of the evidence event.
     */
    val eventName: kotlin.String? = builder.eventName
    /**
     * The Amazon Web Service that the evidence is collected from.
     */
    val eventSource: kotlin.String? = builder.eventSource
    /**
     * The identifier for the Amazon Web Services account.
     */
    val evidenceAwsAccountId: kotlin.String? = builder.evidenceAwsAccountId
    /**
     * The type of automated evidence.
     */
    val evidenceByType: kotlin.String? = builder.evidenceByType
    /**
     * The identifier for the folder that the evidence is stored in.
     */
    val evidenceFolderId: kotlin.String? = builder.evidenceFolderId
    /**
     * The unique identifier for the IAM user or role that's associated with the evidence.
     */
    val iamId: kotlin.String? = builder.iamId
    /**
     * The identifier for the evidence.
     */
    val id: kotlin.String? = builder.id
    /**
     * The list of resources that are assessed to generate the evidence.
     */
    val resourcesIncluded: List<Resource>? = builder.resourcesIncluded
    /**
     * The timestamp that represents when the evidence was collected.
     */
    val time: aws.smithy.kotlin.runtime.time.Instant? = builder.time

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.auditmanager.model.Evidence = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Evidence(")
        append("assessmentReportSelection=$assessmentReportSelection,")
        append("attributes=$attributes,")
        append("awsAccountId=$awsAccountId,")
        append("awsOrganization=$awsOrganization,")
        append("complianceCheck=$complianceCheck,")
        append("dataSource=$dataSource,")
        append("eventName=$eventName,")
        append("eventSource=$eventSource,")
        append("evidenceAwsAccountId=$evidenceAwsAccountId,")
        append("evidenceByType=$evidenceByType,")
        append("evidenceFolderId=$evidenceFolderId,")
        append("iamId=$iamId,")
        append("id=$id,")
        append("resourcesIncluded=$resourcesIncluded,")
        append("time=$time)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assessmentReportSelection?.hashCode() ?: 0
        result = 31 * result + (attributes?.hashCode() ?: 0)
        result = 31 * result + (awsAccountId?.hashCode() ?: 0)
        result = 31 * result + (awsOrganization?.hashCode() ?: 0)
        result = 31 * result + (complianceCheck?.hashCode() ?: 0)
        result = 31 * result + (dataSource?.hashCode() ?: 0)
        result = 31 * result + (eventName?.hashCode() ?: 0)
        result = 31 * result + (eventSource?.hashCode() ?: 0)
        result = 31 * result + (evidenceAwsAccountId?.hashCode() ?: 0)
        result = 31 * result + (evidenceByType?.hashCode() ?: 0)
        result = 31 * result + (evidenceFolderId?.hashCode() ?: 0)
        result = 31 * result + (iamId?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (resourcesIncluded?.hashCode() ?: 0)
        result = 31 * result + (time?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Evidence

        if (assessmentReportSelection != other.assessmentReportSelection) return false
        if (attributes != other.attributes) return false
        if (awsAccountId != other.awsAccountId) return false
        if (awsOrganization != other.awsOrganization) return false
        if (complianceCheck != other.complianceCheck) return false
        if (dataSource != other.dataSource) return false
        if (eventName != other.eventName) return false
        if (eventSource != other.eventSource) return false
        if (evidenceAwsAccountId != other.evidenceAwsAccountId) return false
        if (evidenceByType != other.evidenceByType) return false
        if (evidenceFolderId != other.evidenceFolderId) return false
        if (iamId != other.iamId) return false
        if (id != other.id) return false
        if (resourcesIncluded != other.resourcesIncluded) return false
        if (time != other.time) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.auditmanager.model.Evidence = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies whether the evidence is included in the assessment report.
         */
        var assessmentReportSelection: kotlin.String? = null
        /**
         * The names and values that are used by the evidence event. This includes an attribute name (such as `allowUsersToChangePassword`) and value (such as `true` or `false`).
         */
        var attributes: Map<String, String>? = null
        /**
         * The identifier for the Amazon Web Services account.
         */
        var awsAccountId: kotlin.String? = null
        /**
         * The Amazon Web Services account that the evidence is collected from, and its organization path.
         */
        var awsOrganization: kotlin.String? = null
        /**
         * The evaluation status for evidence that falls under the compliance check category. For evidence collected from Security Hub, a *Pass* or *Fail* result is shown. For evidence collected from Config, a *Compliant* or *Noncompliant* result is shown.
         */
        var complianceCheck: kotlin.String? = null
        /**
         * The data source where the evidence was collected from.
         */
        var dataSource: kotlin.String? = null
        /**
         * The name of the evidence event.
         */
        var eventName: kotlin.String? = null
        /**
         * The Amazon Web Service that the evidence is collected from.
         */
        var eventSource: kotlin.String? = null
        /**
         * The identifier for the Amazon Web Services account.
         */
        var evidenceAwsAccountId: kotlin.String? = null
        /**
         * The type of automated evidence.
         */
        var evidenceByType: kotlin.String? = null
        /**
         * The identifier for the folder that the evidence is stored in.
         */
        var evidenceFolderId: kotlin.String? = null
        /**
         * The unique identifier for the IAM user or role that's associated with the evidence.
         */
        var iamId: kotlin.String? = null
        /**
         * The identifier for the evidence.
         */
        var id: kotlin.String? = null
        /**
         * The list of resources that are assessed to generate the evidence.
         */
        var resourcesIncluded: List<Resource>? = null
        /**
         * The timestamp that represents when the evidence was collected.
         */
        var time: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.auditmanager.model.Evidence) : this() {
            this.assessmentReportSelection = x.assessmentReportSelection
            this.attributes = x.attributes
            this.awsAccountId = x.awsAccountId
            this.awsOrganization = x.awsOrganization
            this.complianceCheck = x.complianceCheck
            this.dataSource = x.dataSource
            this.eventName = x.eventName
            this.eventSource = x.eventSource
            this.evidenceAwsAccountId = x.evidenceAwsAccountId
            this.evidenceByType = x.evidenceByType
            this.evidenceFolderId = x.evidenceFolderId
            this.iamId = x.iamId
            this.id = x.id
            this.resourcesIncluded = x.resourcesIncluded
            this.time = x.time
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.auditmanager.model.Evidence = Evidence(this)
    }
}
