// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A summary of the latest analytics data for a specific active assessment.
 *
 * This summary is a snapshot of the data that was collected on the `lastUpdated` date. It’s important to understand that the totals in `InsightsByAssessment` are daily counts based on this date — they aren’t a total sum to date.
 *
 * The `InsightsByAssessment` data is eventually consistent. This means that when you read data from `InsightsByAssessment`, the response might not instantly reflect the results of a recently completed write or update operation. If you repeat your read request after a few hours, the response returns the latest data.
 *
 * If you delete an assessment or change its status to inactive, `InsightsByAssessment` includes data for that assessment as follows.
 * + **Inactive assessments** - If Audit Manager collected evidence for your assessment before you changed it inactive, that evidence is included in the `InsightsByAssessment` counts for that day.
 * + **Deleted assessments** - If Audit Manager collected evidence for your assessment before you deleted it, that evidence isn't included in the `InsightsByAssessment` counts for that day.
 */
class InsightsByAssessment private constructor(builder: Builder) {
    /**
     * The number of assessment controls that collected non-compliant evidence on the `lastUpdated` date.
     */
    val assessmentControlsCountByNoncompliantEvidence: kotlin.Int? = builder.assessmentControlsCountByNoncompliantEvidence
    /**
     * The number of compliance check evidence that Audit Manager classified as compliant. This includes evidence that was collected from Security Hub with a *Pass* ruling, or collected from Config with a *Compliant* ruling.
     */
    val compliantEvidenceCount: kotlin.Int? = builder.compliantEvidenceCount
    /**
     * The amount of evidence without a compliance check ruling. Evidence is inconclusive if the associated control uses Security Hub or Config as a data source and you didn't enable those services. This is also the case if a control uses a data source that doesn’t support compliance checks (for example, manual evidence, API calls, or CloudTrail).
     *
     * If evidence has a compliance check status of *not applicable*, it's classified as *inconclusive* in `InsightsByAssessment` data.
     */
    val inconclusiveEvidenceCount: kotlin.Int? = builder.inconclusiveEvidenceCount
    /**
     * The time when the assessment insights were last updated.
     */
    val lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdated
    /**
     * The number of compliance check evidence that Audit Manager classified as non-compliant. This includes evidence that was collected from Security Hub with a *Fail* ruling, or collected from Config with a *Non-compliant* ruling.
     */
    val noncompliantEvidenceCount: kotlin.Int? = builder.noncompliantEvidenceCount
    /**
     * The total number of controls in the assessment.
     */
    val totalAssessmentControlsCount: kotlin.Int? = builder.totalAssessmentControlsCount

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.auditmanager.model.InsightsByAssessment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InsightsByAssessment(")
        append("assessmentControlsCountByNoncompliantEvidence=$assessmentControlsCountByNoncompliantEvidence,")
        append("compliantEvidenceCount=$compliantEvidenceCount,")
        append("inconclusiveEvidenceCount=$inconclusiveEvidenceCount,")
        append("lastUpdated=$lastUpdated,")
        append("noncompliantEvidenceCount=$noncompliantEvidenceCount,")
        append("totalAssessmentControlsCount=$totalAssessmentControlsCount)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assessmentControlsCountByNoncompliantEvidence ?: 0
        result = 31 * result + (compliantEvidenceCount ?: 0)
        result = 31 * result + (inconclusiveEvidenceCount ?: 0)
        result = 31 * result + (lastUpdated?.hashCode() ?: 0)
        result = 31 * result + (noncompliantEvidenceCount ?: 0)
        result = 31 * result + (totalAssessmentControlsCount ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InsightsByAssessment

        if (assessmentControlsCountByNoncompliantEvidence != other.assessmentControlsCountByNoncompliantEvidence) return false
        if (compliantEvidenceCount != other.compliantEvidenceCount) return false
        if (inconclusiveEvidenceCount != other.inconclusiveEvidenceCount) return false
        if (lastUpdated != other.lastUpdated) return false
        if (noncompliantEvidenceCount != other.noncompliantEvidenceCount) return false
        if (totalAssessmentControlsCount != other.totalAssessmentControlsCount) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.auditmanager.model.InsightsByAssessment = Builder(this).apply(block).build()

    class Builder {
        /**
         * The number of assessment controls that collected non-compliant evidence on the `lastUpdated` date.
         */
        var assessmentControlsCountByNoncompliantEvidence: kotlin.Int? = null
        /**
         * The number of compliance check evidence that Audit Manager classified as compliant. This includes evidence that was collected from Security Hub with a *Pass* ruling, or collected from Config with a *Compliant* ruling.
         */
        var compliantEvidenceCount: kotlin.Int? = null
        /**
         * The amount of evidence without a compliance check ruling. Evidence is inconclusive if the associated control uses Security Hub or Config as a data source and you didn't enable those services. This is also the case if a control uses a data source that doesn’t support compliance checks (for example, manual evidence, API calls, or CloudTrail).
         *
         * If evidence has a compliance check status of *not applicable*, it's classified as *inconclusive* in `InsightsByAssessment` data.
         */
        var inconclusiveEvidenceCount: kotlin.Int? = null
        /**
         * The time when the assessment insights were last updated.
         */
        var lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of compliance check evidence that Audit Manager classified as non-compliant. This includes evidence that was collected from Security Hub with a *Fail* ruling, or collected from Config with a *Non-compliant* ruling.
         */
        var noncompliantEvidenceCount: kotlin.Int? = null
        /**
         * The total number of controls in the assessment.
         */
        var totalAssessmentControlsCount: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.auditmanager.model.InsightsByAssessment) : this() {
            this.assessmentControlsCountByNoncompliantEvidence = x.assessmentControlsCountByNoncompliantEvidence
            this.compliantEvidenceCount = x.compliantEvidenceCount
            this.inconclusiveEvidenceCount = x.inconclusiveEvidenceCount
            this.lastUpdated = x.lastUpdated
            this.noncompliantEvidenceCount = x.noncompliantEvidenceCount
            this.totalAssessmentControlsCount = x.totalAssessmentControlsCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.auditmanager.model.InsightsByAssessment = InsightsByAssessment(this)
    }
}
