// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.auditmanager.model.AssessmentMetadataItem
import aws.sdk.kotlin.services.auditmanager.model.AuditManagerException
import aws.sdk.kotlin.services.auditmanager.model.ListAssessmentsResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListAssessmentsOperationDeserializer: HttpDeserialize<ListAssessmentsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListAssessmentsResponse {
        if (!response.status.isSuccess()) {
            throwListAssessmentsError(context, response)
        }
        val builder = ListAssessmentsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListAssessmentsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListAssessmentsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw AuditManagerException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> AuditManagerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListAssessmentsOperationBody(builder: ListAssessmentsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ASSESSMENTMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("assessmentMetadata"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ASSESSMENTMETADATA_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ASSESSMENTMETADATA_DESCRIPTOR.index -> builder.assessmentMetadata =
                    deserializer.deserializeList(ASSESSMENTMETADATA_DESCRIPTOR) {
                        val col0 = mutableListOf<AssessmentMetadataItem>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAssessmentMetadataItemDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
