// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.transform

import aws.sdk.kotlin.services.auditmanager.model.AssessmentReportsDestination
import aws.sdk.kotlin.services.auditmanager.model.Role
import aws.sdk.kotlin.services.auditmanager.model.Scope
import aws.sdk.kotlin.services.auditmanager.model.UpdateAssessmentRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateAssessmentOperationSerializer: HttpSerialize<UpdateAssessmentRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateAssessmentRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf(
                "assessments",
                "${input.assessmentId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateAssessmentOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateAssessmentOperationBody(context: ExecutionContext, input: UpdateAssessmentRequest): ByteArray {
    val serializer = JsonSerializer()
    val ASSESSMENTDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assessmentDescription"))
    val ASSESSMENTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assessmentName"))
    val ASSESSMENTREPORTSDESTINATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("assessmentReportsDestination"))
    val ROLES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("roles"))
    val SCOPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("scope"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ASSESSMENTDESCRIPTION_DESCRIPTOR)
        field(ASSESSMENTNAME_DESCRIPTOR)
        field(ASSESSMENTREPORTSDESTINATION_DESCRIPTOR)
        field(ROLES_DESCRIPTOR)
        field(SCOPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.assessmentDescription?.let { field(ASSESSMENTDESCRIPTION_DESCRIPTOR, it) }
        input.assessmentName?.let { field(ASSESSMENTNAME_DESCRIPTOR, it) }
        input.assessmentReportsDestination?.let { field(ASSESSMENTREPORTSDESTINATION_DESCRIPTOR, it, ::serializeAssessmentReportsDestinationDocument) }
        if (input.roles != null) {
            listField(ROLES_DESCRIPTOR) {
                for (el0 in input.roles) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeRoleDocument))
                }
            }
        }
        input.scope?.let { field(SCOPE_DESCRIPTOR, it, ::serializeScopeDocument) }
    }
    return serializer.toByteArray()
}
