// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.auditmanager.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.auditmanager.endpoints.EndpointProvider
import aws.sdk.kotlin.services.auditmanager.model.*
import aws.sdk.kotlin.services.auditmanager.model.AssociateAssessmentReportEvidenceFolderRequest
import aws.sdk.kotlin.services.auditmanager.model.AssociateAssessmentReportEvidenceFolderResponse
import aws.sdk.kotlin.services.auditmanager.model.BatchAssociateAssessmentReportEvidenceRequest
import aws.sdk.kotlin.services.auditmanager.model.BatchAssociateAssessmentReportEvidenceResponse
import aws.sdk.kotlin.services.auditmanager.model.BatchCreateDelegationByAssessmentRequest
import aws.sdk.kotlin.services.auditmanager.model.BatchCreateDelegationByAssessmentResponse
import aws.sdk.kotlin.services.auditmanager.model.BatchDeleteDelegationByAssessmentRequest
import aws.sdk.kotlin.services.auditmanager.model.BatchDeleteDelegationByAssessmentResponse
import aws.sdk.kotlin.services.auditmanager.model.BatchDisassociateAssessmentReportEvidenceRequest
import aws.sdk.kotlin.services.auditmanager.model.BatchDisassociateAssessmentReportEvidenceResponse
import aws.sdk.kotlin.services.auditmanager.model.BatchImportEvidenceToAssessmentControlRequest
import aws.sdk.kotlin.services.auditmanager.model.BatchImportEvidenceToAssessmentControlResponse
import aws.sdk.kotlin.services.auditmanager.model.CreateAssessmentFrameworkRequest
import aws.sdk.kotlin.services.auditmanager.model.CreateAssessmentFrameworkResponse
import aws.sdk.kotlin.services.auditmanager.model.CreateAssessmentReportRequest
import aws.sdk.kotlin.services.auditmanager.model.CreateAssessmentReportResponse
import aws.sdk.kotlin.services.auditmanager.model.CreateAssessmentRequest
import aws.sdk.kotlin.services.auditmanager.model.CreateAssessmentResponse
import aws.sdk.kotlin.services.auditmanager.model.CreateControlRequest
import aws.sdk.kotlin.services.auditmanager.model.CreateControlResponse
import aws.sdk.kotlin.services.auditmanager.model.DeleteAssessmentFrameworkRequest
import aws.sdk.kotlin.services.auditmanager.model.DeleteAssessmentFrameworkResponse
import aws.sdk.kotlin.services.auditmanager.model.DeleteAssessmentFrameworkShareRequest
import aws.sdk.kotlin.services.auditmanager.model.DeleteAssessmentFrameworkShareResponse
import aws.sdk.kotlin.services.auditmanager.model.DeleteAssessmentReportRequest
import aws.sdk.kotlin.services.auditmanager.model.DeleteAssessmentReportResponse
import aws.sdk.kotlin.services.auditmanager.model.DeleteAssessmentRequest
import aws.sdk.kotlin.services.auditmanager.model.DeleteAssessmentResponse
import aws.sdk.kotlin.services.auditmanager.model.DeleteControlRequest
import aws.sdk.kotlin.services.auditmanager.model.DeleteControlResponse
import aws.sdk.kotlin.services.auditmanager.model.DeregisterAccountRequest
import aws.sdk.kotlin.services.auditmanager.model.DeregisterAccountResponse
import aws.sdk.kotlin.services.auditmanager.model.DeregisterOrganizationAdminAccountRequest
import aws.sdk.kotlin.services.auditmanager.model.DeregisterOrganizationAdminAccountResponse
import aws.sdk.kotlin.services.auditmanager.model.DisassociateAssessmentReportEvidenceFolderRequest
import aws.sdk.kotlin.services.auditmanager.model.DisassociateAssessmentReportEvidenceFolderResponse
import aws.sdk.kotlin.services.auditmanager.model.GetAccountStatusRequest
import aws.sdk.kotlin.services.auditmanager.model.GetAccountStatusResponse
import aws.sdk.kotlin.services.auditmanager.model.GetAssessmentFrameworkRequest
import aws.sdk.kotlin.services.auditmanager.model.GetAssessmentFrameworkResponse
import aws.sdk.kotlin.services.auditmanager.model.GetAssessmentReportUrlRequest
import aws.sdk.kotlin.services.auditmanager.model.GetAssessmentReportUrlResponse
import aws.sdk.kotlin.services.auditmanager.model.GetAssessmentRequest
import aws.sdk.kotlin.services.auditmanager.model.GetAssessmentResponse
import aws.sdk.kotlin.services.auditmanager.model.GetChangeLogsRequest
import aws.sdk.kotlin.services.auditmanager.model.GetChangeLogsResponse
import aws.sdk.kotlin.services.auditmanager.model.GetControlRequest
import aws.sdk.kotlin.services.auditmanager.model.GetControlResponse
import aws.sdk.kotlin.services.auditmanager.model.GetDelegationsRequest
import aws.sdk.kotlin.services.auditmanager.model.GetDelegationsResponse
import aws.sdk.kotlin.services.auditmanager.model.GetEvidenceByEvidenceFolderRequest
import aws.sdk.kotlin.services.auditmanager.model.GetEvidenceByEvidenceFolderResponse
import aws.sdk.kotlin.services.auditmanager.model.GetEvidenceFolderRequest
import aws.sdk.kotlin.services.auditmanager.model.GetEvidenceFolderResponse
import aws.sdk.kotlin.services.auditmanager.model.GetEvidenceFoldersByAssessmentControlRequest
import aws.sdk.kotlin.services.auditmanager.model.GetEvidenceFoldersByAssessmentControlResponse
import aws.sdk.kotlin.services.auditmanager.model.GetEvidenceFoldersByAssessmentRequest
import aws.sdk.kotlin.services.auditmanager.model.GetEvidenceFoldersByAssessmentResponse
import aws.sdk.kotlin.services.auditmanager.model.GetEvidenceRequest
import aws.sdk.kotlin.services.auditmanager.model.GetEvidenceResponse
import aws.sdk.kotlin.services.auditmanager.model.GetInsightsByAssessmentRequest
import aws.sdk.kotlin.services.auditmanager.model.GetInsightsByAssessmentResponse
import aws.sdk.kotlin.services.auditmanager.model.GetInsightsRequest
import aws.sdk.kotlin.services.auditmanager.model.GetInsightsResponse
import aws.sdk.kotlin.services.auditmanager.model.GetOrganizationAdminAccountRequest
import aws.sdk.kotlin.services.auditmanager.model.GetOrganizationAdminAccountResponse
import aws.sdk.kotlin.services.auditmanager.model.GetServicesInScopeRequest
import aws.sdk.kotlin.services.auditmanager.model.GetServicesInScopeResponse
import aws.sdk.kotlin.services.auditmanager.model.GetSettingsRequest
import aws.sdk.kotlin.services.auditmanager.model.GetSettingsResponse
import aws.sdk.kotlin.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainRequest
import aws.sdk.kotlin.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse
import aws.sdk.kotlin.services.auditmanager.model.ListAssessmentFrameworkShareRequestsRequest
import aws.sdk.kotlin.services.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse
import aws.sdk.kotlin.services.auditmanager.model.ListAssessmentFrameworksRequest
import aws.sdk.kotlin.services.auditmanager.model.ListAssessmentFrameworksResponse
import aws.sdk.kotlin.services.auditmanager.model.ListAssessmentReportsRequest
import aws.sdk.kotlin.services.auditmanager.model.ListAssessmentReportsResponse
import aws.sdk.kotlin.services.auditmanager.model.ListAssessmentsRequest
import aws.sdk.kotlin.services.auditmanager.model.ListAssessmentsResponse
import aws.sdk.kotlin.services.auditmanager.model.ListControlDomainInsightsByAssessmentRequest
import aws.sdk.kotlin.services.auditmanager.model.ListControlDomainInsightsByAssessmentResponse
import aws.sdk.kotlin.services.auditmanager.model.ListControlDomainInsightsRequest
import aws.sdk.kotlin.services.auditmanager.model.ListControlDomainInsightsResponse
import aws.sdk.kotlin.services.auditmanager.model.ListControlInsightsByControlDomainRequest
import aws.sdk.kotlin.services.auditmanager.model.ListControlInsightsByControlDomainResponse
import aws.sdk.kotlin.services.auditmanager.model.ListControlsRequest
import aws.sdk.kotlin.services.auditmanager.model.ListControlsResponse
import aws.sdk.kotlin.services.auditmanager.model.ListKeywordsForDataSourceRequest
import aws.sdk.kotlin.services.auditmanager.model.ListKeywordsForDataSourceResponse
import aws.sdk.kotlin.services.auditmanager.model.ListNotificationsRequest
import aws.sdk.kotlin.services.auditmanager.model.ListNotificationsResponse
import aws.sdk.kotlin.services.auditmanager.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.auditmanager.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.auditmanager.model.RegisterAccountRequest
import aws.sdk.kotlin.services.auditmanager.model.RegisterAccountResponse
import aws.sdk.kotlin.services.auditmanager.model.RegisterOrganizationAdminAccountRequest
import aws.sdk.kotlin.services.auditmanager.model.RegisterOrganizationAdminAccountResponse
import aws.sdk.kotlin.services.auditmanager.model.StartAssessmentFrameworkShareRequest
import aws.sdk.kotlin.services.auditmanager.model.StartAssessmentFrameworkShareResponse
import aws.sdk.kotlin.services.auditmanager.model.TagResourceRequest
import aws.sdk.kotlin.services.auditmanager.model.TagResourceResponse
import aws.sdk.kotlin.services.auditmanager.model.UntagResourceRequest
import aws.sdk.kotlin.services.auditmanager.model.UntagResourceResponse
import aws.sdk.kotlin.services.auditmanager.model.UpdateAssessmentControlRequest
import aws.sdk.kotlin.services.auditmanager.model.UpdateAssessmentControlResponse
import aws.sdk.kotlin.services.auditmanager.model.UpdateAssessmentControlSetStatusRequest
import aws.sdk.kotlin.services.auditmanager.model.UpdateAssessmentControlSetStatusResponse
import aws.sdk.kotlin.services.auditmanager.model.UpdateAssessmentFrameworkRequest
import aws.sdk.kotlin.services.auditmanager.model.UpdateAssessmentFrameworkResponse
import aws.sdk.kotlin.services.auditmanager.model.UpdateAssessmentFrameworkShareRequest
import aws.sdk.kotlin.services.auditmanager.model.UpdateAssessmentFrameworkShareResponse
import aws.sdk.kotlin.services.auditmanager.model.UpdateAssessmentRequest
import aws.sdk.kotlin.services.auditmanager.model.UpdateAssessmentResponse
import aws.sdk.kotlin.services.auditmanager.model.UpdateAssessmentStatusRequest
import aws.sdk.kotlin.services.auditmanager.model.UpdateAssessmentStatusResponse
import aws.sdk.kotlin.services.auditmanager.model.UpdateControlRequest
import aws.sdk.kotlin.services.auditmanager.model.UpdateControlResponse
import aws.sdk.kotlin.services.auditmanager.model.UpdateSettingsRequest
import aws.sdk.kotlin.services.auditmanager.model.UpdateSettingsResponse
import aws.sdk.kotlin.services.auditmanager.model.ValidateAssessmentReportIntegrityRequest
import aws.sdk.kotlin.services.auditmanager.model.ValidateAssessmentReportIntegrityResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig

/**
 * Welcome to the Audit Manager API reference. This guide is for developers who need detailed information about the Audit Manager API operations, data types, and errors.
 *
 * Audit Manager is a service that provides automated evidence collection so that you can continually audit your Amazon Web Services usage. You can use it to assess the effectiveness of your controls, manage risk, and simplify compliance.
 *
 * Audit Manager provides prebuilt frameworks that structure and automate assessments for a given compliance standard. Frameworks include a prebuilt collection of controls with descriptions and testing procedures. These controls are grouped according to the requirements of the specified compliance standard or regulation. You can also customize frameworks and controls to support internal audits with specific requirements.
 *
 * Use the following links to get started with the Audit Manager API:
 * + [Actions](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_Operations.html): An alphabetical list of all Audit Manager API operations.
 * + [Data types](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_Types.html): An alphabetical list of all Audit Manager data types.
 * + [Common parameters](https://docs.aws.amazon.com/audit-manager/latest/APIReference/CommonParameters.html): Parameters that all Query operations can use.
 * + [Common errors](https://docs.aws.amazon.com/audit-manager/latest/APIReference/CommonErrors.html): Client and server errors that all operations can return.
 *
 * If you're new to Audit Manager, we recommend that you review the [ Audit Manager User Guide](https://docs.aws.amazon.com/audit-manager/latest/userguide/what-is.html).
 */
public interface AuditManagerClient : SdkClient {

    override val serviceName: String
        get() = "AuditManager"
    /**
     * AuditManagerClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): AuditManagerClient {
            val config = Config.Builder().apply(block).build()
            return DefaultAuditManagerClient(config)
        }

        public operator fun invoke(config: Config): AuditManagerClient = DefaultAuditManagerClient(config)

        /**
         * Construct a [AuditManagerClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): AuditManagerClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultAuditManagerClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "AuditManager")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null
            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null
            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            public var tracer: Tracer? = null
            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false
            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Associates an evidence folder to an assessment report in a Audit Manager assessment.
     */
    public suspend fun associateAssessmentReportEvidenceFolder(input: AssociateAssessmentReportEvidenceFolderRequest): AssociateAssessmentReportEvidenceFolderResponse

    /**
     * Associates a list of evidence to an assessment report in an Audit Manager assessment.
     */
    public suspend fun batchAssociateAssessmentReportEvidence(input: BatchAssociateAssessmentReportEvidenceRequest): BatchAssociateAssessmentReportEvidenceResponse

    /**
     * Creates a batch of delegations for an assessment in Audit Manager.
     */
    public suspend fun batchCreateDelegationByAssessment(input: BatchCreateDelegationByAssessmentRequest): BatchCreateDelegationByAssessmentResponse

    /**
     * Deletes a batch of delegations for an assessment in Audit Manager.
     */
    public suspend fun batchDeleteDelegationByAssessment(input: BatchDeleteDelegationByAssessmentRequest): BatchDeleteDelegationByAssessmentResponse

    /**
     * Disassociates a list of evidence from an assessment report in Audit Manager.
     */
    public suspend fun batchDisassociateAssessmentReportEvidence(input: BatchDisassociateAssessmentReportEvidenceRequest): BatchDisassociateAssessmentReportEvidenceResponse

    /**
     * Uploads one or more pieces of evidence to a control in an Audit Manager assessment. You can upload manual evidence from any Amazon Simple Storage Service (Amazon S3) bucket by specifying the S3 URI of the evidence.
     *
     * You must upload manual evidence to your S3 bucket before you can upload it to your assessment. For instructions, see [CreateBucket](https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html) and [PutObject](https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html) in the *Amazon Simple Storage Service API Reference.*
     *
     * The following restrictions apply to this action:
     * + Maximum size of an individual evidence file: 100 MB
     * + Number of daily manual evidence uploads per control: 100
     * + Supported file formats: See [Supported file types for manual evidence](https://docs.aws.amazon.com/audit-manager/latest/userguide/upload-evidence.html#supported-manual-evidence-files) in the *Audit Manager User Guide*
     *
     * For more information about Audit Manager service restrictions, see [Quotas and restrictions for Audit Manager](https://docs.aws.amazon.com/audit-manager/latest/userguide/service-quotas.html).
     */
    public suspend fun batchImportEvidenceToAssessmentControl(input: BatchImportEvidenceToAssessmentControlRequest): BatchImportEvidenceToAssessmentControlResponse

    /**
     * Creates an assessment in Audit Manager.
     */
    public suspend fun createAssessment(input: CreateAssessmentRequest): CreateAssessmentResponse

    /**
     * Creates a custom framework in Audit Manager.
     */
    public suspend fun createAssessmentFramework(input: CreateAssessmentFrameworkRequest): CreateAssessmentFrameworkResponse

    /**
     * Creates an assessment report for the specified assessment.
     */
    public suspend fun createAssessmentReport(input: CreateAssessmentReportRequest): CreateAssessmentReportResponse

    /**
     * Creates a new custom control in Audit Manager.
     */
    public suspend fun createControl(input: CreateControlRequest): CreateControlResponse

    /**
     * Deletes an assessment in Audit Manager.
     */
    public suspend fun deleteAssessment(input: DeleteAssessmentRequest): DeleteAssessmentResponse

    /**
     * Deletes a custom framework in Audit Manager.
     */
    public suspend fun deleteAssessmentFramework(input: DeleteAssessmentFrameworkRequest): DeleteAssessmentFrameworkResponse

    /**
     * Deletes a share request for a custom framework in Audit Manager.
     */
    public suspend fun deleteAssessmentFrameworkShare(input: DeleteAssessmentFrameworkShareRequest): DeleteAssessmentFrameworkShareResponse

    /**
     * Deletes an assessment report in Audit Manager.
     *
     * When you run the `DeleteAssessmentReport` operation, Audit Manager attempts to delete the following data:
     * + The specified assessment report that’s stored in your S3 bucket
     * + The associated metadata that’s stored in Audit Manager
     *
     * If Audit Manager can’t access the assessment report in your S3 bucket, the report isn’t deleted. In this event, the `DeleteAssessmentReport` operation doesn’t fail. Instead, it proceeds to delete the associated metadata only. You must then delete the assessment report from the S3 bucket yourself.
     *
     * This scenario happens when Audit Manager receives a `403 (Forbidden)` or `404 (Not Found)` error from Amazon S3. To avoid this, make sure that your S3 bucket is available, and that you configured the correct permissions for Audit Manager to delete resources in your S3 bucket. For an example permissions policy that you can use, see [Assessment report destination permissions](https://docs.aws.amazon.com/audit-manager/latest/userguide/security_iam_id-based-policy-examples.html#full-administrator-access-assessment-report-destination) in the *Audit Manager User Guide*. For information about the issues that could cause a `403 (Forbidden)` or `404 (Not Found`) error from Amazon S3, see [List of Error Codes](https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ErrorCodeList) in the *Amazon Simple Storage Service API Reference*.
     */
    public suspend fun deleteAssessmentReport(input: DeleteAssessmentReportRequest): DeleteAssessmentReportResponse

    /**
     * Deletes a custom control in Audit Manager.
     */
    public suspend fun deleteControl(input: DeleteControlRequest): DeleteControlResponse

    /**
     * Deregisters an account in Audit Manager.
     *
     * When you deregister your account from Audit Manager, your data isn’t deleted. If you want to delete your resource data, you must perform that task separately before you deregister your account. Either, you can do this in the Audit Manager console. Or, you can use one of the delete API operations that are provided by Audit Manager.
     *
     * To delete your Audit Manager resource data, see the following instructions:
     * + [DeleteAssessment](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessment.html) (see also: [Deleting an assessment](https://docs.aws.amazon.com/audit-manager/latest/userguide/delete-assessment.html) in the *Audit Manager User Guide*)
     * + [DeleteAssessmentFramework](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentFramework.html) (see also: [Deleting a custom framework](https://docs.aws.amazon.com/audit-manager/latest/userguide/delete-custom-framework.html) in the *Audit Manager User Guide*)
     * + [DeleteAssessmentFrameworkShare](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentFrameworkShare.html) (see also: [Deleting a share request](https://docs.aws.amazon.com/audit-manager/latest/userguide/deleting-shared-framework-requests.html) in the *Audit Manager User Guide*)
     * + [DeleteAssessmentReport](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentReport.html) (see also: [Deleting an assessment report](https://docs.aws.amazon.com/audit-manager/latest/userguide/generate-assessment-report.html#delete-assessment-report-steps) in the *Audit Manager User Guide*)
     * + [DeleteControl](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteControl.html) (see also: [Deleting a custom control](https://docs.aws.amazon.com/audit-manager/latest/userguide/delete-controls.html) in the *Audit Manager User Guide*)
     * At this time, Audit Manager doesn't provide an option to delete evidence. All available delete operations are listed above.
     */
    public suspend fun deregisterAccount(input: DeregisterAccountRequest = DeregisterAccountRequest {}): DeregisterAccountResponse

    /**
     * Removes the specified Amazon Web Services account as a delegated administrator for Audit Manager.
     *
     * When you remove a delegated administrator from your Audit Manager settings, you continue to have access to the evidence that you previously collected under that account. This is also the case when you deregister a delegated administrator from Organizations. However, Audit Manager will stop collecting and attaching evidence to that delegated administrator account moving forward.
     *
     * Keep in mind the following cleanup task if you use evidence finder:
     *
     * Before you use your management account to remove a delegated administrator, make sure that the current delegated administrator account signs in to Audit Manager and disables evidence finder first. Disabling evidence finder automatically deletes the event data store that was created in their account when they enabled evidence finder. If this task isn’t completed, the event data store remains in their account. In this case, we recommend that the original delegated administrator goes to CloudTrail Lake and manually [deletes the event data store](https://docs.aws.amazon.com/userguide/awscloudtrail/latest/userguide/query-eds-disable-termination.html).
     *
     * This cleanup task is necessary to ensure that you don't end up with multiple event data stores. Audit Manager will ignore an unused event data store after you remove or change a delegated administrator account. However, the unused event data store continues to incur storage costs from CloudTrail Lake if you don't delete it.
     *
     * When you deregister a delegated administrator account for Audit Manager, the data for that account isn’t deleted. If you want to delete resource data for a delegated administrator account, you must perform that task separately before you deregister the account. Either, you can do this in the Audit Manager console. Or, you can use one of the delete API operations that are provided by Audit Manager.
     *
     * To delete your Audit Manager resource data, see the following instructions:
     * + [DeleteAssessment](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessment.html) (see also: [Deleting an assessment](https://docs.aws.amazon.com/audit-manager/latest/userguide/delete-assessment.html) in the *Audit Manager User Guide*)
     * + [DeleteAssessmentFramework](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentFramework.html) (see also: [Deleting a custom framework](https://docs.aws.amazon.com/audit-manager/latest/userguide/delete-custom-framework.html) in the *Audit Manager User Guide*)
     * + [DeleteAssessmentFrameworkShare](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentFrameworkShare.html) (see also: [Deleting a share request](https://docs.aws.amazon.com/audit-manager/latest/userguide/deleting-shared-framework-requests.html) in the *Audit Manager User Guide*)
     * + [DeleteAssessmentReport](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentReport.html) (see also: [Deleting an assessment report](https://docs.aws.amazon.com/audit-manager/latest/userguide/generate-assessment-report.html#delete-assessment-report-steps) in the *Audit Manager User Guide*)
     * + [DeleteControl](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteControl.html) (see also: [Deleting a custom control](https://docs.aws.amazon.com/audit-manager/latest/userguide/delete-controls.html) in the *Audit Manager User Guide*)
     *
     * At this time, Audit Manager doesn't provide an option to delete evidence. All available delete operations are listed above.
     */
    public suspend fun deregisterOrganizationAdminAccount(input: DeregisterOrganizationAdminAccountRequest = DeregisterOrganizationAdminAccountRequest {}): DeregisterOrganizationAdminAccountResponse

    /**
     * Disassociates an evidence folder from the specified assessment report in Audit Manager.
     */
    public suspend fun disassociateAssessmentReportEvidenceFolder(input: DisassociateAssessmentReportEvidenceFolderRequest): DisassociateAssessmentReportEvidenceFolderResponse

    /**
     * Returns the registration status of an account in Audit Manager.
     */
    public suspend fun getAccountStatus(input: GetAccountStatusRequest = GetAccountStatusRequest {}): GetAccountStatusResponse

    /**
     * Returns an assessment from Audit Manager.
     */
    public suspend fun getAssessment(input: GetAssessmentRequest): GetAssessmentResponse

    /**
     * Returns a framework from Audit Manager.
     */
    public suspend fun getAssessmentFramework(input: GetAssessmentFrameworkRequest): GetAssessmentFrameworkResponse

    /**
     * Returns the URL of an assessment report in Audit Manager.
     */
    public suspend fun getAssessmentReportUrl(input: GetAssessmentReportUrlRequest): GetAssessmentReportUrlResponse

    /**
     * Returns a list of changelogs from Audit Manager.
     */
    public suspend fun getChangeLogs(input: GetChangeLogsRequest): GetChangeLogsResponse

    /**
     * Returns a control from Audit Manager.
     */
    public suspend fun getControl(input: GetControlRequest): GetControlResponse

    /**
     * Returns a list of delegations from an audit owner to a delegate.
     */
    public suspend fun getDelegations(input: GetDelegationsRequest = GetDelegationsRequest {}): GetDelegationsResponse

    /**
     * Returns evidence from Audit Manager.
     */
    public suspend fun getEvidence(input: GetEvidenceRequest): GetEvidenceResponse

    /**
     * Returns all evidence from a specified evidence folder in Audit Manager.
     */
    public suspend fun getEvidenceByEvidenceFolder(input: GetEvidenceByEvidenceFolderRequest): GetEvidenceByEvidenceFolderResponse

    /**
     * Returns an evidence folder from the specified assessment in Audit Manager.
     */
    public suspend fun getEvidenceFolder(input: GetEvidenceFolderRequest): GetEvidenceFolderResponse

    /**
     * Returns the evidence folders from a specified assessment in Audit Manager.
     */
    public suspend fun getEvidenceFoldersByAssessment(input: GetEvidenceFoldersByAssessmentRequest): GetEvidenceFoldersByAssessmentResponse

    /**
     * Returns a list of evidence folders that are associated with a specified control of an assessment in Audit Manager.
     */
    public suspend fun getEvidenceFoldersByAssessmentControl(input: GetEvidenceFoldersByAssessmentControlRequest): GetEvidenceFoldersByAssessmentControlResponse

    /**
     * Gets the latest analytics data for all your current active assessments.
     */
    public suspend fun getInsights(input: GetInsightsRequest = GetInsightsRequest {}): GetInsightsResponse

    /**
     * Gets the latest analytics data for a specific active assessment.
     */
    public suspend fun getInsightsByAssessment(input: GetInsightsByAssessmentRequest): GetInsightsByAssessmentResponse

    /**
     * Returns the name of the delegated Amazon Web Services administrator account for the organization.
     */
    public suspend fun getOrganizationAdminAccount(input: GetOrganizationAdminAccountRequest = GetOrganizationAdminAccountRequest {}): GetOrganizationAdminAccountResponse

    /**
     * Returns a list of all of the Amazon Web Services that you can choose to include in your assessment. When you [create an assessment](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_CreateAssessment.html), specify which of these services you want to include to narrow the assessment's [scope](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_Scope.html).
     */
    public suspend fun getServicesInScope(input: GetServicesInScopeRequest = GetServicesInScopeRequest {}): GetServicesInScopeResponse

    /**
     * Returns the settings for the specified Amazon Web Services account.
     */
    public suspend fun getSettings(input: GetSettingsRequest): GetSettingsResponse

    /**
     * Lists the latest analytics data for controls within a specific control domain and a specific active assessment.
     *
     * Control insights are listed only if the control belongs to the control domain and assessment that was specified. Moreover, the control must have collected evidence on the `lastUpdated` date of `controlInsightsByAssessment`. If neither of these conditions are met, no data is listed for that control.
     */
    public suspend fun listAssessmentControlInsightsByControlDomain(input: ListAssessmentControlInsightsByControlDomainRequest): ListAssessmentControlInsightsByControlDomainResponse

    /**
     * Returns a list of sent or received share requests for custom frameworks in Audit Manager.
     */
    public suspend fun listAssessmentFrameworkShareRequests(input: ListAssessmentFrameworkShareRequestsRequest): ListAssessmentFrameworkShareRequestsResponse

    /**
     * Returns a list of the frameworks that are available in the Audit Manager framework library.
     */
    public suspend fun listAssessmentFrameworks(input: ListAssessmentFrameworksRequest): ListAssessmentFrameworksResponse

    /**
     * Returns a list of assessment reports created in Audit Manager.
     */
    public suspend fun listAssessmentReports(input: ListAssessmentReportsRequest = ListAssessmentReportsRequest {}): ListAssessmentReportsResponse

    /**
     * Returns a list of current and past assessments from Audit Manager.
     */
    public suspend fun listAssessments(input: ListAssessmentsRequest = ListAssessmentsRequest {}): ListAssessmentsResponse

    /**
     * Lists the latest analytics data for control domains across all of your active assessments.
     *
     * A control domain is listed only if at least one of the controls within that domain collected evidence on the `lastUpdated` date of `controlDomainInsights`. If this condition isn’t met, no data is listed for that control domain.
     */
    public suspend fun listControlDomainInsights(input: ListControlDomainInsightsRequest = ListControlDomainInsightsRequest {}): ListControlDomainInsightsResponse

    /**
     * Lists analytics data for control domains within a specified active assessment.
     *
     * A control domain is listed only if at least one of the controls within that domain collected evidence on the `lastUpdated` date of `controlDomainInsights`. If this condition isn’t met, no data is listed for that domain.
     */
    public suspend fun listControlDomainInsightsByAssessment(input: ListControlDomainInsightsByAssessmentRequest): ListControlDomainInsightsByAssessmentResponse

    /**
     * Lists the latest analytics data for controls within a specific control domain across all active assessments.
     *
     * Control insights are listed only if the control belongs to the control domain that was specified and the control collected evidence on the `lastUpdated` date of `controlInsightsMetadata`. If neither of these conditions are met, no data is listed for that control.
     */
    public suspend fun listControlInsightsByControlDomain(input: ListControlInsightsByControlDomainRequest): ListControlInsightsByControlDomainResponse

    /**
     * Returns a list of controls from Audit Manager.
     */
    public suspend fun listControls(input: ListControlsRequest): ListControlsResponse

    /**
     * Returns a list of keywords that are pre-mapped to the specified control data source.
     */
    public suspend fun listKeywordsForDataSource(input: ListKeywordsForDataSourceRequest): ListKeywordsForDataSourceResponse

    /**
     * Returns a list of all Audit Manager notifications.
     */
    public suspend fun listNotifications(input: ListNotificationsRequest = ListNotificationsRequest {}): ListNotificationsResponse

    /**
     * Returns a list of tags for the specified resource in Audit Manager.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Enables Audit Manager for the specified Amazon Web Services account.
     */
    public suspend fun registerAccount(input: RegisterAccountRequest = RegisterAccountRequest {}): RegisterAccountResponse

    /**
     * Enables an Amazon Web Services account within the organization as the delegated administrator for Audit Manager.
     */
    public suspend fun registerOrganizationAdminAccount(input: RegisterOrganizationAdminAccountRequest): RegisterOrganizationAdminAccountResponse

    /**
     * Creates a share request for a custom framework in Audit Manager.
     *
     * The share request specifies a recipient and notifies them that a custom framework is available. Recipients have 120 days to accept or decline the request. If no action is taken, the share request expires.
     *
     * When you create a share request, Audit Manager stores a snapshot of your custom framework in the US East (N. Virginia) Amazon Web Services Region. Audit Manager also stores a backup of the same snapshot in the US West (Oregon) Amazon Web Services Region.
     *
     * Audit Manager deletes the snapshot and the backup snapshot when one of the following events occurs:
     * + The sender revokes the share request.
     * + The recipient declines the share request.
     * + The recipient encounters an error and doesn't successfully accept the share request.
     * + The share request expires before the recipient responds to the request.
     *
     * When a sender [resends a share request](https://docs.aws.amazon.com/audit-manager/latest/userguide/framework-sharing.html#framework-sharing-resend), the snapshot is replaced with an updated version that corresponds with the latest version of the custom framework.
     *
     * When a recipient accepts a share request, the snapshot is replicated into their Amazon Web Services account under the Amazon Web Services Region that was specified in the share request.
     *
     * When you invoke the `StartAssessmentFrameworkShare` API, you are about to share a custom framework with another Amazon Web Services account. You may not share a custom framework that is derived from a standard framework if the standard framework is designated as not eligible for sharing by Amazon Web Services, unless you have obtained permission to do so from the owner of the standard framework. To learn more about which standard frameworks are eligible for sharing, see [Framework sharing eligibility](https://docs.aws.amazon.com/audit-manager/latest/userguide/share-custom-framework-concepts-and-terminology.html#eligibility) in the *Audit Manager User Guide*.
     */
    public suspend fun startAssessmentFrameworkShare(input: StartAssessmentFrameworkShareRequest): StartAssessmentFrameworkShareResponse

    /**
     * Tags the specified resource in Audit Manager.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes a tag from a resource in Audit Manager.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Edits an Audit Manager assessment.
     */
    public suspend fun updateAssessment(input: UpdateAssessmentRequest): UpdateAssessmentResponse

    /**
     * Updates a control within an assessment in Audit Manager.
     */
    public suspend fun updateAssessmentControl(input: UpdateAssessmentControlRequest): UpdateAssessmentControlResponse

    /**
     * Updates the status of a control set in an Audit Manager assessment.
     */
    public suspend fun updateAssessmentControlSetStatus(input: UpdateAssessmentControlSetStatusRequest): UpdateAssessmentControlSetStatusResponse

    /**
     * Updates a custom framework in Audit Manager.
     */
    public suspend fun updateAssessmentFramework(input: UpdateAssessmentFrameworkRequest): UpdateAssessmentFrameworkResponse

    /**
     * Updates a share request for a custom framework in Audit Manager.
     */
    public suspend fun updateAssessmentFrameworkShare(input: UpdateAssessmentFrameworkShareRequest): UpdateAssessmentFrameworkShareResponse

    /**
     * Updates the status of an assessment in Audit Manager.
     */
    public suspend fun updateAssessmentStatus(input: UpdateAssessmentStatusRequest): UpdateAssessmentStatusResponse

    /**
     * Updates a custom control in Audit Manager.
     */
    public suspend fun updateControl(input: UpdateControlRequest): UpdateControlResponse

    /**
     * Updates Audit Manager settings for the current user account.
     */
    public suspend fun updateSettings(input: UpdateSettingsRequest = UpdateSettingsRequest {}): UpdateSettingsResponse

    /**
     * Validates the integrity of an assessment report in Audit Manager.
     */
    public suspend fun validateAssessmentReportIntegrity(input: ValidateAssessmentReportIntegrityRequest): ValidateAssessmentReportIntegrityResponse
}

/**
 * Associates an evidence folder to an assessment report in a Audit Manager assessment.
 */
public suspend inline fun AuditManagerClient.associateAssessmentReportEvidenceFolder(crossinline block: AssociateAssessmentReportEvidenceFolderRequest.Builder.() -> Unit): AssociateAssessmentReportEvidenceFolderResponse = associateAssessmentReportEvidenceFolder(AssociateAssessmentReportEvidenceFolderRequest.Builder().apply(block).build())

/**
 * Associates a list of evidence to an assessment report in an Audit Manager assessment.
 */
public suspend inline fun AuditManagerClient.batchAssociateAssessmentReportEvidence(crossinline block: BatchAssociateAssessmentReportEvidenceRequest.Builder.() -> Unit): BatchAssociateAssessmentReportEvidenceResponse = batchAssociateAssessmentReportEvidence(BatchAssociateAssessmentReportEvidenceRequest.Builder().apply(block).build())

/**
 * Creates a batch of delegations for an assessment in Audit Manager.
 */
public suspend inline fun AuditManagerClient.batchCreateDelegationByAssessment(crossinline block: BatchCreateDelegationByAssessmentRequest.Builder.() -> Unit): BatchCreateDelegationByAssessmentResponse = batchCreateDelegationByAssessment(BatchCreateDelegationByAssessmentRequest.Builder().apply(block).build())

/**
 * Deletes a batch of delegations for an assessment in Audit Manager.
 */
public suspend inline fun AuditManagerClient.batchDeleteDelegationByAssessment(crossinline block: BatchDeleteDelegationByAssessmentRequest.Builder.() -> Unit): BatchDeleteDelegationByAssessmentResponse = batchDeleteDelegationByAssessment(BatchDeleteDelegationByAssessmentRequest.Builder().apply(block).build())

/**
 * Disassociates a list of evidence from an assessment report in Audit Manager.
 */
public suspend inline fun AuditManagerClient.batchDisassociateAssessmentReportEvidence(crossinline block: BatchDisassociateAssessmentReportEvidenceRequest.Builder.() -> Unit): BatchDisassociateAssessmentReportEvidenceResponse = batchDisassociateAssessmentReportEvidence(BatchDisassociateAssessmentReportEvidenceRequest.Builder().apply(block).build())

/**
 * Uploads one or more pieces of evidence to a control in an Audit Manager assessment. You can upload manual evidence from any Amazon Simple Storage Service (Amazon S3) bucket by specifying the S3 URI of the evidence.
 *
 * You must upload manual evidence to your S3 bucket before you can upload it to your assessment. For instructions, see [CreateBucket](https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html) and [PutObject](https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html) in the *Amazon Simple Storage Service API Reference.*
 *
 * The following restrictions apply to this action:
 * + Maximum size of an individual evidence file: 100 MB
 * + Number of daily manual evidence uploads per control: 100
 * + Supported file formats: See [Supported file types for manual evidence](https://docs.aws.amazon.com/audit-manager/latest/userguide/upload-evidence.html#supported-manual-evidence-files) in the *Audit Manager User Guide*
 *
 * For more information about Audit Manager service restrictions, see [Quotas and restrictions for Audit Manager](https://docs.aws.amazon.com/audit-manager/latest/userguide/service-quotas.html).
 */
public suspend inline fun AuditManagerClient.batchImportEvidenceToAssessmentControl(crossinline block: BatchImportEvidenceToAssessmentControlRequest.Builder.() -> Unit): BatchImportEvidenceToAssessmentControlResponse = batchImportEvidenceToAssessmentControl(BatchImportEvidenceToAssessmentControlRequest.Builder().apply(block).build())

/**
 * Creates an assessment in Audit Manager.
 */
public suspend inline fun AuditManagerClient.createAssessment(crossinline block: CreateAssessmentRequest.Builder.() -> Unit): CreateAssessmentResponse = createAssessment(CreateAssessmentRequest.Builder().apply(block).build())

/**
 * Creates a custom framework in Audit Manager.
 */
public suspend inline fun AuditManagerClient.createAssessmentFramework(crossinline block: CreateAssessmentFrameworkRequest.Builder.() -> Unit): CreateAssessmentFrameworkResponse = createAssessmentFramework(CreateAssessmentFrameworkRequest.Builder().apply(block).build())

/**
 * Creates an assessment report for the specified assessment.
 */
public suspend inline fun AuditManagerClient.createAssessmentReport(crossinline block: CreateAssessmentReportRequest.Builder.() -> Unit): CreateAssessmentReportResponse = createAssessmentReport(CreateAssessmentReportRequest.Builder().apply(block).build())

/**
 * Creates a new custom control in Audit Manager.
 */
public suspend inline fun AuditManagerClient.createControl(crossinline block: CreateControlRequest.Builder.() -> Unit): CreateControlResponse = createControl(CreateControlRequest.Builder().apply(block).build())

/**
 * Deletes an assessment in Audit Manager.
 */
public suspend inline fun AuditManagerClient.deleteAssessment(crossinline block: DeleteAssessmentRequest.Builder.() -> Unit): DeleteAssessmentResponse = deleteAssessment(DeleteAssessmentRequest.Builder().apply(block).build())

/**
 * Deletes a custom framework in Audit Manager.
 */
public suspend inline fun AuditManagerClient.deleteAssessmentFramework(crossinline block: DeleteAssessmentFrameworkRequest.Builder.() -> Unit): DeleteAssessmentFrameworkResponse = deleteAssessmentFramework(DeleteAssessmentFrameworkRequest.Builder().apply(block).build())

/**
 * Deletes a share request for a custom framework in Audit Manager.
 */
public suspend inline fun AuditManagerClient.deleteAssessmentFrameworkShare(crossinline block: DeleteAssessmentFrameworkShareRequest.Builder.() -> Unit): DeleteAssessmentFrameworkShareResponse = deleteAssessmentFrameworkShare(DeleteAssessmentFrameworkShareRequest.Builder().apply(block).build())

/**
 * Deletes an assessment report in Audit Manager.
 *
 * When you run the `DeleteAssessmentReport` operation, Audit Manager attempts to delete the following data:
 * + The specified assessment report that’s stored in your S3 bucket
 * + The associated metadata that’s stored in Audit Manager
 *
 * If Audit Manager can’t access the assessment report in your S3 bucket, the report isn’t deleted. In this event, the `DeleteAssessmentReport` operation doesn’t fail. Instead, it proceeds to delete the associated metadata only. You must then delete the assessment report from the S3 bucket yourself.
 *
 * This scenario happens when Audit Manager receives a `403 (Forbidden)` or `404 (Not Found)` error from Amazon S3. To avoid this, make sure that your S3 bucket is available, and that you configured the correct permissions for Audit Manager to delete resources in your S3 bucket. For an example permissions policy that you can use, see [Assessment report destination permissions](https://docs.aws.amazon.com/audit-manager/latest/userguide/security_iam_id-based-policy-examples.html#full-administrator-access-assessment-report-destination) in the *Audit Manager User Guide*. For information about the issues that could cause a `403 (Forbidden)` or `404 (Not Found`) error from Amazon S3, see [List of Error Codes](https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ErrorCodeList) in the *Amazon Simple Storage Service API Reference*.
 */
public suspend inline fun AuditManagerClient.deleteAssessmentReport(crossinline block: DeleteAssessmentReportRequest.Builder.() -> Unit): DeleteAssessmentReportResponse = deleteAssessmentReport(DeleteAssessmentReportRequest.Builder().apply(block).build())

/**
 * Deletes a custom control in Audit Manager.
 */
public suspend inline fun AuditManagerClient.deleteControl(crossinline block: DeleteControlRequest.Builder.() -> Unit): DeleteControlResponse = deleteControl(DeleteControlRequest.Builder().apply(block).build())

/**
 * Deregisters an account in Audit Manager.
 *
 * When you deregister your account from Audit Manager, your data isn’t deleted. If you want to delete your resource data, you must perform that task separately before you deregister your account. Either, you can do this in the Audit Manager console. Or, you can use one of the delete API operations that are provided by Audit Manager.
 *
 * To delete your Audit Manager resource data, see the following instructions:
 * + [DeleteAssessment](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessment.html) (see also: [Deleting an assessment](https://docs.aws.amazon.com/audit-manager/latest/userguide/delete-assessment.html) in the *Audit Manager User Guide*)
 * + [DeleteAssessmentFramework](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentFramework.html) (see also: [Deleting a custom framework](https://docs.aws.amazon.com/audit-manager/latest/userguide/delete-custom-framework.html) in the *Audit Manager User Guide*)
 * + [DeleteAssessmentFrameworkShare](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentFrameworkShare.html) (see also: [Deleting a share request](https://docs.aws.amazon.com/audit-manager/latest/userguide/deleting-shared-framework-requests.html) in the *Audit Manager User Guide*)
 * + [DeleteAssessmentReport](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentReport.html) (see also: [Deleting an assessment report](https://docs.aws.amazon.com/audit-manager/latest/userguide/generate-assessment-report.html#delete-assessment-report-steps) in the *Audit Manager User Guide*)
 * + [DeleteControl](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteControl.html) (see also: [Deleting a custom control](https://docs.aws.amazon.com/audit-manager/latest/userguide/delete-controls.html) in the *Audit Manager User Guide*)
 * At this time, Audit Manager doesn't provide an option to delete evidence. All available delete operations are listed above.
 */
public suspend inline fun AuditManagerClient.deregisterAccount(crossinline block: DeregisterAccountRequest.Builder.() -> Unit): DeregisterAccountResponse = deregisterAccount(DeregisterAccountRequest.Builder().apply(block).build())

/**
 * Removes the specified Amazon Web Services account as a delegated administrator for Audit Manager.
 *
 * When you remove a delegated administrator from your Audit Manager settings, you continue to have access to the evidence that you previously collected under that account. This is also the case when you deregister a delegated administrator from Organizations. However, Audit Manager will stop collecting and attaching evidence to that delegated administrator account moving forward.
 *
 * Keep in mind the following cleanup task if you use evidence finder:
 *
 * Before you use your management account to remove a delegated administrator, make sure that the current delegated administrator account signs in to Audit Manager and disables evidence finder first. Disabling evidence finder automatically deletes the event data store that was created in their account when they enabled evidence finder. If this task isn’t completed, the event data store remains in their account. In this case, we recommend that the original delegated administrator goes to CloudTrail Lake and manually [deletes the event data store](https://docs.aws.amazon.com/userguide/awscloudtrail/latest/userguide/query-eds-disable-termination.html).
 *
 * This cleanup task is necessary to ensure that you don't end up with multiple event data stores. Audit Manager will ignore an unused event data store after you remove or change a delegated administrator account. However, the unused event data store continues to incur storage costs from CloudTrail Lake if you don't delete it.
 *
 * When you deregister a delegated administrator account for Audit Manager, the data for that account isn’t deleted. If you want to delete resource data for a delegated administrator account, you must perform that task separately before you deregister the account. Either, you can do this in the Audit Manager console. Or, you can use one of the delete API operations that are provided by Audit Manager.
 *
 * To delete your Audit Manager resource data, see the following instructions:
 * + [DeleteAssessment](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessment.html) (see also: [Deleting an assessment](https://docs.aws.amazon.com/audit-manager/latest/userguide/delete-assessment.html) in the *Audit Manager User Guide*)
 * + [DeleteAssessmentFramework](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentFramework.html) (see also: [Deleting a custom framework](https://docs.aws.amazon.com/audit-manager/latest/userguide/delete-custom-framework.html) in the *Audit Manager User Guide*)
 * + [DeleteAssessmentFrameworkShare](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentFrameworkShare.html) (see also: [Deleting a share request](https://docs.aws.amazon.com/audit-manager/latest/userguide/deleting-shared-framework-requests.html) in the *Audit Manager User Guide*)
 * + [DeleteAssessmentReport](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteAssessmentReport.html) (see also: [Deleting an assessment report](https://docs.aws.amazon.com/audit-manager/latest/userguide/generate-assessment-report.html#delete-assessment-report-steps) in the *Audit Manager User Guide*)
 * + [DeleteControl](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeleteControl.html) (see also: [Deleting a custom control](https://docs.aws.amazon.com/audit-manager/latest/userguide/delete-controls.html) in the *Audit Manager User Guide*)
 *
 * At this time, Audit Manager doesn't provide an option to delete evidence. All available delete operations are listed above.
 */
public suspend inline fun AuditManagerClient.deregisterOrganizationAdminAccount(crossinline block: DeregisterOrganizationAdminAccountRequest.Builder.() -> Unit): DeregisterOrganizationAdminAccountResponse = deregisterOrganizationAdminAccount(DeregisterOrganizationAdminAccountRequest.Builder().apply(block).build())

/**
 * Disassociates an evidence folder from the specified assessment report in Audit Manager.
 */
public suspend inline fun AuditManagerClient.disassociateAssessmentReportEvidenceFolder(crossinline block: DisassociateAssessmentReportEvidenceFolderRequest.Builder.() -> Unit): DisassociateAssessmentReportEvidenceFolderResponse = disassociateAssessmentReportEvidenceFolder(DisassociateAssessmentReportEvidenceFolderRequest.Builder().apply(block).build())

/**
 * Returns the registration status of an account in Audit Manager.
 */
public suspend inline fun AuditManagerClient.getAccountStatus(crossinline block: GetAccountStatusRequest.Builder.() -> Unit): GetAccountStatusResponse = getAccountStatus(GetAccountStatusRequest.Builder().apply(block).build())

/**
 * Returns an assessment from Audit Manager.
 */
public suspend inline fun AuditManagerClient.getAssessment(crossinline block: GetAssessmentRequest.Builder.() -> Unit): GetAssessmentResponse = getAssessment(GetAssessmentRequest.Builder().apply(block).build())

/**
 * Returns a framework from Audit Manager.
 */
public suspend inline fun AuditManagerClient.getAssessmentFramework(crossinline block: GetAssessmentFrameworkRequest.Builder.() -> Unit): GetAssessmentFrameworkResponse = getAssessmentFramework(GetAssessmentFrameworkRequest.Builder().apply(block).build())

/**
 * Returns the URL of an assessment report in Audit Manager.
 */
public suspend inline fun AuditManagerClient.getAssessmentReportUrl(crossinline block: GetAssessmentReportUrlRequest.Builder.() -> Unit): GetAssessmentReportUrlResponse = getAssessmentReportUrl(GetAssessmentReportUrlRequest.Builder().apply(block).build())

/**
 * Returns a list of changelogs from Audit Manager.
 */
public suspend inline fun AuditManagerClient.getChangeLogs(crossinline block: GetChangeLogsRequest.Builder.() -> Unit): GetChangeLogsResponse = getChangeLogs(GetChangeLogsRequest.Builder().apply(block).build())

/**
 * Returns a control from Audit Manager.
 */
public suspend inline fun AuditManagerClient.getControl(crossinline block: GetControlRequest.Builder.() -> Unit): GetControlResponse = getControl(GetControlRequest.Builder().apply(block).build())

/**
 * Returns a list of delegations from an audit owner to a delegate.
 */
public suspend inline fun AuditManagerClient.getDelegations(crossinline block: GetDelegationsRequest.Builder.() -> Unit): GetDelegationsResponse = getDelegations(GetDelegationsRequest.Builder().apply(block).build())

/**
 * Returns evidence from Audit Manager.
 */
public suspend inline fun AuditManagerClient.getEvidence(crossinline block: GetEvidenceRequest.Builder.() -> Unit): GetEvidenceResponse = getEvidence(GetEvidenceRequest.Builder().apply(block).build())

/**
 * Returns all evidence from a specified evidence folder in Audit Manager.
 */
public suspend inline fun AuditManagerClient.getEvidenceByEvidenceFolder(crossinline block: GetEvidenceByEvidenceFolderRequest.Builder.() -> Unit): GetEvidenceByEvidenceFolderResponse = getEvidenceByEvidenceFolder(GetEvidenceByEvidenceFolderRequest.Builder().apply(block).build())

/**
 * Returns an evidence folder from the specified assessment in Audit Manager.
 */
public suspend inline fun AuditManagerClient.getEvidenceFolder(crossinline block: GetEvidenceFolderRequest.Builder.() -> Unit): GetEvidenceFolderResponse = getEvidenceFolder(GetEvidenceFolderRequest.Builder().apply(block).build())

/**
 * Returns the evidence folders from a specified assessment in Audit Manager.
 */
public suspend inline fun AuditManagerClient.getEvidenceFoldersByAssessment(crossinline block: GetEvidenceFoldersByAssessmentRequest.Builder.() -> Unit): GetEvidenceFoldersByAssessmentResponse = getEvidenceFoldersByAssessment(GetEvidenceFoldersByAssessmentRequest.Builder().apply(block).build())

/**
 * Returns a list of evidence folders that are associated with a specified control of an assessment in Audit Manager.
 */
public suspend inline fun AuditManagerClient.getEvidenceFoldersByAssessmentControl(crossinline block: GetEvidenceFoldersByAssessmentControlRequest.Builder.() -> Unit): GetEvidenceFoldersByAssessmentControlResponse = getEvidenceFoldersByAssessmentControl(GetEvidenceFoldersByAssessmentControlRequest.Builder().apply(block).build())

/**
 * Gets the latest analytics data for all your current active assessments.
 */
public suspend inline fun AuditManagerClient.getInsights(crossinline block: GetInsightsRequest.Builder.() -> Unit): GetInsightsResponse = getInsights(GetInsightsRequest.Builder().apply(block).build())

/**
 * Gets the latest analytics data for a specific active assessment.
 */
public suspend inline fun AuditManagerClient.getInsightsByAssessment(crossinline block: GetInsightsByAssessmentRequest.Builder.() -> Unit): GetInsightsByAssessmentResponse = getInsightsByAssessment(GetInsightsByAssessmentRequest.Builder().apply(block).build())

/**
 * Returns the name of the delegated Amazon Web Services administrator account for the organization.
 */
public suspend inline fun AuditManagerClient.getOrganizationAdminAccount(crossinline block: GetOrganizationAdminAccountRequest.Builder.() -> Unit): GetOrganizationAdminAccountResponse = getOrganizationAdminAccount(GetOrganizationAdminAccountRequest.Builder().apply(block).build())

/**
 * Returns a list of all of the Amazon Web Services that you can choose to include in your assessment. When you [create an assessment](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_CreateAssessment.html), specify which of these services you want to include to narrow the assessment's [scope](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_Scope.html).
 */
public suspend inline fun AuditManagerClient.getServicesInScope(crossinline block: GetServicesInScopeRequest.Builder.() -> Unit): GetServicesInScopeResponse = getServicesInScope(GetServicesInScopeRequest.Builder().apply(block).build())

/**
 * Returns the settings for the specified Amazon Web Services account.
 */
public suspend inline fun AuditManagerClient.getSettings(crossinline block: GetSettingsRequest.Builder.() -> Unit): GetSettingsResponse = getSettings(GetSettingsRequest.Builder().apply(block).build())

/**
 * Lists the latest analytics data for controls within a specific control domain and a specific active assessment.
 *
 * Control insights are listed only if the control belongs to the control domain and assessment that was specified. Moreover, the control must have collected evidence on the `lastUpdated` date of `controlInsightsByAssessment`. If neither of these conditions are met, no data is listed for that control.
 */
public suspend inline fun AuditManagerClient.listAssessmentControlInsightsByControlDomain(crossinline block: ListAssessmentControlInsightsByControlDomainRequest.Builder.() -> Unit): ListAssessmentControlInsightsByControlDomainResponse = listAssessmentControlInsightsByControlDomain(ListAssessmentControlInsightsByControlDomainRequest.Builder().apply(block).build())

/**
 * Returns a list of sent or received share requests for custom frameworks in Audit Manager.
 */
public suspend inline fun AuditManagerClient.listAssessmentFrameworkShareRequests(crossinline block: ListAssessmentFrameworkShareRequestsRequest.Builder.() -> Unit): ListAssessmentFrameworkShareRequestsResponse = listAssessmentFrameworkShareRequests(ListAssessmentFrameworkShareRequestsRequest.Builder().apply(block).build())

/**
 * Returns a list of the frameworks that are available in the Audit Manager framework library.
 */
public suspend inline fun AuditManagerClient.listAssessmentFrameworks(crossinline block: ListAssessmentFrameworksRequest.Builder.() -> Unit): ListAssessmentFrameworksResponse = listAssessmentFrameworks(ListAssessmentFrameworksRequest.Builder().apply(block).build())

/**
 * Returns a list of assessment reports created in Audit Manager.
 */
public suspend inline fun AuditManagerClient.listAssessmentReports(crossinline block: ListAssessmentReportsRequest.Builder.() -> Unit): ListAssessmentReportsResponse = listAssessmentReports(ListAssessmentReportsRequest.Builder().apply(block).build())

/**
 * Returns a list of current and past assessments from Audit Manager.
 */
public suspend inline fun AuditManagerClient.listAssessments(crossinline block: ListAssessmentsRequest.Builder.() -> Unit): ListAssessmentsResponse = listAssessments(ListAssessmentsRequest.Builder().apply(block).build())

/**
 * Lists the latest analytics data for control domains across all of your active assessments.
 *
 * A control domain is listed only if at least one of the controls within that domain collected evidence on the `lastUpdated` date of `controlDomainInsights`. If this condition isn’t met, no data is listed for that control domain.
 */
public suspend inline fun AuditManagerClient.listControlDomainInsights(crossinline block: ListControlDomainInsightsRequest.Builder.() -> Unit): ListControlDomainInsightsResponse = listControlDomainInsights(ListControlDomainInsightsRequest.Builder().apply(block).build())

/**
 * Lists analytics data for control domains within a specified active assessment.
 *
 * A control domain is listed only if at least one of the controls within that domain collected evidence on the `lastUpdated` date of `controlDomainInsights`. If this condition isn’t met, no data is listed for that domain.
 */
public suspend inline fun AuditManagerClient.listControlDomainInsightsByAssessment(crossinline block: ListControlDomainInsightsByAssessmentRequest.Builder.() -> Unit): ListControlDomainInsightsByAssessmentResponse = listControlDomainInsightsByAssessment(ListControlDomainInsightsByAssessmentRequest.Builder().apply(block).build())

/**
 * Lists the latest analytics data for controls within a specific control domain across all active assessments.
 *
 * Control insights are listed only if the control belongs to the control domain that was specified and the control collected evidence on the `lastUpdated` date of `controlInsightsMetadata`. If neither of these conditions are met, no data is listed for that control.
 */
public suspend inline fun AuditManagerClient.listControlInsightsByControlDomain(crossinline block: ListControlInsightsByControlDomainRequest.Builder.() -> Unit): ListControlInsightsByControlDomainResponse = listControlInsightsByControlDomain(ListControlInsightsByControlDomainRequest.Builder().apply(block).build())

/**
 * Returns a list of controls from Audit Manager.
 */
public suspend inline fun AuditManagerClient.listControls(crossinline block: ListControlsRequest.Builder.() -> Unit): ListControlsResponse = listControls(ListControlsRequest.Builder().apply(block).build())

/**
 * Returns a list of keywords that are pre-mapped to the specified control data source.
 */
public suspend inline fun AuditManagerClient.listKeywordsForDataSource(crossinline block: ListKeywordsForDataSourceRequest.Builder.() -> Unit): ListKeywordsForDataSourceResponse = listKeywordsForDataSource(ListKeywordsForDataSourceRequest.Builder().apply(block).build())

/**
 * Returns a list of all Audit Manager notifications.
 */
public suspend inline fun AuditManagerClient.listNotifications(crossinline block: ListNotificationsRequest.Builder.() -> Unit): ListNotificationsResponse = listNotifications(ListNotificationsRequest.Builder().apply(block).build())

/**
 * Returns a list of tags for the specified resource in Audit Manager.
 */
public suspend inline fun AuditManagerClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Enables Audit Manager for the specified Amazon Web Services account.
 */
public suspend inline fun AuditManagerClient.registerAccount(crossinline block: RegisterAccountRequest.Builder.() -> Unit): RegisterAccountResponse = registerAccount(RegisterAccountRequest.Builder().apply(block).build())

/**
 * Enables an Amazon Web Services account within the organization as the delegated administrator for Audit Manager.
 */
public suspend inline fun AuditManagerClient.registerOrganizationAdminAccount(crossinline block: RegisterOrganizationAdminAccountRequest.Builder.() -> Unit): RegisterOrganizationAdminAccountResponse = registerOrganizationAdminAccount(RegisterOrganizationAdminAccountRequest.Builder().apply(block).build())

/**
 * Creates a share request for a custom framework in Audit Manager.
 *
 * The share request specifies a recipient and notifies them that a custom framework is available. Recipients have 120 days to accept or decline the request. If no action is taken, the share request expires.
 *
 * When you create a share request, Audit Manager stores a snapshot of your custom framework in the US East (N. Virginia) Amazon Web Services Region. Audit Manager also stores a backup of the same snapshot in the US West (Oregon) Amazon Web Services Region.
 *
 * Audit Manager deletes the snapshot and the backup snapshot when one of the following events occurs:
 * + The sender revokes the share request.
 * + The recipient declines the share request.
 * + The recipient encounters an error and doesn't successfully accept the share request.
 * + The share request expires before the recipient responds to the request.
 *
 * When a sender [resends a share request](https://docs.aws.amazon.com/audit-manager/latest/userguide/framework-sharing.html#framework-sharing-resend), the snapshot is replaced with an updated version that corresponds with the latest version of the custom framework.
 *
 * When a recipient accepts a share request, the snapshot is replicated into their Amazon Web Services account under the Amazon Web Services Region that was specified in the share request.
 *
 * When you invoke the `StartAssessmentFrameworkShare` API, you are about to share a custom framework with another Amazon Web Services account. You may not share a custom framework that is derived from a standard framework if the standard framework is designated as not eligible for sharing by Amazon Web Services, unless you have obtained permission to do so from the owner of the standard framework. To learn more about which standard frameworks are eligible for sharing, see [Framework sharing eligibility](https://docs.aws.amazon.com/audit-manager/latest/userguide/share-custom-framework-concepts-and-terminology.html#eligibility) in the *Audit Manager User Guide*.
 */
public suspend inline fun AuditManagerClient.startAssessmentFrameworkShare(crossinline block: StartAssessmentFrameworkShareRequest.Builder.() -> Unit): StartAssessmentFrameworkShareResponse = startAssessmentFrameworkShare(StartAssessmentFrameworkShareRequest.Builder().apply(block).build())

/**
 * Tags the specified resource in Audit Manager.
 */
public suspend inline fun AuditManagerClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes a tag from a resource in Audit Manager.
 */
public suspend inline fun AuditManagerClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Edits an Audit Manager assessment.
 */
public suspend inline fun AuditManagerClient.updateAssessment(crossinline block: UpdateAssessmentRequest.Builder.() -> Unit): UpdateAssessmentResponse = updateAssessment(UpdateAssessmentRequest.Builder().apply(block).build())

/**
 * Updates a control within an assessment in Audit Manager.
 */
public suspend inline fun AuditManagerClient.updateAssessmentControl(crossinline block: UpdateAssessmentControlRequest.Builder.() -> Unit): UpdateAssessmentControlResponse = updateAssessmentControl(UpdateAssessmentControlRequest.Builder().apply(block).build())

/**
 * Updates the status of a control set in an Audit Manager assessment.
 */
public suspend inline fun AuditManagerClient.updateAssessmentControlSetStatus(crossinline block: UpdateAssessmentControlSetStatusRequest.Builder.() -> Unit): UpdateAssessmentControlSetStatusResponse = updateAssessmentControlSetStatus(UpdateAssessmentControlSetStatusRequest.Builder().apply(block).build())

/**
 * Updates a custom framework in Audit Manager.
 */
public suspend inline fun AuditManagerClient.updateAssessmentFramework(crossinline block: UpdateAssessmentFrameworkRequest.Builder.() -> Unit): UpdateAssessmentFrameworkResponse = updateAssessmentFramework(UpdateAssessmentFrameworkRequest.Builder().apply(block).build())

/**
 * Updates a share request for a custom framework in Audit Manager.
 */
public suspend inline fun AuditManagerClient.updateAssessmentFrameworkShare(crossinline block: UpdateAssessmentFrameworkShareRequest.Builder.() -> Unit): UpdateAssessmentFrameworkShareResponse = updateAssessmentFrameworkShare(UpdateAssessmentFrameworkShareRequest.Builder().apply(block).build())

/**
 * Updates the status of an assessment in Audit Manager.
 */
public suspend inline fun AuditManagerClient.updateAssessmentStatus(crossinline block: UpdateAssessmentStatusRequest.Builder.() -> Unit): UpdateAssessmentStatusResponse = updateAssessmentStatus(UpdateAssessmentStatusRequest.Builder().apply(block).build())

/**
 * Updates a custom control in Audit Manager.
 */
public suspend inline fun AuditManagerClient.updateControl(crossinline block: UpdateControlRequest.Builder.() -> Unit): UpdateControlResponse = updateControl(UpdateControlRequest.Builder().apply(block).build())

/**
 * Updates Audit Manager settings for the current user account.
 */
public suspend inline fun AuditManagerClient.updateSettings(crossinline block: UpdateSettingsRequest.Builder.() -> Unit): UpdateSettingsResponse = updateSettings(UpdateSettingsRequest.Builder().apply(block).build())

/**
 * Validates the integrity of an assessment report in Audit Manager.
 */
public suspend inline fun AuditManagerClient.validateAssessmentReportIntegrity(crossinline block: ValidateAssessmentReportIntegrityRequest.Builder.() -> Unit): ValidateAssessmentReportIntegrityResponse = validateAssessmentReportIntegrity(ValidateAssessmentReportIntegrityRequest.Builder().apply(block).build())
