// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The folder where Audit Manager stores evidence for an assessment.
 */
public class AssessmentEvidenceFolder private constructor(builder: Builder) {
    /**
     * The identifier for the assessment.
     */
    public val assessmentId: kotlin.String? = builder.assessmentId
    /**
     * The total count of evidence that's included in the assessment report.
     */
    public val assessmentReportSelectionCount: kotlin.Int = builder.assessmentReportSelectionCount
    /**
     * The name of the user who created the evidence folder.
     */
    public val author: kotlin.String? = builder.author
    /**
     * The unique identifier for the control.
     */
    public val controlId: kotlin.String? = builder.controlId
    /**
     * The name of the control.
     */
    public val controlName: kotlin.String? = builder.controlName
    /**
     * The identifier for the control set.
     */
    public val controlSetId: kotlin.String? = builder.controlSetId
    /**
     * The Amazon Web Service that the evidence was collected from.
     */
    public val dataSource: kotlin.String? = builder.dataSource
    /**
     * The date when the first evidence was added to the evidence folder.
     */
    public val date: aws.smithy.kotlin.runtime.time.Instant? = builder.date
    /**
     * The total number of Amazon Web Services resources that were assessed to generate the evidence.
     */
    public val evidenceAwsServiceSourceCount: kotlin.Int = builder.evidenceAwsServiceSourceCount
    /**
     * The number of evidence that falls under the compliance check category. This evidence is collected from Config or Security Hub.
     */
    public val evidenceByTypeComplianceCheckCount: kotlin.Int = builder.evidenceByTypeComplianceCheckCount
    /**
     * The total number of issues that were reported directly from Security Hub, Config, or both.
     */
    public val evidenceByTypeComplianceCheckIssuesCount: kotlin.Int = builder.evidenceByTypeComplianceCheckIssuesCount
    /**
     * The number of evidence that falls under the configuration data category. This evidence is collected from configuration snapshots of other Amazon Web Services such as Amazon EC2, Amazon S3, or IAM.
     */
    public val evidenceByTypeConfigurationDataCount: kotlin.Int = builder.evidenceByTypeConfigurationDataCount
    /**
     * The number of evidence that falls under the manual category. This evidence is imported manually.
     */
    public val evidenceByTypeManualCount: kotlin.Int = builder.evidenceByTypeManualCount
    /**
     * The number of evidence that falls under the user activity category. This evidence is collected from CloudTrail logs.
     */
    public val evidenceByTypeUserActivityCount: kotlin.Int = builder.evidenceByTypeUserActivityCount
    /**
     * The amount of evidence that's included in the evidence folder.
     */
    public val evidenceResourcesIncludedCount: kotlin.Int = builder.evidenceResourcesIncludedCount
    /**
     * The identifier for the folder that the evidence is stored in.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The name of the evidence folder.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The total amount of evidence in the evidence folder.
     */
    public val totalEvidence: kotlin.Int = builder.totalEvidence

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.auditmanager.model.AssessmentEvidenceFolder = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssessmentEvidenceFolder(")
        append("assessmentId=$assessmentId,")
        append("assessmentReportSelectionCount=$assessmentReportSelectionCount,")
        append("author=$author,")
        append("controlId=$controlId,")
        append("controlName=$controlName,")
        append("controlSetId=$controlSetId,")
        append("dataSource=$dataSource,")
        append("date=$date,")
        append("evidenceAwsServiceSourceCount=$evidenceAwsServiceSourceCount,")
        append("evidenceByTypeComplianceCheckCount=$evidenceByTypeComplianceCheckCount,")
        append("evidenceByTypeComplianceCheckIssuesCount=$evidenceByTypeComplianceCheckIssuesCount,")
        append("evidenceByTypeConfigurationDataCount=$evidenceByTypeConfigurationDataCount,")
        append("evidenceByTypeManualCount=$evidenceByTypeManualCount,")
        append("evidenceByTypeUserActivityCount=$evidenceByTypeUserActivityCount,")
        append("evidenceResourcesIncludedCount=$evidenceResourcesIncludedCount,")
        append("id=$id,")
        append("name=$name,")
        append("totalEvidence=$totalEvidence")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assessmentId?.hashCode() ?: 0
        result = 31 * result + (assessmentReportSelectionCount)
        result = 31 * result + (author?.hashCode() ?: 0)
        result = 31 * result + (controlId?.hashCode() ?: 0)
        result = 31 * result + (controlName?.hashCode() ?: 0)
        result = 31 * result + (controlSetId?.hashCode() ?: 0)
        result = 31 * result + (dataSource?.hashCode() ?: 0)
        result = 31 * result + (date?.hashCode() ?: 0)
        result = 31 * result + (evidenceAwsServiceSourceCount)
        result = 31 * result + (evidenceByTypeComplianceCheckCount)
        result = 31 * result + (evidenceByTypeComplianceCheckIssuesCount)
        result = 31 * result + (evidenceByTypeConfigurationDataCount)
        result = 31 * result + (evidenceByTypeManualCount)
        result = 31 * result + (evidenceByTypeUserActivityCount)
        result = 31 * result + (evidenceResourcesIncludedCount)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (totalEvidence)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssessmentEvidenceFolder

        if (assessmentId != other.assessmentId) return false
        if (assessmentReportSelectionCount != other.assessmentReportSelectionCount) return false
        if (author != other.author) return false
        if (controlId != other.controlId) return false
        if (controlName != other.controlName) return false
        if (controlSetId != other.controlSetId) return false
        if (dataSource != other.dataSource) return false
        if (date != other.date) return false
        if (evidenceAwsServiceSourceCount != other.evidenceAwsServiceSourceCount) return false
        if (evidenceByTypeComplianceCheckCount != other.evidenceByTypeComplianceCheckCount) return false
        if (evidenceByTypeComplianceCheckIssuesCount != other.evidenceByTypeComplianceCheckIssuesCount) return false
        if (evidenceByTypeConfigurationDataCount != other.evidenceByTypeConfigurationDataCount) return false
        if (evidenceByTypeManualCount != other.evidenceByTypeManualCount) return false
        if (evidenceByTypeUserActivityCount != other.evidenceByTypeUserActivityCount) return false
        if (evidenceResourcesIncludedCount != other.evidenceResourcesIncludedCount) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (totalEvidence != other.totalEvidence) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.auditmanager.model.AssessmentEvidenceFolder = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier for the assessment.
         */
        public var assessmentId: kotlin.String? = null
        /**
         * The total count of evidence that's included in the assessment report.
         */
        public var assessmentReportSelectionCount: kotlin.Int = 0
        /**
         * The name of the user who created the evidence folder.
         */
        public var author: kotlin.String? = null
        /**
         * The unique identifier for the control.
         */
        public var controlId: kotlin.String? = null
        /**
         * The name of the control.
         */
        public var controlName: kotlin.String? = null
        /**
         * The identifier for the control set.
         */
        public var controlSetId: kotlin.String? = null
        /**
         * The Amazon Web Service that the evidence was collected from.
         */
        public var dataSource: kotlin.String? = null
        /**
         * The date when the first evidence was added to the evidence folder.
         */
        public var date: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The total number of Amazon Web Services resources that were assessed to generate the evidence.
         */
        public var evidenceAwsServiceSourceCount: kotlin.Int = 0
        /**
         * The number of evidence that falls under the compliance check category. This evidence is collected from Config or Security Hub.
         */
        public var evidenceByTypeComplianceCheckCount: kotlin.Int = 0
        /**
         * The total number of issues that were reported directly from Security Hub, Config, or both.
         */
        public var evidenceByTypeComplianceCheckIssuesCount: kotlin.Int = 0
        /**
         * The number of evidence that falls under the configuration data category. This evidence is collected from configuration snapshots of other Amazon Web Services such as Amazon EC2, Amazon S3, or IAM.
         */
        public var evidenceByTypeConfigurationDataCount: kotlin.Int = 0
        /**
         * The number of evidence that falls under the manual category. This evidence is imported manually.
         */
        public var evidenceByTypeManualCount: kotlin.Int = 0
        /**
         * The number of evidence that falls under the user activity category. This evidence is collected from CloudTrail logs.
         */
        public var evidenceByTypeUserActivityCount: kotlin.Int = 0
        /**
         * The amount of evidence that's included in the evidence folder.
         */
        public var evidenceResourcesIncludedCount: kotlin.Int = 0
        /**
         * The identifier for the folder that the evidence is stored in.
         */
        public var id: kotlin.String? = null
        /**
         * The name of the evidence folder.
         */
        public var name: kotlin.String? = null
        /**
         * The total amount of evidence in the evidence folder.
         */
        public var totalEvidence: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.auditmanager.model.AssessmentEvidenceFolder) : this() {
            this.assessmentId = x.assessmentId
            this.assessmentReportSelectionCount = x.assessmentReportSelectionCount
            this.author = x.author
            this.controlId = x.controlId
            this.controlName = x.controlName
            this.controlSetId = x.controlSetId
            this.dataSource = x.dataSource
            this.date = x.date
            this.evidenceAwsServiceSourceCount = x.evidenceAwsServiceSourceCount
            this.evidenceByTypeComplianceCheckCount = x.evidenceByTypeComplianceCheckCount
            this.evidenceByTypeComplianceCheckIssuesCount = x.evidenceByTypeComplianceCheckIssuesCount
            this.evidenceByTypeConfigurationDataCount = x.evidenceByTypeConfigurationDataCount
            this.evidenceByTypeManualCount = x.evidenceByTypeManualCount
            this.evidenceByTypeUserActivityCount = x.evidenceByTypeUserActivityCount
            this.evidenceResourcesIncludedCount = x.evidenceResourcesIncludedCount
            this.id = x.id
            this.name = x.name
            this.totalEvidence = x.totalEvidence
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.auditmanager.model.AssessmentEvidenceFolder = AssessmentEvidenceFolder(this)
    }
}
