// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents a share request for a custom framework in Audit Manager.
 */
public class AssessmentFrameworkShareRequest private constructor(builder: Builder) {
    /**
     * An optional comment from the sender about the share request.
     */
    public val comment: kotlin.String? = builder.comment
    /**
     * The compliance type that the shared custom framework supports, such as CIS or HIPAA.
     */
    public val complianceType: kotlin.String? = builder.complianceType
    /**
     * The time when the share request was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The number of custom controls that are part of the shared custom framework.
     */
    public val customControlsCount: kotlin.Int? = builder.customControlsCount
    /**
     * The Amazon Web Services account of the recipient.
     */
    public val destinationAccount: kotlin.String? = builder.destinationAccount
    /**
     * The Amazon Web Services Region of the recipient.
     */
    public val destinationRegion: kotlin.String? = builder.destinationRegion
    /**
     * The time when the share request expires.
     */
    public val expirationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.expirationTime
    /**
     * The description of the shared custom framework.
     */
    public val frameworkDescription: kotlin.String? = builder.frameworkDescription
    /**
     * The unique identifier for the shared custom framework.
     */
    public val frameworkId: kotlin.String? = builder.frameworkId
    /**
     * The name of the custom framework that the share request is for.
     */
    public val frameworkName: kotlin.String? = builder.frameworkName
    /**
     * The unique identifier for the share request.
     */
    public val id: kotlin.String? = builder.id
    /**
     * Specifies when the share request was last updated.
     */
    public val lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdated
    /**
     * The Amazon Web Services account of the sender.
     */
    public val sourceAccount: kotlin.String? = builder.sourceAccount
    /**
     * The number of standard controls that are part of the shared custom framework.
     */
    public val standardControlsCount: kotlin.Int? = builder.standardControlsCount
    /**
     * The status of the share request.
     */
    public val status: aws.sdk.kotlin.services.auditmanager.model.ShareRequestStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.auditmanager.model.AssessmentFrameworkShareRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssessmentFrameworkShareRequest(")
        append("comment=$comment,")
        append("complianceType=$complianceType,")
        append("creationTime=$creationTime,")
        append("customControlsCount=$customControlsCount,")
        append("destinationAccount=$destinationAccount,")
        append("destinationRegion=$destinationRegion,")
        append("expirationTime=$expirationTime,")
        append("frameworkDescription=$frameworkDescription,")
        append("frameworkId=$frameworkId,")
        append("frameworkName=$frameworkName,")
        append("id=$id,")
        append("lastUpdated=$lastUpdated,")
        append("sourceAccount=$sourceAccount,")
        append("standardControlsCount=$standardControlsCount,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = comment?.hashCode() ?: 0
        result = 31 * result + (complianceType?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (customControlsCount ?: 0)
        result = 31 * result + (destinationAccount?.hashCode() ?: 0)
        result = 31 * result + (destinationRegion?.hashCode() ?: 0)
        result = 31 * result + (expirationTime?.hashCode() ?: 0)
        result = 31 * result + (frameworkDescription?.hashCode() ?: 0)
        result = 31 * result + (frameworkId?.hashCode() ?: 0)
        result = 31 * result + (frameworkName?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastUpdated?.hashCode() ?: 0)
        result = 31 * result + (sourceAccount?.hashCode() ?: 0)
        result = 31 * result + (standardControlsCount ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssessmentFrameworkShareRequest

        if (comment != other.comment) return false
        if (complianceType != other.complianceType) return false
        if (creationTime != other.creationTime) return false
        if (customControlsCount != other.customControlsCount) return false
        if (destinationAccount != other.destinationAccount) return false
        if (destinationRegion != other.destinationRegion) return false
        if (expirationTime != other.expirationTime) return false
        if (frameworkDescription != other.frameworkDescription) return false
        if (frameworkId != other.frameworkId) return false
        if (frameworkName != other.frameworkName) return false
        if (id != other.id) return false
        if (lastUpdated != other.lastUpdated) return false
        if (sourceAccount != other.sourceAccount) return false
        if (standardControlsCount != other.standardControlsCount) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.auditmanager.model.AssessmentFrameworkShareRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An optional comment from the sender about the share request.
         */
        public var comment: kotlin.String? = null
        /**
         * The compliance type that the shared custom framework supports, such as CIS or HIPAA.
         */
        public var complianceType: kotlin.String? = null
        /**
         * The time when the share request was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of custom controls that are part of the shared custom framework.
         */
        public var customControlsCount: kotlin.Int? = null
        /**
         * The Amazon Web Services account of the recipient.
         */
        public var destinationAccount: kotlin.String? = null
        /**
         * The Amazon Web Services Region of the recipient.
         */
        public var destinationRegion: kotlin.String? = null
        /**
         * The time when the share request expires.
         */
        public var expirationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the shared custom framework.
         */
        public var frameworkDescription: kotlin.String? = null
        /**
         * The unique identifier for the shared custom framework.
         */
        public var frameworkId: kotlin.String? = null
        /**
         * The name of the custom framework that the share request is for.
         */
        public var frameworkName: kotlin.String? = null
        /**
         * The unique identifier for the share request.
         */
        public var id: kotlin.String? = null
        /**
         * Specifies when the share request was last updated.
         */
        public var lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Web Services account of the sender.
         */
        public var sourceAccount: kotlin.String? = null
        /**
         * The number of standard controls that are part of the shared custom framework.
         */
        public var standardControlsCount: kotlin.Int? = null
        /**
         * The status of the share request.
         */
        public var status: aws.sdk.kotlin.services.auditmanager.model.ShareRequestStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.auditmanager.model.AssessmentFrameworkShareRequest) : this() {
            this.comment = x.comment
            this.complianceType = x.complianceType
            this.creationTime = x.creationTime
            this.customControlsCount = x.customControlsCount
            this.destinationAccount = x.destinationAccount
            this.destinationRegion = x.destinationRegion
            this.expirationTime = x.expirationTime
            this.frameworkDescription = x.frameworkDescription
            this.frameworkId = x.frameworkId
            this.frameworkName = x.frameworkName
            this.id = x.id
            this.lastUpdated = x.lastUpdated
            this.sourceAccount = x.sourceAccount
            this.standardControlsCount = x.standardControlsCount
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.auditmanager.model.AssessmentFrameworkShareRequest = AssessmentFrameworkShareRequest(this)
    }
}
