// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model



public class CreateAssessmentReportRequest private constructor(builder: Builder) {
    /**
     * The identifier for the assessment.
     */
    public val assessmentId: kotlin.String? = requireNotNull(builder.assessmentId) { "A non-null value must be provided for assessmentId" }
    /**
     * The description of the assessment report.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the new assessment report.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A SQL statement that represents an evidence finder query.
     *
     * Provide this parameter when you want to generate an assessment report from the results of an evidence finder search query. When you use this parameter, Audit Manager generates a one-time report using only the evidence from the query output. This report does not include any assessment evidence that was manually [added to a report using the console](https://docs.aws.amazon.com/userguide/generate-assessment-report.html#generate-assessment-report-include-evidence), or [associated with a report using the API](https://docs.aws.amazon.com/APIReference-evidenceFinder/API_BatchAssociateAssessmentReportEvidence.html).
     *
     * To use this parameter, the [enablementStatus](https://docs.aws.amazon.com/APIReference-evidenceFinder/API_EvidenceFinderSetup.html#auditmanager-Type-EvidenceFinderSetup-enablementStatus) of evidence finder must be `ENABLED`.
     *
     *  For examples and help resolving `queryStatement` validation exceptions, see [Troubleshooting evidence finder issues](https://docs.aws.amazon.com/audit-manager/latest/userguide/evidence-finder-issues.html#querystatement-exceptions) in the AWS Audit Manager User Guide.
     */
    public val queryStatement: kotlin.String? = builder.queryStatement

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.auditmanager.model.CreateAssessmentReportRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAssessmentReportRequest(")
        append("assessmentId=$assessmentId,")
        append("description=$description,")
        append("name=$name,")
        append("queryStatement=$queryStatement")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assessmentId?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (queryStatement?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAssessmentReportRequest

        if (assessmentId != other.assessmentId) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (queryStatement != other.queryStatement) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.auditmanager.model.CreateAssessmentReportRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier for the assessment.
         */
        public var assessmentId: kotlin.String? = null
        /**
         * The description of the assessment report.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the new assessment report.
         */
        public var name: kotlin.String? = null
        /**
         * A SQL statement that represents an evidence finder query.
         *
         * Provide this parameter when you want to generate an assessment report from the results of an evidence finder search query. When you use this parameter, Audit Manager generates a one-time report using only the evidence from the query output. This report does not include any assessment evidence that was manually [added to a report using the console](https://docs.aws.amazon.com/userguide/generate-assessment-report.html#generate-assessment-report-include-evidence), or [associated with a report using the API](https://docs.aws.amazon.com/APIReference-evidenceFinder/API_BatchAssociateAssessmentReportEvidence.html).
         *
         * To use this parameter, the [enablementStatus](https://docs.aws.amazon.com/APIReference-evidenceFinder/API_EvidenceFinderSetup.html#auditmanager-Type-EvidenceFinderSetup-enablementStatus) of evidence finder must be `ENABLED`.
         *
         *  For examples and help resolving `queryStatement` validation exceptions, see [Troubleshooting evidence finder issues](https://docs.aws.amazon.com/audit-manager/latest/userguide/evidence-finder-issues.html#querystatement-exceptions) in the AWS Audit Manager User Guide.
         */
        public var queryStatement: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.auditmanager.model.CreateAssessmentReportRequest) : this() {
            this.assessmentId = x.assessmentId
            this.description = x.description
            this.name = x.name
            this.queryStatement = x.queryStatement
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.auditmanager.model.CreateAssessmentReportRequest = CreateAssessmentReportRequest(this)
    }
}
