// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The assignment of a control set to a delegate for review.
 */
public class Delegation private constructor(builder: Builder) {
    /**
     * The identifier for the assessment that's associated with the delegation.
     */
    public val assessmentId: kotlin.String? = builder.assessmentId
    /**
     * The name of the assessment that's associated with the delegation.
     */
    public val assessmentName: kotlin.String? = builder.assessmentName
    /**
     * The comment that's related to the delegation.
     */
    public val comment: kotlin.String? = builder.comment
    /**
     * The identifier for the control set that's associated with the delegation.
     */
    public val controlSetId: kotlin.String? = builder.controlSetId
    /**
     * The IAM user or role that created the delegation.
     */
    public val createdBy: kotlin.String? = builder.createdBy
    /**
     * Specifies when the delegation was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The unique identifier for the delegation.
     */
    public val id: kotlin.String? = builder.id
    /**
     * Specifies when the delegation was last updated.
     */
    public val lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdated
    /**
     * The Amazon Resource Name (ARN) of the IAM role.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The type of customer persona.
     *
     * In `CreateAssessment`, `roleType` can only be `PROCESS_OWNER`.
     *
     * In `UpdateSettings`, `roleType` can only be `PROCESS_OWNER`.
     *
     * In `BatchCreateDelegationByAssessment`, `roleType` can only be `RESOURCE_OWNER`.
     */
    public val roleType: aws.sdk.kotlin.services.auditmanager.model.RoleType? = builder.roleType
    /**
     * The status of the delegation.
     */
    public val status: aws.sdk.kotlin.services.auditmanager.model.DelegationStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.auditmanager.model.Delegation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Delegation(")
        append("assessmentId=$assessmentId,")
        append("assessmentName=$assessmentName,")
        append("comment=$comment,")
        append("controlSetId=$controlSetId,")
        append("createdBy=$createdBy,")
        append("creationTime=$creationTime,")
        append("id=$id,")
        append("lastUpdated=$lastUpdated,")
        append("roleArn=$roleArn,")
        append("roleType=$roleType,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assessmentId?.hashCode() ?: 0
        result = 31 * result + (assessmentName?.hashCode() ?: 0)
        result = 31 * result + (comment?.hashCode() ?: 0)
        result = 31 * result + (controlSetId?.hashCode() ?: 0)
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastUpdated?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (roleType?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Delegation

        if (assessmentId != other.assessmentId) return false
        if (assessmentName != other.assessmentName) return false
        if (comment != other.comment) return false
        if (controlSetId != other.controlSetId) return false
        if (createdBy != other.createdBy) return false
        if (creationTime != other.creationTime) return false
        if (id != other.id) return false
        if (lastUpdated != other.lastUpdated) return false
        if (roleArn != other.roleArn) return false
        if (roleType != other.roleType) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.auditmanager.model.Delegation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier for the assessment that's associated with the delegation.
         */
        public var assessmentId: kotlin.String? = null
        /**
         * The name of the assessment that's associated with the delegation.
         */
        public var assessmentName: kotlin.String? = null
        /**
         * The comment that's related to the delegation.
         */
        public var comment: kotlin.String? = null
        /**
         * The identifier for the control set that's associated with the delegation.
         */
        public var controlSetId: kotlin.String? = null
        /**
         * The IAM user or role that created the delegation.
         */
        public var createdBy: kotlin.String? = null
        /**
         * Specifies when the delegation was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The unique identifier for the delegation.
         */
        public var id: kotlin.String? = null
        /**
         * Specifies when the delegation was last updated.
         */
        public var lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The type of customer persona.
         *
         * In `CreateAssessment`, `roleType` can only be `PROCESS_OWNER`.
         *
         * In `UpdateSettings`, `roleType` can only be `PROCESS_OWNER`.
         *
         * In `BatchCreateDelegationByAssessment`, `roleType` can only be `RESOURCE_OWNER`.
         */
        public var roleType: aws.sdk.kotlin.services.auditmanager.model.RoleType? = null
        /**
         * The status of the delegation.
         */
        public var status: aws.sdk.kotlin.services.auditmanager.model.DelegationStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.auditmanager.model.Delegation) : this() {
            this.assessmentId = x.assessmentId
            this.assessmentName = x.assessmentName
            this.comment = x.comment
            this.controlSetId = x.controlSetId
            this.createdBy = x.createdBy
            this.creationTime = x.creationTime
            this.id = x.id
            this.lastUpdated = x.lastUpdated
            this.roleArn = x.roleArn
            this.roleType = x.roleType
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.auditmanager.model.Delegation = Delegation(this)
    }
}
