// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.auditmanager.model



/**
 * The settings object that specifies whether evidence finder is enabled. This object also describes the related event data store, and the backfill status for populating the event data store with evidence data.
 */
public class EvidenceFinderEnablement private constructor(builder: Builder) {
    /**
     * The current status of the evidence data backfill process.
     *
     * The backfill starts after you enable evidence finder. During this task, Audit Manager populates an event data store with your past evidence data so that your evidence can be queried.
     * + `NOT_STARTED` means that the backfill hasn’t started yet.
     * + `IN_PROGRESS` means that the backfill is in progress. This can take up to 24 hours to complete, depending on the amount of evidence data.
     * + `COMPLETED` means that the backfill is complete. All of your past evidence is now queryable.
     */
    public val backfillStatus: aws.sdk.kotlin.services.auditmanager.model.EvidenceFinderBackfillStatus? = builder.backfillStatus
    /**
     * The current status of the evidence finder feature and the related event data store.
     * + `ENABLE_IN_PROGRESS` means that you requested to enable evidence finder. An event data store is currently being created to support evidence finder queries.
     * + `ENABLED` means that an event data store was successfully created and evidence finder is enabled. We recommend that you wait 24 hours until the event data store is backfilled with your past evidence data. You can use evidence finder in the meantime, but not all data might be available until the backfill is complete.
     * + `DISABLE_IN_PROGRESS` means that you requested to disable evidence finder, and your request is pending the deletion of the event data store.
     * + `DISABLED` means that you have permanently disabled evidence finder and the event data store has been deleted. You can't re-enable evidence finder after this point.
     */
    public val enablementStatus: aws.sdk.kotlin.services.auditmanager.model.EvidenceFinderEnablementStatus? = builder.enablementStatus
    /**
     * Represents any errors that occurred when enabling or disabling evidence finder.
     */
    public val error: kotlin.String? = builder.error
    /**
     * The Amazon Resource Name (ARN) of the CloudTrail Lake event data store that’s used by evidence finder. The event data store is the lake of evidence data that evidence finder runs queries against.
     */
    public val eventDataStoreArn: kotlin.String? = builder.eventDataStoreArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.auditmanager.model.EvidenceFinderEnablement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EvidenceFinderEnablement(")
        append("backfillStatus=$backfillStatus,")
        append("enablementStatus=$enablementStatus,")
        append("error=$error,")
        append("eventDataStoreArn=$eventDataStoreArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = backfillStatus?.hashCode() ?: 0
        result = 31 * result + (enablementStatus?.hashCode() ?: 0)
        result = 31 * result + (error?.hashCode() ?: 0)
        result = 31 * result + (eventDataStoreArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EvidenceFinderEnablement

        if (backfillStatus != other.backfillStatus) return false
        if (enablementStatus != other.enablementStatus) return false
        if (error != other.error) return false
        if (eventDataStoreArn != other.eventDataStoreArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.auditmanager.model.EvidenceFinderEnablement = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The current status of the evidence data backfill process.
         *
         * The backfill starts after you enable evidence finder. During this task, Audit Manager populates an event data store with your past evidence data so that your evidence can be queried.
         * + `NOT_STARTED` means that the backfill hasn’t started yet.
         * + `IN_PROGRESS` means that the backfill is in progress. This can take up to 24 hours to complete, depending on the amount of evidence data.
         * + `COMPLETED` means that the backfill is complete. All of your past evidence is now queryable.
         */
        public var backfillStatus: aws.sdk.kotlin.services.auditmanager.model.EvidenceFinderBackfillStatus? = null
        /**
         * The current status of the evidence finder feature and the related event data store.
         * + `ENABLE_IN_PROGRESS` means that you requested to enable evidence finder. An event data store is currently being created to support evidence finder queries.
         * + `ENABLED` means that an event data store was successfully created and evidence finder is enabled. We recommend that you wait 24 hours until the event data store is backfilled with your past evidence data. You can use evidence finder in the meantime, but not all data might be available until the backfill is complete.
         * + `DISABLE_IN_PROGRESS` means that you requested to disable evidence finder, and your request is pending the deletion of the event data store.
         * + `DISABLED` means that you have permanently disabled evidence finder and the event data store has been deleted. You can't re-enable evidence finder after this point.
         */
        public var enablementStatus: aws.sdk.kotlin.services.auditmanager.model.EvidenceFinderEnablementStatus? = null
        /**
         * Represents any errors that occurred when enabling or disabling evidence finder.
         */
        public var error: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the CloudTrail Lake event data store that’s used by evidence finder. The event data store is the lake of evidence data that evidence finder runs queries against.
         */
        public var eventDataStoreArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.auditmanager.model.EvidenceFinderEnablement) : this() {
            this.backfillStatus = x.backfillStatus
            this.enablementStatus = x.enablementStatus
            this.error = x.error
            this.eventDataStoreArn = x.eventDataStoreArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.auditmanager.model.EvidenceFinderEnablement = EvidenceFinderEnablement(this)
    }
}
